/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleManager;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.help.CSH;

public class NewAppDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NewAppDialog.class);
    private static final String DIALOG_TITLE = localStrings.getLocalString("ui.newappdialog.title", "New Application");
    private static final String DIALOG_ACC_DESC = localStrings.getLocalString("at.newappdialog.acc_desc", "Dialog to create a new Application. Please enter application name with path and display name");
    private static final String BROWSER_TITLE = DIALOG_TITLE;
    private static final String FILE_NAME = localStrings.getLocalString("ui.newappdialog.location", "Application File Name:");
    private static final String FILE_NAME_TOOLTIP = localStrings.getLocalString("at.applicationgeneralinspector.location_label.tooltip", "Application name including path");
    private static final String DISPLAY_NAME = localStrings.getLocalString("ui.newappdialog.appname", "Application Display Name:");
    private static final String DISPLAY_NAME_TOOLTIP = localStrings.getLocalString("at.applicationgeneralinspector.display_name_label.tooltip", "Display name of Application");
    private static final String helpSetMapID = "NewApp";
    private UITitledTextField appDisplayName = null;
    private UITitledTextField appArchiveFileName = null;
    private Application newApplication = null;
    private static NewAppDialog dialog = null;

    private static String ERROR_CREATING(String v0) {
        return localStrings.getLocalString("ui.newappdialog.error_creating_new_app", "Error creating new application: {0}", new Object[]{v0});
    }

    public static Application createNewApplication() {
        if (dialog == null) {
            dialog = new NewAppDialog(DT.getApplicationFrame());
        }
        return dialog._createNewApplication();
    }

    private NewAppDialog(Frame owner) {
        super(owner != null ? owner : DT.getApplicationFrame(), true);
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initLayout();
    }

    private void initLayout() {
        this.setTitle(DIALOG_TITLE);
        this.getAccessibleContext().setAccessibleName(DIALOG_TITLE);
        this.getAccessibleContext().setAccessibleDescription(DIALOG_ACC_DESC);
        UIControlButtonBox content = new UIControlButtonBox(null, false);
        content.setControlButtonLocation(101);
        this.setContentPane(content);
        UITitledBox textFields = new UITitledBox(null, false);
        content.setView(textFields);
        textFields.getGBConstraints().insets = new Insets(3, 5, 3, 5);
        this.appArchiveFileName = new UITitledTextField(FILE_NAME, false);
        this.appArchiveFileName.setToolTipText(FILE_NAME_TOOLTIP);
        this.appArchiveFileName.setBrowserActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NewAppDialog.this.browseApplicationName();
            }
        });
        textFields.addWithGBConstraints(this.appArchiveFileName);
        String dir = UIConfig.getStartingDirectory().getPath();
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        this.appArchiveFileName.setText(dir);
        this.appDisplayName = new UITitledTextField(DISPLAY_NAME, false);
        this.appDisplayName.setToolTipText(DISPLAY_NAME_TOOLTIP);
        textFields.addWithGBConstraints(this.appDisplayName);
        UIButton okBtn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewAppDialog.this.okAction();
            }
        });
        content.addControlButton(okBtn);
        okBtn.makeDefaultButton(true);
        UIButton canBtn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewAppDialog.this.hide();
            }
        });
        content.addControlButton(canBtn);
        UIHelpButton help_btn = new UIHelpButton(helpSetMapID);
        content.addControlButton(help_btn);
        Rectangle pb = this.getOwner().getBounds();
        this.setBounds(pb.x + 20, pb.y + 20, 420, 180);
    }

    private Application _createNewApplication() {
        this.appDisplayName.setText("");
        this.newApplication = null;
        this.show();
        return this.newApplication;
    }

    private void browseApplicationName() {
        File entry = new File(this.appArchiveFileName.getText());
        File dir = entry.isDirectory() ? entry : entry.getParentFile();
        UIFileChooser chooser = UIFileChooser.getFileChooser(dir, "EarFiles");
        int rtn = chooser.showDialog(this, BROWSER_TITLE);
        if (rtn == 0) {
            this.appArchiveFileName.setText(chooser.getSelectedFile().getAbsolutePath());
            this.getDisplayName(true);
        }
    }

    private String getDisplayName(boolean reset) {
        String dn;
        String string = dn = reset ? "" : this.appDisplayName.getText();
        if (dn.equals("")) {
            String fn;
            String fp = this.appArchiveFileName.getText();
            int fs = fp.lastIndexOf(File.separator);
            String string2 = fs >= 0 ? (fs >= fp.length() - 1 ? "" : fp.substring(fs + 1)) : (fn = fp);
            dn = fn.length() <= 1 ? fn : (fn.toLowerCase().endsWith(".ear") ? fn.substring(0, fn.length() - ".ear".length()) : (fn.lastIndexOf(".") > 0 ? fn.substring(0, fn.lastIndexOf(".")) : fn));
            this.appDisplayName.setText(dn);
        }
        return dn;
    }

    private void okAction() {
        if (!this.isVisible()) {
            Print.dprintStackTrace((String)"Dialog is not visible!");
            return;
        }
        if (this.appArchiveFileName.getText().equals("")) {
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.newappdialog.no_app_location", "You must fill in the location to add an application."));
            return;
        }
        String archName = this.appArchiveFileName.getText();
        if (!archName.toLowerCase().endsWith(".ear")) {
            archName = archName + ".ear";
        }
        if (!FileTools.validateFileName(this, archName)) {
            return;
        }
        File archFile = new File(archName);
        if (!FileTools.checkFileOverwrite((Component)this, archFile)) {
            return;
        }
        if (archFile.exists()) {
            ModuleManager modMgr = DT.getModuleManager();
            modMgr.removeModule(modMgr.getModuleWithJar(archFile));
            archFile.delete();
        }
        try {
            String dispName = this.getDisplayName(false);
            String fileName = archFile.getCanonicalPath();
            this.newApplication = DT.getModuleManager().createNewApplication(dispName, fileName);
            UIConfig.addStartingDirectory(archFile.getParentFile());
            UIConfig.saveConfig();
            this.hide();
        }
        catch (IOException ioe) {
            UIOptionPane.showErrorDialog(this, NewAppDialog.ERROR_CREATING(ioe.getMessage()));
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 180);
    }
}

