/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.InspectorManager;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTabbedPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.util.List;

public class UIUtils {
    private static final String EXCEPTION_LOG_FILE = "DTException.log";
    private static long startTime = 0L;

    public static String constructMessage(List errors) {
        if (errors != null && errors.size() > 0) {
            return errors.get(0).toString();
        }
        return "";
    }

    public static void debugPrintln(String msg) {
        Print.dprintln(null, (int)1, (String)msg);
    }

    public static void debugPrintln(int subFrame, String msg) {
        Print.dprintln(null, (int)(subFrame + 1), (String)msg);
    }

    public static boolean debugMode() {
        return UIConfig.debugMode();
    }

    public static void print(String msg) {
        Print.print(null, (String)msg);
    }

    public static void println(String msg) {
        Print.println(null, (int)-1, (String)msg);
    }

    public static void printImplementationError(String m) {
        Print.printStackTrace(null, (int)1, (String)"Implementation Error", (String)m, null);
    }

    public static void debugImplementationError(String m) {
        Print.dprintStackTrace(null, (int)1, (String)"(DEBUG) Implementation Error", (String)m, null);
    }

    public static void debugLogStackTrace(String m) {
        Print.dprintStackTrace(null, (int)1, (String)"(DEBUG) Stack Trace", (String)m, null);
    }

    public static void printException(String msg, Throwable t) {
        Print.printStackTrace(null, (int)1, (String)"Exception", (String)msg, (Throwable)t);
    }

    public static void debugLogStackTrace(String m, Throwable t) {
        Print.dprintStackTrace(null, (int)1, (String)"(DEBUG) Exception", (String)m, (Throwable)t);
    }

    public static void debugImplementationError(String m, Throwable t) {
        Print.dprintStackTrace(null, (int)1, (String)"(DEBUG) Implementation Error", (String)m, (Throwable)t);
    }

    public static void printImplementationError(String m, Throwable t) {
        Print.printStackTrace(null, (int)1, (String)"Implementation Error", (String)m, (Throwable)t);
    }

    public static File getExceptionLogFile() {
        return new File(UIConfig.getTempDirectory(), EXCEPTION_LOG_FILE);
    }

    public static void testPrintln(String msg) {
        if (UIConfig.testMode()) {
            Print.println(null, (int)1, (String)msg);
        }
    }

    public static String debugClassName(Object obj) {
        return DT.className(obj);
    }

    public static void debugStatus() {
        if (!UIConfig.debugMode()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Descriptor desc = DT.getSelectedDescriptor();
        sb.append("  Descriptor : " + UIUtils.entClassName(desc) + "\n");
        InspectorManager inspMgr = DT.getInspectorManager();
        InspectorTabbedPane insp = inspMgr.getCurrentInspector();
        sb.append("  Tab Manager: " + UIUtils.uiClassName(insp) + "\n");
        if (insp != null) {
            InspectorPane pane = insp.getCurrentInspectorPane();
            sb.append("  Inspector  : " + UIUtils.uiClassName(pane) + "\n");
            Descriptor paned = insp.getDescriptor();
            if (paned != desc) {
                sb.append("  Insp-Desc  : " + UIUtils.entClassName(paned) + "\n");
            }
        }
        Print.dprintln((String)("\n" + sb.toString()));
    }

    private static String uiClassName(Object obj) {
        return UIUtils.getClassName(obj, ".ui.").replace('.', File.separatorChar);
    }

    private static String entClassName(Object obj) {
        return UIUtils.getClassName(obj, ".enterprise.").replace('.', File.separatorChar);
    }

    private static String getClassName(Object obj, String sub) {
        if (obj == null) {
            return "null";
        }
        String cn = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName();
        int p = cn.indexOf(sub);
        return p < 0 ? cn : cn.substring(p + sub.length());
    }

    public static void debugPrintLapseTime(String msg) {
        if (startTime == 0L) {
            startTime = System.currentTimeMillis();
        }
        long now = System.currentTimeMillis();
        Print.println((String)("[LapseTime=" + (now - startTime) + "ms] " + msg));
    }
}

