/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.tools.deployment.ui.UIFactory;
import com.sun.enterprise.tools.deployment.ui.shared.DTRoleMapperFactory;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.TeeOutputStream;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Main {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Main.class);
    private static String UI_STARTUP_MESSAGE = localStrings.getLocalString("ui.main.startup_message", "Starting Deploytool, version {0}", new Object[]{"8"});
    public static final String UIFACTORY_CLASS = "com.sun.enterprise.tools.deployment.ui.DT";

    private static String MISSING_OPTION_ARG(Object v0, Object v1) {
        return localStrings.getLocalString("ui.main.missing_option_argument", "Missing {0} argument (''{1}'' ignored)", new Object[]{v0, v1});
    }

    private static String UNSUPPORTED_OPTION(Object v0) {
        return localStrings.getLocalString("ui.main.unsupported_option", "Unsupported option: ''{0}'' (ignored)", new Object[]{v0});
    }

    public static void main(String[] argv) {
        Print.println((String)UI_STARTUP_MESSAGE);
        String defaultLogFile = System.getProperty("com.sun.aas.defaultLogFile");
        if (defaultLogFile != null) {
            File outputFile = new File(defaultLogFile);
            try {
                File parentFile = new File(outputFile.getParent());
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                outputFile.createNewFile();
                if (!outputFile.canWrite()) {
                    Print.println((String)localStrings.getLocalString("at.main.cant_write_to_logfile", "Can''t write to the logFile {0}.  This session will not be logged.", new Object[]{defaultLogFile}));
                } else {
                    FileOutputStream logStream = new FileOutputStream(defaultLogFile, true);
                    System.setOut(new TeeOutputStream((OutputStream)logStream, System.out));
                    System.setErr(new TeeOutputStream((OutputStream)logStream, System.err));
                }
            }
            catch (IOException ioe) {
                Print.printStackTrace((String)localStrings.getLocalString("at.main.cant_create_logfile", "Can''t create the logFile {0}.  This session will not be logged.", new Object[]{defaultLogFile}), (Throwable)ioe);
            }
        }
        try {
            Main.startUI(argv);
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"UI Startup", (Throwable)t);
            Print.println((String)localStrings.getLocalString("at.main.error_creating_ui", "Unable to create UI: {0}", new Object[]{t.toString()}));
        }
    }

    private static void startUI(String[] argv) throws Throwable {
        Class<?> uiFactoryClass;
        if (!UIFactory.class.isAssignableFrom(uiFactoryClass = Class.forName(UIFACTORY_CLASS))) {
            throw new ClassCastException("Class doesn't implement UIFactory");
        }
        UIFactory ui = (UIFactory)uiFactoryClass.newInstance();
        ListTools.ArrayIterator argIter = ListTools.toIterator(argv);
        while (argIter.hasNext()) {
            Main.parseOption(ui, argIter);
        }
        Main.registerRoleMapperFactory();
        ui.startUI();
    }

    private static boolean parseOption(UIFactory ui, ListTools.ArrayIterator argi) {
        String opt = (String)argi.next();
        String optArg = null;
        int optDel = opt.indexOf("=");
        if (optDel >= 0) {
            optArg = optDel + 1 < opt.length() ? opt.substring(optDel + 1) : "";
            opt = opt.substring(0, optDel);
        }
        if (opt.equalsIgnoreCase("-userdir") || opt.equalsIgnoreCase("--userdir")) {
            String arg;
            String string = arg = optArg != null ? optArg : Main.getOptArg(argi);
            if (arg != null) {
                File userDir = new File(arg);
                if (userDir.isDirectory()) {
                    Print.println((String)localStrings.getLocalString("ui.main.set_userdir", "UserDirectory set to {0}", new Object[]{userDir}));
                    ui.setUserDirectory(userDir);
                    return true;
                }
                Print.println((String)localStrings.getLocalString("ui.main.invalid_userdir", "Specified UserDirectory is invalid: {0} (option ignored)", new Object[]{arg}));
            } else {
                Print.println((String)Main.MISSING_OPTION_ARG("<userdir>", opt));
            }
            return false;
        }
        if (opt.equalsIgnoreCase("-conf") || opt.equalsIgnoreCase("--conf")) {
            String arg;
            String string = arg = optArg != null ? optArg : Main.getOptArg(argi);
            if (arg != null) {
                System.setProperty("ui.configFilename", arg);
                return true;
            }
            Print.println((String)Main.MISSING_OPTION_ARG("<conf>", opt));
            return false;
        }
        if (opt.equalsIgnoreCase("-debug") || opt.equalsIgnoreCase("--debug")) {
            String arg = optArg != null ? optArg : Main.getOptArg(argi);
            boolean val = arg == null ? true : UIConfig.BooleanValue(arg, false);
            System.setProperty("ui.debugMode", String.valueOf(val));
            return true;
        }
        if (opt.equalsIgnoreCase("-test") || opt.equalsIgnoreCase("--test")) {
            String arg = optArg != null ? optArg : Main.getOptArg(argi);
            boolean val = arg == null ? true : UIConfig.BooleanValue(arg, false);
            System.setProperty("ui.testMode", String.valueOf(val));
            return true;
        }
        if (opt.equalsIgnoreCase("verbose")) {
            return true;
        }
        Print.println((String)Main.UNSUPPORTED_OPTION(opt));
        return false;
    }

    private static String getOptArg(ListTools.ArrayIterator argi) {
        if (!argi.hasNext()) {
            return null;
        }
        String a = (String)argi.peekNext();
        return a != null && a.startsWith("-") ? null : (String)argi.next();
    }

    private static void registerRoleMapperFactory() {
        SaxParserHandler sph = new SaxParserHandler();
        DTRoleMapperFactory srmf = new DTRoleMapperFactory();
        SecurityRoleMapperFactoryMgr.registerFactory((SecurityRoleMapperFactory)srmf);
    }
}

