/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.dtv.ProxyDescriptor;
import com.sun.enterprise.tools.deployment.ui.server.DeployedAppDescriptor;
import com.sun.enterprise.tools.deployment.ui.server.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.NullInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTabbedPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class InspectorManager {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InspectorManager.class);
    protected static final int INSP_DEFAULT = 0;
    protected static final int INSP_RDONLY = 1;
    protected static final int INSP_SETTINGS = 2;
    private Hashtable[] inspRegister = null;
    private Descriptor currentDescriptor = null;
    private InspectorTabbedPane currentInspector = null;

    public InspectorTabbedPane createNewInspector(Class inspClass, String mode) {
        if (inspClass == null) {
            return new NullInspector();
        }
        Method newInsp = null;
        try {
            newInsp = inspClass.getMethod("newInspector", String.class);
        }
        catch (Exception ex) {
            Print.printStackTrace((String)(inspClass.getName() + ".newInspector(String) not implemented"), (Throwable)ex);
            return null;
        }
        try {
            return (InspectorTabbedPane)newInsp.invoke(null, mode);
        }
        catch (InvocationTargetException ite) {
            Print.printStackTrace((String)(inspClass.getName() + ".newInspector(String) invocation error"), (Throwable)ite.getCause());
            return null;
        }
        catch (Throwable t) {
            Print.printStackTrace((String)(inspClass.getName() + ".newInspector(String) invocation error"), (Throwable)t);
            return null;
        }
    }

    public InspectorManager() {
        this.registerDefaultInspectors();
    }

    protected Hashtable getRegister(int inspMode) {
        if (this.inspRegister == null) {
            this.inspRegister = new Hashtable[3];
        }
        if (inspMode < 0 || inspMode >= this.inspRegister.length) {
            return null;
        }
        if (this.inspRegister[inspMode] == null) {
            this.inspRegister[inspMode] = new Hashtable();
        }
        return this.inspRegister[inspMode];
    }

    protected void registerDefaultInspectors() {
        String UI = UIConfig.UI_PACKAGE;
        this.registerInspector(0, Application.class, UI + "app.ApplicationInspector");
        this.registerInspector(0, WebBundleDescriptor.class, UI + "war.WebAppInspector");
        this.registerInspector(0, WebComponentDescriptor.class, UI + "war.WebComponentInspector");
        this.registerInspector(0, EjbBundleDescriptor.class, UI + "ejb.EjbJarInspector");
        this.registerInspector(0, EjbEntityDescriptor.class, UI + "ejb.EjbComponentInspector");
        this.registerInspector(0, EjbCMPEntityDescriptor.class, UI + "ejb.EjbComponentInspector");
        this.registerInspector(0, EjbMessageBeanDescriptor.class, UI + "ejb.EjbComponentInspector");
        this.registerInspector(0, EjbSessionDescriptor.class, UI + "ejb.EjbComponentInspector");
        this.registerInspector(0, ApplicationClientDescriptor.class, UI + "appc.AppClientInspector");
        this.registerInspector(0, ConnectorDescriptor.class, UI + "rar.ResourceAdapterJarInspector");
        this.registerInspector(0, ServerDescriptor.class, UI + "server.ServerInspector");
        this.registerInspector(0, DeployedAppDescriptor.class, UI + "deploy.DeployedAppInspector");
    }

    public void registerInspector(Class descClass, String inspClassName) {
        this.registerInspector(0, descClass, inspClassName);
    }

    public void registerInspector(int inspMode, Class descClass, String inspClassName) {
        this.getRegister(inspMode).put(descClass, new RegisteredInspector(descClass, inspClassName));
    }

    public Descriptor getCurrentDescriptor() {
        return this.currentDescriptor;
    }

    public InspectorTabbedPane getCurrentInspector() {
        return this.currentInspector;
    }

    public boolean isCurrentInspector(InspectorTabbedPane itp) {
        if (itp == null) {
            Print.dprintln((String)"InspectorTabbedPane is null");
            return false;
        }
        if (this.currentInspector != itp) {
            Throwable t = this.getInvocationStackTrace();
            String msg = "InspectorTabbedPane (" + DT.className(itp) + ") doesn't match current: " + DT.className(this.currentInspector);
            if (t != null) {
                // empty if block
            }
            return false;
        }
        if (this.currentDescriptor != itp.getDescriptor()) {
            String n1 = DescriptorTools.getDisplayName(this.currentDescriptor);
            String n2 = DescriptorTools.getDisplayName(itp.getDescriptor());
            Print.dprintStackTrace((String)("Descriptor doesn't match current: " + n1 + " vs " + n2));
            return false;
        }
        return true;
    }

    private Throwable getInvocationStackTrace() {
        Throwable t = InspectorTabbedPane.getDeferredNotificationStackTrace();
        if (t == null) {
            t = InspectorPane.getDeferredRefreshStackTrace();
        }
        return t;
    }

    public InspectorTabbedPane initializeInspectorFor(Descriptor obj) {
        NullInspector inspector = null;
        int inspMode = 0;
        Descriptor desc = null;
        if (obj instanceof ProxyDescriptor) {
            obj = desc = ((ProxyDescriptor)obj).getDescriptor();
        } else {
            desc = obj;
        }
        if (inspector == null) {
            if (obj == null) {
                inspector = new NullInspector();
            } else {
                Class<?> objCls = obj.getClass();
                RegisteredInspector regInsp = null;
                for (Class<?> c = objCls; regInsp == null && c != null; c = c.getSuperclass()) {
                    regInsp = (RegisteredInspector)this.getRegister(inspMode).get(c);
                    if (regInsp == null || c == objCls) continue;
                    RegisteredInspector newReg = new RegisteredInspector(objCls, regInsp);
                    this.getRegister(inspMode).put(objCls, newReg);
                    regInsp = newReg;
                }
                InspectorTabbedPane inspectorTabbedPane = inspector = regInsp != null ? regInsp.getInspector("DeploymentMode") : null;
                if (inspector == null) {
                    Print.dprintln((String)("No inspector found for class: " + DT.className(objCls)));
                    inspector = new NullInspector();
                }
            }
        }
        this.currentDescriptor = desc;
        this.currentInspector = inspector;
        this.currentInspector.resetDescriptor(this.currentDescriptor);
        return this.currentInspector;
    }

    public boolean isValidInspector(InspectorTabbedPane c) {
        return !(c instanceof NullInspector);
    }

    private class RegisteredInspector {
        private Class descClass = null;
        private String inspClassName = null;
        private Class inspClass = null;
        private int mode = 0;
        private InspectorTabbedPane inspInstance = null;

        public RegisteredInspector(Class descClass, RegisteredInspector other) {
            this.descClass = descClass;
            this.inspClassName = other.inspClassName;
            this.inspClass = other.inspClass;
            this.mode = other.mode;
        }

        public RegisteredInspector(Class descClass, String inspClassName) {
            this(descClass, inspClassName, 0);
        }

        public RegisteredInspector(Class descClass, String inspClassName, int mode) {
            this.descClass = descClass;
            this.inspClassName = inspClassName;
            this.mode = mode;
        }

        public Class getDescriptorClass() {
            return this.descClass;
        }

        public String getInspectorClassname() {
            return this.inspClassName;
        }

        public Class getInspectorClass() {
            if (this.inspClass == null && this.inspClassName != null) {
                try {
                    this.inspClass = Class.forName(this.inspClassName);
                }
                catch (Exception ex) {
                    Print.printStackTrace((String)("Unable to find class - " + this.inspClassName), (Throwable)ex);
                    this.inspClass = null;
                }
            }
            return this.inspClass;
        }

        public InspectorTabbedPane getInspector(String mode) {
            if (this.inspInstance == null) {
                this.inspInstance = InspectorManager.this.createNewInspector(this.getInspectorClass(), mode);
            }
            return this.inspInstance;
        }
    }
}

