/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.InspectorManager;
import com.sun.enterprise.tools.deployment.ui.UIFactory;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentManager;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentManagerImpl;
import com.sun.enterprise.tools.deployment.ui.server.DTServerManager;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleManager;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleManagerImpl;
import com.sun.enterprise.tools.deployment.ui.sunone.SunONESettingsDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButtonEnabler;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIMenu;
import com.sun.enterprise.util.Print;
import java.awt.Frame;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class DT
implements UIFactory {
    public static final String ENABLER_None = "";
    public static final String STAT_SelectedDescriptor = "?CurrentDescriptor";
    public static final String STAT_SelectedModule = "?CurrentModule";
    public static final String STAT_SelectedBundle = "?CurrentBundle";
    public static final String STAT_IsDirty = "?IsDirty:Descriptor";
    public static final String CMD_OpenModule = "!OpenModule:File";
    public static final String CMD_CloseModule = "!CloseModule:Descriptor";
    public static final String CMD_SetDirty = "!SetDirty:Descriptor";
    public static final String CMD_TabValidationChanged = "!TabValidation";
    public static final String MENU_About = "!About";
    public static final String MENU_Script_ = "!Script_";
    public static final String MENU_BrowseURL_ = "!BrowseURL_";
    public static final String MENU_EditSearchPaths = "!EditSearchPaths";
    public static final String MENU_Update = "!Update";
    public static final String MENU_Deploy = "!Deploy";
    public static final String MENU_Undeploy = "!Undeploy";
    public static final String MENU_UpdateRedeploy = "!UpdateRedeploy";
    public static final String MENU_Verifier = "!Verifier";
    public static final String MENU_CloneInspector = "!CloneInspector";
    public static final String MENU_EditRoles = "!EditRoles";
    public static final String MENU_EditUsers = "!EditUsers";
    public static final String MENU_DescViewer = "!DescViewer";
    public static final String MENU_S1DescViewer = "!S1DescViewer";
    public static final String MENU_Cut = "!Cut";
    public static final String MENU_Copy = "!Copy";
    public static final String MENU_Paste = "!Paste";
    public static final String MENU_Delete = "!Delete";
    public static final String MENU_Preferences = "!Preferences";
    public static final String MENU_NewApplication = "!NewApplication";
    public static final String MENU_NewAppClient = "!NewAppClient";
    public static final String MENU_NewEJB = "!NewEJB";
    public static final String MENU_NewWAR = "!NewWAR";
    public static final String MENU_NewRAR = "!NewRAR";
    public static final String MENU_JAXRPC = "!JAXRPC";
    public static final String MENU_NewWebService = "!WebService";
    public static final String MENU_EditAppClient = "!EditAppClient";
    public static final String MENU_EditEJB = "!EditEJB";
    public static final String MENU_EditWAR = "!EditWAR";
    public static final String MENU_EditRAR = "!EditRAR";
    public static final String MENU_AddAppClient = "!AddAppClient";
    public static final String MENU_AddEJB = "!AddEJB";
    public static final String MENU_AddWAR = "!AddWAR";
    public static final String MENU_AddRAR = "!AddRAR";
    public static final String MENU_Open = "!Open";
    public static final String MENU_Close = "!Close";
    public static final String MENU_AddServer = "!AddServer";
    public static final String MENU_RemoveServer = "!RemoveServer";
    public static final String MENU_SetTargetServer = "!SetTargetServer";
    public static final String MENU_Save = "!Save";
    public static final String MENU_SaveAll = "!SaveAll";
    public static final String MENU_SaveAs = "!SaveAs";
    public static final String MENU_DeploySetsNew = "!DepSetsNew";
    public static final String MENU_DeploySetsEdit = "!DepSetsEdit";
    public static final String MENU_DeploySetsClose = "!DepSetsClose";
    public static final String MENU_DeployMgrSettings = "!DepMgrSets";
    public static final String MENU_Exit = "!Exit";
    private static Hashtable actionMap = new Hashtable();
    private static int actionSequence = 0;
    private static Comparator actionEntryComparator = null;
    private Object uiInstance = null;
    public static DT GlobalUI = null;
    private boolean _didLoadConfig = false;
    private static Frame frameOwner = null;
    private static DeploymentManager deployManager = null;
    private static SunONESettingsDialog sunOneSettingsDialog = null;
    private static DTServerManager serverManager = null;
    private static ModuleManager moduleManager = null;
    private static InspectorManager inspectorManager = null;
    public static final String DOT_EAR = ".ear";
    public static final String DOT_WAR = ".war";
    public static final String DOT_RAR = ".rar";
    public static final String DOT_JAR = ".jar";
    private static String uiPackage = null;
    public static final int OS_UNKNOWN = 0;
    public static final int OS_SOLARIS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_MAC = 3;
    public static final int OS_WINDOWS = 4;

    private static ActionEntry getActionEntry(String actionKey) {
        return actionKey != null && actionMap != null ? (ActionEntry)actionMap.get(actionKey) : null;
    }

    public static boolean hasAction(String actionKey) {
        return DT.getActionEntry(actionKey) != null;
    }

    public static void registerAction(String actionKey, UIActionDispatcher action) {
        DT.registerAction(actionKey, action, (UIButtonEnabler.EnablerKey[])null, null, null, null);
    }

    public static void registerAction(String actionKey, UIActionDispatcher action, UIButtonEnabler.EnablerKey enableKey, String title, String btnIcon, KeyStroke accel) {
        UIButtonEnabler.EnablerKey[] enablerKeyArray;
        if (enableKey != null) {
            UIButtonEnabler.EnablerKey[] enablerKeyArray2 = new UIButtonEnabler.EnablerKey[1];
            enablerKeyArray = enablerKeyArray2;
            enablerKeyArray2[0] = enableKey;
        } else {
            enablerKeyArray = null;
        }
        UIButtonEnabler.EnablerKey[] ekey = enablerKeyArray;
        DT.registerAction(actionKey, action, ekey, title, btnIcon, accel);
    }

    public static void registerAction(String actionKey, UIActionDispatcher action, UIButtonEnabler.EnablerKey[] enableKey, String title, String btnIcon, KeyStroke accel) {
        if (actionKey != null) {
            if (action != null) {
                if (actionMap == null) {
                    actionMap = new Hashtable();
                }
                ActionEntry ae = new ActionEntry(actionKey, action, enableKey, title, btnIcon, accel);
                actionMap.put(actionKey, ae);
            } else if (actionMap != null) {
                actionMap.remove(actionKey);
            }
        }
    }

    public static void updateRegisteredAction(String actionKey, UIActionDispatcher action, UIButtonEnabler.EnablerKey[] enableKey, String title, String btnIcon, KeyStroke accel) {
        if (actionKey != null) {
            ActionEntry ae = DT.getActionEntry(actionKey);
            if (ae != null) {
                if (action != null) {
                    ae.setAction(action);
                }
                if (enableKey != null) {
                    ae.setEnableKey(enableKey);
                }
                if (title != null) {
                    ae.setTitle(title);
                }
                if (btnIcon != null) {
                    ae.setButtonIcon(btnIcon);
                }
                if (accel != null) {
                    ae.setKeyStroke(accel);
                }
            } else {
                Print.dprintln((String)("No action for key: " + actionKey));
            }
        }
    }

    public static UIActionDispatcher invokeAction(String key) {
        if (key != null) {
            ActionEntry ae = DT.getActionEntry(key);
            if (ae != null) {
                ae.invoke();
                return ae.getAction();
            }
            Print.dprintStackTrace((String)("No action for key: " + key));
        }
        return null;
    }

    public static UIActionDispatcher invokeAction(String key, Object[] args) {
        if (key != null) {
            ActionEntry ae = DT.getActionEntry(key);
            if (ae != null) {
                ae.invoke(args);
                return ae.getAction();
            }
            Print.dprintStackTrace((String)("No action for key: " + key));
        }
        return null;
    }

    public static UIActionDispatcher invokeActionLater(String key) {
        if (key != null) {
            ActionEntry ae = DT.getActionEntry(key);
            if (ae != null) {
                ae.invokeLater();
                return ae.getAction();
            }
            Print.dprintStackTrace((String)("No action for key: " + key));
        }
        return null;
    }

    public static UIActionDispatcher invokeActionLater(String key, Object[] args) {
        if (key != null) {
            ActionEntry ae = DT.getActionEntry(key);
            if (ae != null) {
                ae.invokeLater(args);
                return ae.getAction();
            }
            Print.dprintStackTrace((String)("No action for key: " + key));
        }
        return null;
    }

    public static JMenuItem getActionMenuItem(String key) {
        if (key != null) {
            ActionEntry ae = DT.getActionEntry(key);
            if (ae != null) {
                return ae.getMenuItem();
            }
            Print.dprintStackTrace((String)("No action for key: " + key));
        }
        return null;
    }

    public static JMenuItem[] getActionMenuItems(String partialKey) {
        Vector<ActionEntry> aeList = new Vector<ActionEntry>();
        if (partialKey != null && actionMap != null) {
            Enumeration ekey = actionMap.keys();
            while (ekey.hasMoreElements()) {
                String key = (String)ekey.nextElement();
                if (!key.startsWith(partialKey)) continue;
                ActionEntry ae = DT.getActionEntry(key);
                aeList.add(ae);
            }
        }
        Collections.sort(aeList, DT.getActionEntryComparator());
        JMenuItem[] miList = new JMenuItem[aeList.size()];
        for (int i = 0; i < aeList.size(); ++i) {
            miList[i] = ((ActionEntry)aeList.elementAt(i)).getMenuItem();
        }
        return miList;
    }

    public static JButton getActionMenuButton(String key) {
        if (key != null) {
            ActionEntry ae = DT.getActionEntry(key);
            if (ae != null) {
                return ae.getMenuButton();
            }
            Print.dprintStackTrace((String)("No action for key: " + key));
        }
        return null;
    }

    private static Comparator getActionEntryComparator() {
        if (actionEntryComparator == null) {
            actionEntryComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ActionEntry)o1).compareTo((ActionEntry)o2);
                }
            };
        }
        return actionEntryComparator;
    }

    public DT() {
        if (GlobalUI == null) {
            GlobalUI = this;
        } else {
            this.uiInstance = DT.GlobalUI.uiInstance;
            Print.printStackTrace((String)"UIFactory already created");
        }
    }

    private void _loadConfig() {
        if (!this._didLoadConfig) {
            UIConfig.loadConfig();
            this._didLoadConfig = true;
        }
    }

    public void setUserDirectory(File userDir) {
        if (!this._didLoadConfig) {
            UIConfig.setUserDir(userDir.toString());
        } else {
            Print.printStackTrace((String)"'setUserDirectory' invalid here");
        }
    }

    public File getConfigDirectory() {
        return UIConfig.getConfigDirectory();
    }

    public File getTempDirectory() {
        this._loadConfig();
        return UIConfig.getTempDirectory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startUI() {
        if (this.uiInstance != null) return;
        this._loadConfig();
        String definedClassName = UIConfig.getConfigValue("ui.startup.uiClass", null);
        try {
            if (definedClassName != null) {
                Class uiClass = UIConfig.getConfigClass("ui.startup.uiClass", null);
                if (uiClass == null) throw new ClassNotFoundException(definedClassName);
                this.uiInstance = uiClass.newInstance();
                return;
            } else {
                this.uiInstance = UIConfig.getConfigClass("ui.startup.uiClass").newInstance();
            }
            return;
        }
        catch (Throwable t) {
            String cn = definedClassName != null ? definedClassName : "<default>";
            Print.printStackTrace((String)("Unable to start UI [class " + cn + "]"), (Throwable)t);
            System.exit(1);
        }
    }

    public static void setFrameWindow(Frame owner) {
        frameOwner = owner;
    }

    public static Frame getApplicationFrame() {
        return frameOwner;
    }

    public static void setDeploymentManager(DeploymentManager dm) {
        deployManager = dm;
    }

    public static DeploymentManager getDeploymentManager() {
        if (deployManager == null) {
            deployManager = new DeploymentManagerImpl(frameOwner);
        }
        return deployManager;
    }

    public static void setSunOneSettingsDialog(SunONESettingsDialog sd) {
        sunOneSettingsDialog = sd;
    }

    public static SunONESettingsDialog getSunOneSettingsDialog() {
        return sunOneSettingsDialog;
    }

    public static void setServerManager(DTServerManager sm) {
        serverManager = sm;
    }

    public static DTServerManager getServerManager() {
        if (serverManager == null) {
            serverManager = new DTServerManager();
        }
        return serverManager;
    }

    public static void setModuleManager(ModuleManager mm) {
        moduleManager = mm;
    }

    public static ModuleManager getModuleManager() {
        if (moduleManager == null) {
            moduleManager = new ModuleManagerImpl();
        }
        return moduleManager;
    }

    public static InspectorManager getInspectorManager() {
        if (inspectorManager == null) {
            inspectorManager = new InspectorManager();
        }
        return inspectorManager;
    }

    public static Descriptor openModule(File file) throws Throwable {
        UIActionDispatcher ad = DT.invokeAction(CMD_OpenModule, new Object[]{file});
        if (ad.getException() != null) {
            throw ad.getException();
        }
        return ad.getReturn() instanceof Descriptor ? (Descriptor)ad.getReturn() : null;
    }

    public static void closeModule(Descriptor d) {
        if (d != null) {
            DT.invokeAction(CMD_CloseModule, new Object[]{d});
        }
    }

    public static void setDirty(Descriptor d) {
        if (d != null) {
            DT.invokeAction(CMD_SetDirty, new Object[]{d});
        }
    }

    public static void tabValidationChanged() {
        DT.invokeAction(CMD_TabValidationChanged, null);
    }

    public static Descriptor getActiveModule() {
        return DT.getModuleManager().getActiveModule();
    }

    public static Descriptor getSelectedDescriptor() {
        UIActionDispatcher ad = DT.invokeAction(STAT_SelectedDescriptor);
        return ad != null && ad.getReturn() instanceof Descriptor ? (Descriptor)ad.getReturn() : null;
    }

    public static Descriptor getSelectedModule() {
        UIActionDispatcher ad = DT.invokeAction(STAT_SelectedModule);
        return ad != null && ad.getReturn() instanceof Descriptor ? (Descriptor)ad.getReturn() : null;
    }

    public static BundleDescriptor getSelectedBundle() {
        UIActionDispatcher ad = DT.invokeAction(STAT_SelectedBundle);
        return ad != null && ad.getReturn() instanceof BundleDescriptor ? (BundleDescriptor)ad.getReturn() : null;
    }

    public static boolean isDirty(Descriptor d) {
        UIActionDispatcher ad = DT.invokeAction(STAT_IsDirty, new Object[]{d});
        return ad != null ? (Boolean)ad.getReturn() : false;
    }

    public static String getUIPackage() {
        if (uiPackage == null) {
            String cn = DT.class.getName();
            int p = cn.lastIndexOf(".");
            uiPackage = p >= 0 ? cn.substring(0, p + 1) : ENABLER_None;
        }
        return uiPackage;
    }

    public static String className(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        Class<?> c = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        String cn = c.getName();
        if (cn.startsWith(DT.getUIPackage())) {
            return cn.substring(DT.getUIPackage().length());
        }
        if (cn.startsWith("java.util.")) {
            return cn.substring("java.util.".length());
        }
        if (cn.startsWith("java.lang.")) {
            return cn.substring("java.util.".length());
        }
        return cn;
    }

    public static int getOS() {
        String os = System.getProperty("os.name", ENABLER_None).toLowerCase();
        if (os.indexOf("mac os") >= 0) {
            return 3;
        }
        if (os.indexOf("sunos") >= 0) {
            return 1;
        }
        if (os.indexOf("linux") >= 0) {
            return 2;
        }
        if (os.indexOf("win") >= 0) {
            return 4;
        }
        return 0;
    }

    public static String getOSName() {
        String os = System.getProperty("os.name", ENABLER_None).toLowerCase();
        switch (DT.getOS()) {
            case 1: {
                return "Solaris (" + os + ")";
            }
            case 2: {
                return "Linux (" + os + ")";
            }
            case 3: {
                return "MacOS (" + os + ")";
            }
            case 4: {
                return "Windows (" + os + ")";
            }
        }
        return "Unknown (" + os + ")";
    }

    private static class ActionEntry {
        private int sequence;
        private String actionKey;
        private UIActionDispatcher action;
        private UIButtonEnabler.EnablerKey[] enablementKey;
        private String title;
        private String btnIconName;
        private KeyStroke keyAccel;
        private JMenuItem menuItem;
        private JButton menuButton;

        private ActionEntry() {
            this.sequence = 0;
            this.actionKey = null;
            this.action = null;
            this.enablementKey = null;
            this.title = null;
            this.btnIconName = null;
            this.keyAccel = null;
            this.menuItem = null;
            this.menuButton = null;
            this.sequence = actionSequence++;
        }

        public ActionEntry(String actionKey, UIActionDispatcher action, UIButtonEnabler.EnablerKey[] enableKey, String title, String btnIcon, KeyStroke accel) {
            this();
            this.actionKey = actionKey;
            this.setAction(action);
            this.setTitle(title);
            this.setButtonIcon(btnIcon);
            this.setKeyStroke(accel);
            this.setEnableKey(enableKey);
        }

        public ActionEntry(String actionKey, UIActionDispatcher action, UIButtonEnabler.EnablerKey eKey, String title, String btnIcon, KeyStroke accel) {
            UIButtonEnabler.EnablerKey[] enablerKeyArray;
            if (eKey != null) {
                UIButtonEnabler.EnablerKey[] enablerKeyArray2 = new UIButtonEnabler.EnablerKey[1];
                enablerKeyArray = enablerKeyArray2;
                enablerKeyArray2[0] = eKey;
            } else {
                enablerKeyArray = null;
            }
            this(actionKey, action, enablerKeyArray, title, btnIcon, accel);
        }

        public String getActionKey() {
            return this.actionKey;
        }

        public void setAction(UIActionDispatcher action) {
            this.action = action;
        }

        public UIActionDispatcher getAction() {
            return this.action;
        }

        public void setEnableKey(UIButtonEnabler.EnablerKey[] enableKey) {
            UIButtonEnabler.EnablerKey[] oldEnableKey = this.enablementKey;
            this.enablementKey = enableKey;
            if (this.menuItem != null) {
                Print.dprintln((String)("'menuItem' already initialized!: " + this.title));
            }
            if (this.menuButton != null) {
                Print.dprintln((String)("'menuButton' already initialized!: " + this.title));
            }
        }

        public UIButtonEnabler.EnablerKey[] getEnableKey() {
            return this.enablementKey;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public void setButtonIcon(String btnIcon) {
            this.btnIconName = btnIcon;
        }

        public String getButtonIcon() {
            return this.btnIconName;
        }

        public void setKeyStroke(KeyStroke accel) {
            this.keyAccel = accel;
        }

        public KeyStroke getKeyStroke() {
            return this.keyAccel;
        }

        public void invoke() {
            this.getAction().invoke();
        }

        public void invokeLater() {
            this.getAction().invokeLater();
        }

        public void invoke(Object[] args) {
            this.getAction().invoke(args);
        }

        public void invokeLater(Object[] args) {
            this.getAction().invokeLater(args);
        }

        public Object getReturn() {
            return this.getAction().getReturn();
        }

        public Throwable getException() {
            return this.getAction().getException();
        }

        public JMenuItem getMenuItem() {
            if (this.menuItem == null && this.getTitle() != null) {
                this.menuItem = new UIMenu.UIMenuItem(this.getTitle(), '\u0000', null);
                this.menuItem.addActionListener(this.getAction());
                if (this.getKeyStroke() != null) {
                    this.menuItem.setAccelerator(this.getKeyStroke());
                }
                UIButtonEnabler.GetGlobalEnabler().add(this.getEnableKey(), (AbstractButton)this.menuItem);
            }
            return this.menuItem;
        }

        public JButton getMenuButton() {
            if (this.menuButton == null && this.getButtonIcon() != null) {
                this.menuButton = new UIMenu.UIMenuButton(this.getButtonIcon(), this.getTitle());
                this.menuButton.addActionListener(this.getAction());
                UIButtonEnabler.GetGlobalEnabler().add(this.getEnableKey(), (AbstractButton)this.menuButton);
            }
            return this.menuButton;
        }

        public int compareTo(ActionEntry ae) {
            return this.sequence - ae.sequence;
        }
    }
}

