/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.cmp.ui;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.common.cmp.ui.BeanMappingPanel;
import com.sun.enterprise.tools.common.cmp.ui.SunOneUtilsCMP;
import com.sun.enterprise.tools.deployment.ui.utils.DTClassLoader;
import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.MappingGenerator;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TypeColumnEditor
extends JPanel {
    private static final ResourceBundle bundle = NbBundle.getBundle(BeanMappingPanel.class);
    private static Map typeToStringMap = new HashMap();
    private static Map stringToTypeMap = new HashMap();
    private static int FIELD_LIMIT;
    int selectedType;
    Vector typeList;
    boolean hasLength;
    boolean hasPrecision;
    boolean hasScale;
    ColumnElement columnElement;
    String selectedTypeName;
    String beanName;
    String fieldName;
    EjbBundleDescriptor desc;
    private JLabel columLabel;
    private JLabel jLabel1;
    private JLabel lengthLabel;
    private JTextField lengthTextField;
    private JLabel precisionLabel;
    private JTextField precisionTextField;
    private JLabel scaleLabel;
    private JTextField scaleTextField;
    private JComboBox typesComboBox;

    public TypeColumnEditor(ColumnElement ce, EjbBundleDescriptor ejbDesc, String beanName, String fieldName) {
        this.columnElement = ce;
        this.selectedType = ce.getType();
        this.selectedTypeName = (String)typeToStringMap.get(new Integer(this.selectedType));
        this.desc = ejbDesc;
        this.beanName = beanName;
        this.fieldName = fieldName;
        this.typeList = new Vector();
        Collection set = MappingGenerator.SQLTypeUtil.getCompatibleTypes((int)this.selectedType);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            this.typeList.add(typeToStringMap.get(iter.next()));
        }
        Collections.sort(this.typeList);
        HelpCtx.setHelpIDString(this, bundle.getString("HelpID_Type_Column_Editor"));
        this.initComponents();
    }

    private void initComponents() {
        this.columLabel = new JLabel();
        this.typesComboBox = new JComboBox(this.typeList);
        this.lengthLabel = new JLabel();
        this.lengthTextField = new JTextField();
        this.scaleLabel = new JLabel();
        this.scaleTextField = new JTextField();
        this.precisionLabel = new JLabel();
        this.precisionTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(300, 200));
        this.columLabel.setDisplayedMnemonic(bundle.getString("TCE_column_mn").trim().charAt(0));
        this.columLabel.setLabelFor(this.typesComboBox);
        this.columLabel.setText(bundle.getString("TCE_column_type"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.columLabel, gridBagConstraints);
        this.typesComboBox.setSelectedItem(this.selectedTypeName);
        this.typesComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TypeColumnEditor.this.typesComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.6;
        this.add((Component)this.typesComboBox, gridBagConstraints);
        this.lengthLabel.setLabelFor(this.lengthTextField);
        this.lengthLabel.setText(bundle.getString("TCE_length"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lengthLabel, gridBagConstraints);
        this.lengthTextField.setColumns(10);
        this.lengthTextField.setDocument(new NumericDocument());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lengthTextField, gridBagConstraints);
        this.scaleLabel.setDisplayedMnemonic(bundle.getString("TCE_length_mn").trim().charAt(0));
        this.scaleLabel.setLabelFor(this.lengthTextField);
        this.scaleLabel.setText(bundle.getString("TCE_scale"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.scaleLabel, gridBagConstraints);
        this.scaleTextField.setColumns(10);
        this.scaleTextField.setDocument(new NumericDocument());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.scaleTextField, gridBagConstraints);
        this.precisionLabel.setLabelFor(this.precisionTextField);
        this.precisionLabel.setText(bundle.getString("TCE_precision"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.precisionLabel, gridBagConstraints);
        this.precisionTextField.setColumns(10);
        this.precisionTextField.setDocument(new NumericDocument());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.precisionTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.4;
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private void typesComboBoxItemStateChanged(ItemEvent evt) {
        if (1 == evt.getStateChange()) {
            this.selectedType = (Integer)stringToTypeMap.get(this.typesComboBox.getSelectedItem());
            this.determineSqlTypeInputField();
        }
    }

    private void determineSqlTypeInputField() {
        if (!MappingGenerator.SQLTypeUtil.hasLength((int)this.selectedType)) {
            this.lengthLabel.setVisible(false);
            this.lengthTextField.setVisible(false);
            this.hasLength = false;
        } else {
            this.lengthLabel.setVisible(true);
            this.lengthTextField.setVisible(true);
            this.hasLength = true;
        }
        if (!MappingGenerator.SQLTypeUtil.hasPrecision((int)this.selectedType)) {
            this.precisionLabel.setVisible(false);
            this.precisionTextField.setVisible(false);
            this.hasPrecision = false;
        } else {
            this.precisionLabel.setVisible(true);
            this.precisionTextField.setVisible(true);
            this.hasPrecision = true;
        }
        if (!MappingGenerator.SQLTypeUtil.hasScale((int)this.selectedType)) {
            this.scaleLabel.setVisible(false);
            this.scaleTextField.setVisible(false);
            this.hasScale = false;
        } else {
            this.scaleLabel.setVisible(true);
            this.scaleTextField.setVisible(true);
            this.hasScale = true;
        }
    }

    public boolean showAsDialog(String title) {
        block11: {
            this.determineSqlTypeInputField();
            this.setPreferredSize(new Dimension(350, 200));
            if (this.hasLength && this.columnElement.getLength() != null) {
                this.lengthTextField.setText(this.columnElement.getLength().toString());
            }
            if (this.hasPrecision && this.columnElement.getPrecision() != null) {
                this.precisionTextField.setText(this.columnElement.getPrecision().toString());
            }
            if (this.hasScale && this.columnElement.getScale() != null) {
                this.scaleTextField.setText(this.columnElement.getScale().toString());
            }
            while (true) {
                Properties prop = new Properties();
                DialogDescriptor dd = new DialogDescriptor((Object)this, title, true, -1, NotifyDescriptor.OK_OPTION, 0, HelpCtx.findHelp(this), null);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
                if (dd.getValue() != NotifyDescriptor.OK_OPTION) break block11;
                Integer lengthObj = null;
                Integer precisionObj = null;
                Integer scaleObj = null;
                try {
                    ClassLoader cl;
                    if (this.hasLength) {
                        String length = this.lengthTextField.getText();
                        if (!this.valueValid(length, bundle.getString("TCE_Error_length"))) continue;
                        Integer n = lengthObj = length.equals("") ? null : new Integer(length);
                    }
                    if (this.hasPrecision) {
                        String precision = this.precisionTextField.getText();
                        if (!this.valueValid(precision, bundle.getString("TCE_Error_precision"))) continue;
                        Integer n = precisionObj = precision.equals("") ? null : new Integer(precision);
                    }
                    if (this.hasScale) {
                        String scale = this.scaleTextField.getText();
                        Integer n = scaleObj = scale.equals("") ? null : new Integer(scale);
                    }
                    if (precisionObj == null && scaleObj != null) {
                        this.showError(bundle.getString("TCE_Error_scale_no_precision"));
                        continue;
                    }
                    if (precisionObj != null && scaleObj != null && scaleObj > precisionObj) {
                        this.showError(bundle.getString("TCE_Error_scale"));
                        continue;
                    }
                    int selectedValue = (Integer)stringToTypeMap.get(this.typesComboBox.getSelectedItem());
                    MappingGenerator.updateColumn((ColumnElement)this.columnElement, (int)selectedValue, (Integer)lengthObj, (Integer)scaleObj, (Integer)precisionObj);
                    MappingGenerator.updateProperties((Properties)prop, (String)this.beanName, (String)this.fieldName, (int)selectedValue, (Integer)lengthObj, (Integer)scaleObj, (Integer)precisionObj);
                    SunOneUtilsCMP.setProps(this.desc, prop);
                    if (!SunOneUtilsCMP.saveGenSchemaToTempDir(this.desc) || !((cl = this.desc.getClassLoader()) instanceof DTClassLoader)) break;
                    DTClassLoader dtcl = (DTClassLoader)cl;
                    String path = SunOneUtilsCMP.getTempFilePath(this.desc);
                    if (path == null) break;
                    dtcl.prependURL(new File(path).getAbsoluteFile().toURL());
                }
                catch (Exception ex) {
                    Util.showError(ex);
                    continue;
                }
                break;
            }
            return true;
        }
        return false;
    }

    private boolean valueValid(String value, String errorMsg) {
        if ("".equals(value) || Integer.parseInt(value) > 0) {
            return true;
        }
        this.showError(errorMsg);
        return false;
    }

    private void showError(String errorMsg) {
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message(errorMsg, 0);
        DialogDisplayer.getDefault().notify(desc);
    }

    static {
        typeToStringMap.put(new Integer(1), "CHAR");
        typeToStringMap.put(new Integer(12), "VARCHAR");
        typeToStringMap.put(new Integer(-1), "LONGVARCHAR");
        typeToStringMap.put(new Integer(2005), "CLOB");
        typeToStringMap.put(new Integer(-7), "BIT");
        typeToStringMap.put(new Integer(-6), "TINYINT");
        typeToStringMap.put(new Integer(5), "SMALLINT");
        typeToStringMap.put(new Integer(-5), "BIGINT");
        typeToStringMap.put(new Integer(4), "INTEGER");
        typeToStringMap.put(new Integer(8), "DOUBLE");
        typeToStringMap.put(new Integer(6), "FLOAT");
        typeToStringMap.put(new Integer(2), "NUMERIC");
        typeToStringMap.put(new Integer(3), "DECIMAL");
        typeToStringMap.put(new Integer(7), "REAL");
        typeToStringMap.put(new Integer(-2), "BINARY");
        typeToStringMap.put(new Integer(2004), "BLOB");
        typeToStringMap.put(new Integer(-3), "VARBINARY");
        typeToStringMap.put(new Integer(-4), "LONGVARBINARY");
        typeToStringMap.put(new Integer(91), "DATE");
        typeToStringMap.put(new Integer(92), "TIME");
        typeToStringMap.put(new Integer(93), "TIMESTAMP");
        Iterator iter = typeToStringMap.keySet().iterator();
        while (iter.hasNext()) {
            Integer selInt = (Integer)iter.next();
            stringToTypeMap.put(typeToStringMap.get(selInt), selInt);
        }
        FIELD_LIMIT = 10;
    }

    private class NumericDocument
    extends PlainDocument {
        private NumericDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (offs >= FIELD_LIMIT) {
                return;
            }
            char[] s = str.toCharArray();
            char[] r = new char[s.length];
            int j = 0;
            for (int i = 0; i < r.length; ++i) {
                if (!Character.isDigit(s[i])) continue;
                r[j++] = s[i];
            }
            super.insertString(offs, new String(r, 0, j), a);
        }
    }
}

