/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.cmp.ui;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ForeignKeyElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.UniqueKeyElement;
import com.sun.jdo.api.persistence.mapping.core.ClassState;
import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.spi.persistence.utility.ui.CustomListCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.IconWrapper;
import com.sun.jdo.spi.persistence.utility.ui.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConsistencyLevelPanel
extends JPanel {
    private static final ResourceBundle bundle = NbBundle.getBundle(ConsistencyLevelPanel.class);
    private MappingContext mappingContext;
    private ClassState classStateObject;
    private int[] cLevelConstant;
    private String[] cLevelNames;
    private boolean listenerEnabled = false;
    private JComboBox cLevelComboBox;
    private JLabel cLevelLabel;
    private JComboBox cVersionColComboBox;
    private JLabel cVersionColLabel;
    private JLabel jLabel2;

    public ConsistencyLevelPanel(MappingContext context) {
        this(context, null);
        this.cVersionColLabel.setVisible(false);
        this.cVersionColComboBox.setVisible(false);
        this.cLevelLabel.setDisplayedMnemonic(bundle.getString("ADV_LBL_Mnemonic_consistency_level").trim().charAt(0));
        this.cLevelLabel.setText(bundle.getString("ADV_LBL_consistency_level"));
    }

    public ConsistencyLevelPanel(MappingContext context, ClassState classState) {
        this.mappingContext = context;
        this.classStateObject = classState;
        this.cLevelConstant = new int[]{0, 1, 8};
        this.cLevelNames = new String[]{this.mappingContext.getString("CTL_consistency_none"), this.mappingContext.getString("CTL_consistency_checkModifiedCommit"), this.mappingContext.getString("CTL_consistency_LockLoaded")};
        if (classState != null) {
            int length = this.cLevelConstant.length;
            int[] extendedConstants = new int[length + 1];
            String[] extendedNames = new String[length + 1];
            System.arraycopy(this.cLevelConstant, 0, extendedConstants, 0, length);
            extendedConstants[length] = 16;
            this.cLevelConstant = extendedConstants;
            System.arraycopy(this.cLevelNames, 0, extendedNames, 0, length);
            extendedNames[length] = this.mappingContext.getString("CTL_consistency_version");
            this.cLevelNames = extendedNames;
        }
        HelpCtx.setHelpIDString(this, bundle.getString("HelpID_Consistency_Level"));
        this.initComponents();
        this.initAccessibility();
    }

    private void initComponents() {
        this.cLevelLabel = new JLabel();
        this.cLevelComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cVersionColLabel = new JLabel();
        this.cVersionColComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(400, 50));
        this.cLevelLabel.setDisplayedMnemonic(bundle.getString("ADV_LBL_Mnemonic_consistency_level_short").trim().charAt(0));
        this.cLevelLabel.setLabelFor(this.cLevelComboBox);
        this.cLevelLabel.setText(bundle.getString("ADV_LBL_consistency_level_short"));
        this.cLevelLabel.setToolTipText(bundle.getString("ADV_TT_consistency_level"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)this.cLevelLabel, gridBagConstraints);
        this.cLevelComboBox.setModel(new DefaultComboBoxModel<String>(this.cLevelNames));
        this.cLevelComboBox.setMinimumSize(new Dimension(200, 25));
        this.cLevelComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ConsistencyLevelPanel.this.consistencyLevelChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.cLevelComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.cVersionColLabel.setDisplayedMnemonic(bundle.getString("ADV_LBL_Mnemonic_consistency_level_version").trim().charAt(0));
        this.cVersionColLabel.setText(bundle.getString("ADV_LBL_consistency_level_version"));
        this.cVersionColLabel.setToolTipText(bundle.getString("ADV_TT_consistency_level_version"));
        this.cVersionColLabel.setMaximumSize(new Dimension(116, 15));
        this.cVersionColLabel.setMinimumSize(new Dimension(116, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.cVersionColLabel, gridBagConstraints);
        this.cVersionColComboBox.setMinimumSize(new Dimension(200, 25));
        this.cVersionColComboBox.setEnabled(false);
        this.cVersionColComboBox.setRenderer(new CustomListCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.add((Component)this.cVersionColComboBox, gridBagConstraints);
    }

    private void consistencyLevelChanged(ItemEvent evt) {
        if (this.listenerEnabled && 1 == evt.getStateChange()) {
            boolean isVersionConsistency = this.cLevelComboBox.getSelectedItem().equals(this.mappingContext.getString("CTL_consistency_version"));
            if (isVersionConsistency && !this.cVersionColComboBox.isEnabled()) {
                this.loadColumnCandidates(null);
                this.cVersionColComboBox.setEnabled(true);
            } else if (!isVersionConsistency) {
                this.cVersionColComboBox.setEnabled(false);
                SwingUtils.replaceItems((DefaultComboBoxModel)this.cVersionColComboBox.getModel(), new ArrayList());
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ADV_TT_consistency_level"));
    }

    public boolean setConsistencyLevel(int level) {
        boolean returnValue = false;
        this.listenerEnabled = false;
        for (int i = 0; i < this.cLevelConstant.length; ++i) {
            if (level != this.cLevelConstant[i]) continue;
            this.cLevelComboBox.setSelectedIndex(i);
            this.populateVersionColumn(level);
            returnValue = true;
        }
        this.listenerEnabled = true;
        return returnValue;
    }

    private void populateVersionColumn(int level) {
        if (this.classStateObject != null && 16 == level) {
            PersistenceFieldElement pfe;
            MappingFieldElement versionField = null;
            MappingClassElement mce = this.classStateObject.getMappingClassElement();
            Iterator iterator = mce.getFields().iterator();
            while (iterator.hasNext() && versionField == null) {
                MappingFieldElement nextField = (MappingFieldElement)iterator.next();
                if (!nextField.isVersion()) continue;
                versionField = nextField;
            }
            if (versionField != null && (pfe = this.classStateObject.getPersistenceClassElement().getField(versionField.getName())) != null) {
                List currentMapping = this.classStateObject.getFieldHolderState().getCurrentMapping(pfe);
                iterator = currentMapping.iterator();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!(next instanceof String)) continue;
                    String columnName = (String)next;
                    ColumnElement column = this.classStateObject.getTableState().getColumn(columnName);
                    this.loadColumnCandidates(column != null ? column : columnName);
                    break;
                }
            }
            this.cVersionColComboBox.setEnabled(true);
        }
    }

    public int getConsistencyLevel() {
        return this.cLevelConstant[this.cLevelComboBox.getSelectedIndex()];
    }

    public Object getVersionColumn() {
        return this.cVersionColComboBox.getSelectedItem();
    }

    public boolean showAsDialog(String title) {
        this.setPreferredSize(new Dimension(400, 100));
        DialogDescriptor dd = new DialogDescriptor((Object)this, title, true, -1, NotifyDescriptor.OK_OPTION, 0, HelpCtx.findHelp(this), null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        return dd.getValue() == NotifyDescriptor.OK_OPTION;
    }

    private void loadColumnCandidates(Object selectedColumn) {
        int i;
        TableState tableState = this.classStateObject.getTableState();
        TableElement primaryTable = tableState.getCurrentPrimaryTable();
        UniqueKeyElement[] uks = primaryTable.getUniqueKeys();
        ForeignKeyElement[] fks = primaryTable.getForeignKeys();
        List candidates = FieldHolderState.getSortedAllColumns(primaryTable);
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)this.cVersionColComboBox.getModel();
        if (uks != null) {
            for (i = 0; i < uks.length; ++i) {
                UniqueKeyElement uk = uks[i];
                if (!uk.isPrimaryKey()) continue;
                candidates.removeAll(Arrays.asList(uk.getColumns()));
            }
        }
        if (fks != null) {
            for (i = 0; i < fks.length; ++i) {
                ForeignKeyElement fk = fks[i];
                candidates.removeAll(Arrays.asList(fk.getLocalColumns()));
            }
        }
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            ColumnElement next = (ColumnElement)iterator.next();
            if (!next.isNullable() && next.isNumericType()) continue;
            iterator.remove();
        }
        FieldHolderState holderState = this.classStateObject.getFieldHolderState();
        PersistenceFieldElement[] fields = holderState.getPersistenceClassElement().getFields();
        int count = fields != null ? fields.length : 0;
        for (int i2 = 0; i2 < count; ++i2) {
            PersistenceFieldElement field = fields[i2];
            MappingFieldElement mfe = holderState.getMappingClassElement().getField(field.getName());
            if (mfe.isVersion()) continue;
            iterator = holderState.getCurrentMapping(field).iterator();
            while (iterator.hasNext()) {
                ColumnElement column;
                String columnName;
                Object next = iterator.next();
                if (next instanceof String) {
                    columnName = (String)next;
                    column = tableState.getColumn(columnName);
                    if (column == null) continue;
                    candidates.remove(column);
                    continue;
                }
                if (next instanceof String[]) {
                    columnName = ((String[])next)[0];
                    column = tableState.getColumn(columnName);
                    if (column == null) continue;
                    candidates.remove(column);
                    continue;
                }
                if (!(next instanceof ColumnElement)) continue;
                candidates.remove(next);
            }
        }
        if (this.listenerEnabled && candidates.isEmpty()) {
            this.showWarning("ADV_MSG_title", "ADV_MSG");
        }
        candidates.add(0, " ");
        SwingUtils.replaceItems(comboModel, candidates);
        if (selectedColumn != null) {
            Object selection = selectedColumn;
            if (!candidates.contains(selectedColumn)) {
                selection = new IconWrapper(selectedColumn instanceof ColumnElement ? ((ColumnElement)selectedColumn).getName() : selectedColumn, Util.getIllegalIcon());
                comboModel.insertElementAt(selection, 1);
            }
            comboModel.setSelectedItem(selection);
        }
    }

    private void showWarning(String titleKey, String msgKey) {
        Object okOption = NotifyDescriptor.OK_OPTION;
        NotifyDescriptor desc = new NotifyDescriptor(bundle.getString(msgKey), bundle.getString(titleKey), -1, 2, new Object[]{okOption}, okOption);
        DialogDisplayer.getDefault().notify(desc);
    }

    protected boolean hasCompleteContents() {
        Object versionColumn = this.getVersionColumn();
        if (16 == this.getConsistencyLevel() && !(versionColumn instanceof ColumnElement)) {
            this.showWarning("ADV_MSG_title_1", "ADV_MSG_1");
            return false;
        }
        return true;
    }
}

