/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.view;

import com.sun.enterprise.tools.guiframework.FrameworkDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.EventDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.HandlerDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.IODescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.UseHandlerDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.util.Util;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ViewXMLReader {
    private String _jspRoot = "/jsp/";
    private Document doc;
    private Map typeMap = new HashMap();
    private Map handlerMap = new HashMap();
    private static final String OUTPUT_ENCODING = "UTF-8";
    private static final String DESCRIPTOR_CLASS = "descriptorClass";
    private static final String DISPLAY_ITEM = "displayItem";
    private static final String DISPLAY_ITEM_TYPE = "displayItemType";
    private static final String EVENTS = "events";
    private static final String FUNCTION = "function";
    private static final String FUNCTION_CLASS = "className";
    private static final String FUNCTION_METHOD = "methodName";
    private static final String INPUT_DEF = "inputDef";
    private static final String OUTPUT_DEF = "outputDef";
    private static final String CALL = "call";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String TARGET_KEY = "key";
    private static final String TARGET_TYPE = "target";
    private static final String IF = "if";
    private static final String PARAMETER = "parameter";
    private static final String INCLUDE = "include";
    private static final String VALUE = "value";
    private static final String VALUES = "values";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String DEFAULT = "default";
    private static final String DESCRIPTION = "description";

    public ViewXMLReader(String fileName, String dtdURLBase) throws Exception {
        this(fileName, dtdURLBase, null);
    }

    public ViewXMLReader(String fileName, String dtdURLBase, String jspRoot) throws Exception {
        this(new FileInputStream(new File(fileName)), dtdURLBase, jspRoot);
    }

    public ViewXMLReader(InputStream is, String dtdURLBase) throws Exception {
        this(is, dtdURLBase, null);
    }

    public ViewXMLReader(InputStream is, String dtdURLBase, String jspRoot) throws Exception {
        this(is, dtdURLBase, jspRoot, null);
    }

    public ViewXMLReader(InputStream is, String dtdURLBase, String jspRoot, EntityResolver entityResolver) throws Exception {
        this.setJSPRoot(jspRoot);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(false);
        dbf.setCoalescing(false);
        dbf.setExpandEntityReferences(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (entityResolver != null) {
            db.setEntityResolver(entityResolver);
        }
        OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, OUTPUT_ENCODING);
        db.setErrorHandler(new MyErrorHandler(new PrintWriter((Writer)errorWriter, true)));
        this.doc = db.parse(is, dtdURLBase);
        this.preProcess();
    }

    private void preProcess() throws Exception {
        NodeList nodeList = this.doc.getElementsByTagName(DISPLAY_ITEM_TYPE);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elem = (Element)nodeList.item(i);
            this.typeMap.put(elem.getAttribute(NAME), elem);
        }
    }

    private ViewDescriptor getDescriptor(String name, String type) throws Exception {
        Element typeNode = (Element)this.typeMap.get(type);
        if (typeNode == null) {
            return new ViewDescriptor(name);
        }
        Class<?> descriptorClass = Class.forName(typeNode.getAttribute(DESCRIPTOR_CLASS));
        Constructor<?> constructor = descriptorClass.getConstructor(String.class);
        return (ViewDescriptor)constructor.newInstance(name);
    }

    private void processEvent(Element node, ViewDescriptor vd) throws Exception {
        String type = node.getAttribute(TYPE);
        EventDescriptor eventDesc = new EventDescriptor(vd, type);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeName().compareToIgnoreCase(CALL) != 0) continue;
            UseHandlerDescriptor useDesc = this.getUseHandler(eventDesc, (Element)child);
            eventDesc.addEventHandler(useDesc);
        }
        vd.setEventDescriptor(eventDesc);
    }

    private UseHandlerDescriptor getUseHandler(FrameworkDescriptor parent, Element node) {
        Element handlerNode = this.getHandlerNode(node.getAttribute(NAME), this.doc);
        if (handlerNode == null) {
            throw new IllegalArgumentException("'call' referred to a handler that was not found: '" + node.getAttribute(NAME) + "'");
        }
        HandlerDescriptor handlerDesc = this.getHandler(handlerNode);
        UseHandlerDescriptor useDesc = new UseHandlerDescriptor(parent, handlerDesc);
        String ifValue = node.getAttribute(IF);
        if (Util.hasValue(ifValue)) {
            useDesc.setIfCheck(ifValue);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name;
            Element elt;
            String childName = child.getNodeName();
            if (childName.compareToIgnoreCase(INPUT) == 0) {
                elt = (Element)child;
                name = elt.getAttribute(NAME);
                if (handlerDesc.getInputDescriptor(name) == null) {
                    throw new FrameworkException("call '" + handlerDesc.getName() + "' defined " + INPUT + ": '" + name + "', however, '" + name + "' is not a valid " + INPUT + "!");
                }
                useDesc.setInputValue(name, this.getParameterValue(elt));
                continue;
            }
            if (childName.compareToIgnoreCase(OUTPUT) != 0) continue;
            elt = (Element)child;
            name = elt.getAttribute(NAME);
            if (handlerDesc.getOutputDescriptor(name) == null) {
                throw new FrameworkException("call '" + handlerDesc.getName() + "' defined " + OUTPUT + ": '" + name + "', however, '" + name + "' is not a valid " + OUTPUT + "!");
            }
            useDesc.setOutputMapping(name, elt.getAttribute(TARGET_KEY), elt.getAttribute(TARGET_TYPE));
        }
        return useDesc;
    }

    private HandlerDescriptor getHandler(Element node) {
        String ifValue;
        String name = node.getAttribute(NAME);
        HandlerDescriptor handler = (HandlerDescriptor)this.handlerMap.get(name);
        if (handler != null) {
            return handler;
        }
        handler = new HandlerDescriptor(name);
        handler.setDescription(node.getAttribute(DESCRIPTION));
        String className = node.getAttribute(FUNCTION_CLASS);
        String methodName = node.getAttribute(FUNCTION_METHOD);
        if (Util.hasValue(className) && Util.hasValue(methodName)) {
            handler.setHandlerMethod(className, methodName);
        }
        if (Util.hasValue(ifValue = node.getAttribute(IF))) {
            handler.setIfCheck(ifValue);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            IODescriptor ioDesc;
            String nodeName = child.getNodeName();
            if (nodeName.compareToIgnoreCase(CALL) == 0) {
                UseHandlerDescriptor useDesc = this.getUseHandler(handler, (Element)child);
                handler.addChildHandlerDescriptor(useDesc);
                continue;
            }
            if (nodeName.compareToIgnoreCase(INPUT_DEF) == 0) {
                ioDesc = this.getIODescriptor((Element)child);
                String defValue = ((Element)child).getAttribute(DEFAULT);
                if (Util.hasValue(defValue)) {
                    ioDesc.setDefault(defValue);
                }
                handler.addInputDescriptor(ioDesc);
                continue;
            }
            if (nodeName.compareToIgnoreCase(OUTPUT_DEF) != 0) continue;
            ioDesc = this.getIODescriptor((Element)child);
            handler.addOutputDescriptor(ioDesc);
        }
        this.handlerMap.put(name, handler);
        return handler;
    }

    private IODescriptor getIODescriptor(Element node) {
        IODescriptor desc = new IODescriptor(node.getAttribute(NAME), node.getAttribute(TYPE));
        desc.setDescription(node.getAttribute(DESCRIPTION));
        return desc;
    }

    private void processParameter(Element node, ViewDescriptor vd) {
        vd.addParameter(node.getAttribute(NAME), this.getParameterValue(node));
    }

    private void processInclude(Element node, ViewDescriptor vd) throws Exception {
        Element descriptorNode = this.getViewDescriptorNode(node.getAttribute("item"), this.doc);
        if (descriptorNode == null) {
            throw new Exception("Invalid include :" + node.getAttribute("item"));
        }
        vd.addChildDescriptor(this.process(descriptorNode));
    }

    private Object getInputValue(Element node) {
        return this.getParameterValue(node);
    }

    private Object getParameterValue(Element node) {
        if (Util.hasValue(node.getAttribute(VALUE))) {
            return node.getAttribute(VALUE);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equalsIgnoreCase(VALUES)) continue;
            String str = ((Element)child).getAttribute(VALUE);
            values.add(str);
        }
        if (values.size() == 0) {
            return null;
        }
        return values;
    }

    private String getDisplayItem(Node node) {
        Node parentNode = node;
        while ((parentNode = parentNode.getParentNode()) != null && parentNode.getNodeName().compareToIgnoreCase(DISPLAY_ITEM) != 0) {
        }
        if (parentNode == null) {
            return null;
        }
        NamedNodeMap attrs = parentNode.getAttributes();
        if (attrs == null) {
            return null;
        }
        return attrs.getNamedItem(NAME).getNodeValue();
    }

    private ViewDescriptor process(Element node) throws Exception {
        String name = node.getAttribute(NAME);
        String description = node.getAttribute(DESCRIPTION);
        String type = node.getAttribute(TYPE);
        String extendsFrom = node.getAttribute("extends");
        String displayURL = node.getAttribute("displayURL");
        Element extendsViewDescriptor = null;
        if (Util.hasValue(extendsFrom)) {
            extendsViewDescriptor = this.getViewDescriptorNode(extendsFrom, this.doc);
            if (extendsViewDescriptor == null) {
                throw new Exception("Cannot find " + extendsFrom);
            }
            if (type == null || type.length() == 0) {
                type = extendsViewDescriptor.getAttribute(TYPE);
            }
        }
        ViewDescriptor vd = this.getDescriptor(name, type);
        vd.setDescription(description);
        if (displayURL == null || displayURL.equals("")) {
            vd.setDisplayURL(this.getJSPName(name));
        } else {
            vd.setDisplayURL(displayURL);
        }
        if (extendsViewDescriptor != null) {
            this.processExtends(extendsViewDescriptor, vd);
        }
        this.processDisplayItemChildren(node, vd);
        return vd;
    }

    protected void processExtends(Element extendsViewDescriptor, ViewDescriptor vd) throws Exception {
        String extendsFrom = extendsViewDescriptor.getAttribute("extends");
        if (Util.hasValue(extendsFrom)) {
            Element extendsParentViewDescriptor = this.getViewDescriptorNode(extendsFrom, this.doc);
            if (extendsViewDescriptor == null) {
                throw new Exception("Cannot find " + extendsFrom);
            }
            this.processExtends(extendsParentViewDescriptor, vd);
        }
        this.processDisplayItemChildren(extendsViewDescriptor, vd);
    }

    protected String getJSPName(String name) {
        return this.getJSPRoot() + name + ".jsp";
    }

    protected String getJSPRoot() {
        return this._jspRoot;
    }

    protected void setJSPRoot(String root) {
        if (root == null) {
            return;
        }
        this._jspRoot = root;
    }

    private void processDisplayItemChildren(Node node, ViewDescriptor vd) throws Exception {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String childName = child.getNodeName();
            if (childName.compareToIgnoreCase(PARAMETER) == 0) {
                this.processParameter((Element)child, vd);
                continue;
            }
            if (childName.compareToIgnoreCase(EVENTS) == 0) {
                this.processEvent((Element)child, vd);
                continue;
            }
            if (childName.compareToIgnoreCase(DISPLAY_ITEM) == 0) {
                vd.addChildDescriptor(this.process((Element)child));
                continue;
            }
            if (childName.compareToIgnoreCase(INCLUDE) != 0) continue;
            this.processInclude((Element)child, vd);
        }
    }

    private Element getHandlerNode(String key, Node node) {
        if (node == null) {
            return null;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName = child.getNodeName();
            if (nodeName.compareToIgnoreCase(FUNCTION) == 0) {
                if (!((Element)child).getAttribute(NAME).equals(key)) continue;
                return (Element)child;
            }
            Element handlerNode = this.getHandlerNode(key, child);
            if (handlerNode == null) continue;
            return handlerNode;
        }
        return null;
    }

    private Element getViewDescriptorNode(String key, Node node) throws Exception {
        if (node == null) {
            return null;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName = child.getNodeName();
            if (nodeName.compareToIgnoreCase(DISPLAY_ITEM) == 0) {
                NamedNodeMap attrs = child.getAttributes();
                if (attrs == null) {
                    throw new Exception("No attrs!!!");
                }
                Node name = attrs.getNamedItem(NAME);
                if (name == null) {
                    throw new Exception("Name cannot be null!!!");
                }
                if (!name.getNodeValue().equals(key)) continue;
                return (Element)child;
            }
            Element vdNode = this.getViewDescriptorNode(key, child);
            if (vdNode == null) continue;
            return vdNode;
        }
        if (key.indexOf(".") >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(key, ".");
            Node childNode = node;
            while (tokenizer.hasMoreElements()) {
                key = tokenizer.nextToken();
                childNode = this.getViewDescriptorNode(key, childNode);
            }
            return (Element)childNode;
        }
        return null;
    }

    public ViewDescriptor getViewDescriptor(String key) throws Exception {
        Element node = this.getViewDescriptorNode(key, this.doc);
        if (node == null) {
            return null;
        }
        return this.process(node);
    }

    public HashMap getAllViewDescriptors() throws Exception {
        NodeList nodeList = this.doc.getElementsByTagName(DISPLAY_ITEM);
        HashMap<String, ViewDescriptor> descriptors = new HashMap<String, ViewDescriptor>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element displayItem = (Element)nodeList.item(i);
            Node parent = displayItem.getParentNode();
            if (parent != null && parent.getNodeName().equals(DISPLAY_ITEM)) continue;
            String topLevelDescriptorName = displayItem.getAttribute(NAME);
            if (descriptors.get(topLevelDescriptorName) != null) {
                throw new Exception("DisplayItem  " + topLevelDescriptorName + " defined more than once");
            }
            descriptors.put(topLevelDescriptorName, this.process(displayItem));
        }
        return descriptors;
    }

    public static void main(String[] args) {
        try {
            if (Array.getLength(args) < 2) {
                System.out.println("Usage ViewXMLReader <XMLFileName> <ViewName>");
                return;
            }
            ViewXMLReader xmlReader = new ViewXMLReader(args[0], "file://./");
            xmlReader.getViewDescriptor(args[1]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        MyErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

