/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.taglib.html.CCTextFieldTag;
import com.sun.web.ui.taglib.pagetitle.CCPageTitleTag;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.ObjectName;

public class SystemPropsHandlers {
    public static final String MODEL = "model";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_VALUE = "propertyValue";

    public static String extractToken(String token) {
        if (token == null) {
            return null;
        }
        int j = token.indexOf("${");
        if (j >= 0) {
            int i = token.indexOf(125);
            if (i < 0) {
                i = token.length();
            }
            return token.substring(j + 2, i);
        }
        return token;
    }

    public static String resolveToken(String token) {
        String[] tokenTypes = new String[]{"java.lang.String", "java.lang.String"};
        Object[] tokensParams = new Object[]{"${" + token + "}", "server"};
        String value = (String)MBeanUtil.invoke("com.sun.appserv:type=domain,category=config", "resolveTokens", tokensParams, tokenTypes);
        return value;
    }

    public static String resolveAndReplaceToken(String tokenString) {
        String token = null;
        if (tokenString != null && tokenString.indexOf("${") >= 0) {
            token = SystemPropsHandlers.extractToken(tokenString);
        }
        if (token == null) {
            return tokenString;
        }
        return tokenString.replaceAll("\\$\\{" + token + "\\}", SystemPropsHandlers.resolveToken(token));
    }

    public void isConfigProperty(RequestContext ctx, HandlerContext handlerCtx) {
        String property = (String)handlerCtx.getInputValue("property");
        boolean result = false;
        if (property != null) {
            result = property.indexOf("com.sun.aas") >= 0;
        }
        handlerCtx.setOutputValue("result", (Object)(result ? "true" : "false"));
    }

    public void loadConfigPropertyHelp(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue(MODEL);
        ((DefaultModel)model).clear();
        String paramName = (String)handlerCtx.getInputValue("paramName");
        if (paramName == null) {
            return;
        }
        String baseName = "com.sun.enterprise.tools.admingui.resources.AsEnv";
        String description = Util.getMessage(baseName, paramName, null);
        model.appendRow();
        model.setValue(PROPERTY_NAME, (Object)paramName);
        model.setValue("description", (Object)description);
    }

    public void loadTokenEditTable(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue(MODEL);
        ((DefaultModel)model).clear();
        String configObjectName = (String)handlerCtx.getInputValue("configName");
        String paramName = (String)handlerCtx.getInputValue("paramName");
        if (paramName == null) {
            return;
        }
        paramName = SystemPropsHandlers.extractToken(paramName);
        ObjectName[] refs = null;
        try {
            refs = (ObjectName[])MBeanUtil.invoke(configObjectName, "listReferencees", null, null);
        }
        catch (Exception ex) {
            model.appendRow();
            model.setValue("clusterName", (Object)"");
            model.setValue("instanceName", (Object)"");
            model.setValue("value", (Object)SystemPropsHandlers.resolveToken(paramName));
            return;
        }
        this.loadSystemProperties(model, refs, paramName, "");
    }

    private void loadSystemProperties(CCActionTableModelInterface model, ObjectName[] refs, String paramName, String clusterName) {
        if (refs == null) {
            return;
        }
        Object[] params = new Object[]{new Boolean(true)};
        String[] types = new String[]{"boolean"};
        String[] tokenTypes = new String[]{"java.lang.String", "java.lang.String"};
        for (int i = 0; i < refs.length; ++i) {
            ObjectName reference = refs[i];
            if (reference.getKeyProperty("type").equals("cluster")) {
                ObjectName[] instances = (ObjectName[])MBeanUtil.invoke(reference, "listServerInstances", null, null);
                clusterName = reference.getKeyProperty("name");
                this.loadSystemProperties(model, instances, paramName, clusterName);
                continue;
            }
            Properties props = (Properties)MBeanUtil.invoke(reference, "listSystemProperties", params, types);
            if (props == null) continue;
            String instanceName = reference.getKeyProperty("name");
            String value = props.getProperty(paramName, null);
            if (value == null) {
                Object[] tokensParams = new Object[]{"${" + paramName + "}", instanceName};
                value = (String)MBeanUtil.invoke("com.sun.appserv:type=domain,category=config", "resolveTokens", tokensParams, tokenTypes);
            }
            if (value == null) {
                value = "";
            }
            model.appendRow();
            model.setValue("clusterName", (Object)clusterName);
            model.setValue("instanceName", (Object)instanceName);
            model.setValue("value", (Object)value);
            model.setValue("objectName", (Object)reference.toString());
        }
    }

    public void saveTokenEditTable(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        String[] deleteTypes = new String[]{"java.lang.String"};
        String[] createTypes = new String[]{"java.util.Properties"};
        Object[] params = null;
        String tokenValue = (String)handlerCtx.getInputValue("tokenValue");
        if ((tokenValue = SystemPropsHandlers.extractToken(tokenValue)) == null) {
            return;
        }
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue(MODEL);
        model.beforeFirst();
        while (model.next()) {
            String objectName = (String)model.getValue("objectName");
            String value = (String)model.getValue("value");
            try {
                params = new Object[]{tokenValue};
                MBeanUtil.invoke(objectName, "deleteSystemProperty", params, deleteTypes);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (value == null || value.length() <= 0) continue;
            Properties newProp = new Properties();
            newProp.setProperty(tokenValue, value);
            params = new Object[]{newProp};
            MBeanUtil.invoke(objectName, "createSystemProperties", params, createTypes);
        }
    }

    public void beginTokensPageTitleDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        String titleKey = (String)handlerCtx.getInputValue("titleKey");
        String params = (String)handlerCtx.getInputValue("params");
        if (titleKey == null || titleKey.length() == 0) {
            titleKey = "tokens.ConfigPageTitle";
        }
        String msg = Util.getMessage(titleKey, new Object[]{params});
        tag.setPageTitleText(msg);
    }

    public void removeDollarSign(RequestContext ctx, HandlerContext handlerCtx) {
        String in = (String)handlerCtx.getInputValue("systemProp");
        handlerCtx.setOutputValue("result", (Object)SystemPropsHandlers.extractToken(in));
    }

    public void loadConfigSystemProperties(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue(MODEL);
        ((DefaultModel)model).clear();
        Properties props = (Properties)handlerCtx.getInputValue("properties");
        String linkText = Util.getMessage("props.instanceValues");
        try {
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                model.appendRow();
                model.setValue(PROPERTY_NAME, (Object)name);
                model.setValue(PROPERTY_VALUE, (Object)props.getProperty(name));
                model.setValue("instanceValuesHref", (Object)name);
                model.setValue("instanceValues", (Object)linkText);
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("loadConfigSystemProperties: Loading error. ", (Throwable)ex);
        }
    }

    public String endExtendedTextDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        int i;
        int j;
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String html = ev.getContent();
        if (!(ev.getSource() instanceof CCTextFieldTag)) {
            return html;
        }
        if (html == null || html.length() == 0) {
            return html;
        }
        String value = Util.extractHtmlProp(html, "value");
        if (value == null || value.length() == 0) {
            return html;
        }
        value = value.trim();
        String sizeStr = Util.extractHtmlProp(html, "size");
        if (sizeStr != null && sizeStr.length() > 0) {
            int currentSize = 0;
            try {
                currentSize = Integer.parseInt(sizeStr);
                int size = (value.length() + 4) / 8 * 10;
                if (size > 100) {
                    size = 100;
                }
                if (currentSize < size) {
                    html = Util.removeHtmlProp(html, "size");
                    html = Util.addHtmlProp(html, "size=" + size);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((j = value.indexOf("${")) >= 0) {
            i = value.indexOf(125);
            if (i < 0) {
                i = value.length();
            }
        } else {
            return html;
        }
        value = value.substring(j + 2, i);
        String name = Util.extractHtmlProp(html, "name");
        int i2 = name.indexOf(46);
        String listPage = name;
        if (i2 > 0) {
            listPage = name.substring(0, i2);
        }
        NonSyncStringBuffer href = new NonSyncStringBuffer();
        String editKeyValue = (String)ctx.getRequest().getAttribute("editKeyValue");
        href.append("\n<a href=\"../admingui/tokensEdit?attrValue=").append(Util.URLencode(ctx, value)).append("&listPage=").append(listPage);
        if (editKeyValue != null && editKeyValue.length() > 0) {
            href.append("&editKeyValue=").append(Util.URLencode(ctx, editKeyValue));
        }
        if (value.startsWith("com.sun.aas")) {
            href.append("\">&nbsp;").append(Util.getMessage("common.Description")).append("</a>");
        } else {
            href.append("\">&nbsp;").append(Util.getMessage("props.actualValues")).append("</a>");
        }
        return html + href;
    }
}

