/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.View;
import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.tools.admingui.handlers.ShutDownInstance;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.web.ui.model.CCActionTableModelInterface;
import java.util.Properties;
import javax.management.ObjectName;

public class ServerInstGeneralHandlers {
    public void stopInstance(RequestContext ctx, HandlerContext handlerCtx) {
        String sleepTime = (String)handlerCtx.getInputValue("sleepTime");
        int sleepTimeInSeconds = 6;
        if (sleepTime != null) {
            sleepTimeInSeconds = new Integer(sleepTime);
        }
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        if (objectName == null || methodName == null) {
            throw new RuntimeException("Null object or method name for stop instance.");
        }
        ShutDownInstance stop = new ShutDownInstance(sleepTimeInSeconds, objectName, methodName);
        new Thread(stop).start();
    }

    public String endPortsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        String ports;
        block5: {
            ports = "";
            String objectName = (String)handlerCtx.getViewDescriptor().getParameter("objectName");
            String methodName = (String)handlerCtx.getViewDescriptor().getParameter("methodName");
            try {
                ObjectName[] listeners = (ObjectName[])MBeanUtil.invoke(new ObjectName(objectName), methodName, null, null);
                for (int i = 0; i < listeners.length; ++i) {
                    Object port = MBeanUtil.getAttribute(listeners[i], "port");
                    if (i != 0) {
                        ports = ports + ",  ";
                    }
                    if (port == null) continue;
                    String pn = port.toString();
                    if (pn.startsWith("$")) {
                        String serverName = (String)handlerCtx.getViewDescriptor().getParameter("serverName");
                        port = this.resolveToken(pn.substring(2, pn.length() - 1), serverName);
                    }
                    ports = ports + port.toString();
                }
            }
            catch (Exception ex) {
                if (!Util.isLoggableINFO()) break block5;
                Util.logINFO("Exception thrown in getting HTTP ports.", ex);
            }
        }
        return ports;
    }

    public String endConfigDirDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        String dir;
        block2: {
            String objectName = (String)handlerCtx.getViewDescriptor().getParameter("objectName");
            String methodName = (String)handlerCtx.getViewDescriptor().getParameter("methodName");
            dir = "";
            try {
                Object configDir = MBeanUtil.invoke(new ObjectName(objectName), methodName, null, null);
                dir = dir + configDir.toString();
            }
            catch (Exception ex) {
                if (!Util.isLoggableINFO()) break block2;
                Util.logINFO("Exception thrown in getting config directory.", ex);
            }
        }
        return dir;
    }

    public String endDebugDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        String msg;
        block3: {
            String objectName = (String)handlerCtx.getViewDescriptor().getParameter("objectName");
            String methodName = (String)handlerCtx.getViewDescriptor().getParameter("methodName");
            msg = Util.getMessage("serverinst.notEnabled");
            try {
                String port;
                Object debugPort = MBeanUtil.getAttribute(new ObjectName(objectName), methodName);
                if (debugPort != null && !(port = debugPort.toString()).equals("0")) {
                    msg = Util.getMessage("serverinst.debugEnabled") + debugPort.toString();
                }
            }
            catch (Exception ex) {
                if (!Util.isLoggableINFO()) break block3;
                Util.logINFO("Exception thrown in getting debug port.", ex);
            }
        }
        return msg;
    }

    public String endHostNameDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        View bean = handlerCtx.getView();
        DescriptorContainerView view = (DescriptorContainerView)bean.getParent();
        return ctx.getRequest().getServerName();
    }

    public static String endInstallVersionDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        String version;
        block2: {
            String objectName = (String)handlerCtx.getViewDescriptor().getParameter("objectName");
            String methodName = (String)handlerCtx.getViewDescriptor().getParameter("methodName");
            version = "";
            try {
                Object domainVersion = MBeanUtil.getAttribute(new ObjectName(objectName), methodName);
                version = version + domainVersion.toString();
            }
            catch (Exception ex) {
                if (!Util.isLoggableINFO()) break block2;
                Util.logINFO("Exception thrown in getting domain version.", ex);
            }
        }
        return version;
    }

    public void isServerRunning(RequestContext ctx, HandlerContext handlerCtx) {
        boolean isRunning = false;
        Object sts = handlerCtx.getInputValue("statusObject");
        if (sts instanceof RuntimeStatus) {
            Status s = ((RuntimeStatus)sts).getStatus();
            int code = s.getStatusCode();
            switch (code) {
                case 0: 
                case 1: {
                    isRunning = true;
                    break;
                }
                case 2: 
                case 3: {
                    isRunning = false;
                    break;
                }
                case 4: 
                case 5: {
                    return;
                }
            }
        }
        handlerCtx.setOutputValue("value", (Object)(isRunning ? "true" : "false"));
    }

    public void loadInstanceAndNodeAgent(RequestContext ctx, HandlerContext handlerCtx) {
        try {
            CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("propertiesModel");
            ObjectName[] objs = (ObjectName[])handlerCtx.getInputValue("instanceList");
            model.beforeFirst();
            if (objs == null || objs.length < 1) {
                return;
            }
            for (int i = 0; i < objs.length; ++i) {
                String name = (String)MBeanUtil.getAttribute(objs[i], "name");
                String nodeAgent = (String)MBeanUtil.getAttribute(objs[i], "node-agent-ref");
                model.appendRow();
                model.setValue("propertyName", (Object)name);
                model.setValue("propertyValue", (Object)nodeAgent);
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("loadProperties: Loading error. ", (Throwable)ex);
        }
    }

    private String resolveToken(String pn, String serverName) {
        if (Util.isEmpty(serverName)) {
            throw new IllegalArgumentException("The parameter map did not contain serverName");
        }
        String objectName = "com.sun.appserv:type=server,category=config,name=" + serverName;
        String methodName = "listSystemProperties";
        Object[] params = new Object[]{new Boolean("true")};
        String[] types = new String[]{"boolean"};
        try {
            Properties sysProp = (Properties)MBeanUtil.invoke(new ObjectName(objectName), methodName, params, types);
            String value = sysProp.getProperty(pn);
            return value;
        }
        catch (Exception ex) {
            throw new FrameworkException("EndPortDisplay:  ", (Throwable)ex);
        }
    }
}

