/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import [Ljava.lang.Object;;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCActionTable;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCPropertySheetDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LogViewerHandler {
    public static final Integer ONE = new Integer(1);
    public static final Boolean FALSE = new Boolean(false);
    public static final Boolean TRUE = new Boolean(true);
    public static final String[] QUERY_SIGNATURE = new String[]{"java.lang.String", "java.lang.Long", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Integer", "java.util.Date", "java.util.Date", "java.lang.String", "java.lang.Boolean", "java.util.List", "java.util.Properties"};
    public static final String TABLE = "logTable";
    public static final String LOG_MODEL = "logModel";
    public static final String DATE_ENABLED = "dateEnabled";
    public static final String AFTER_RECORD = "afterRecord";
    public static final String FROM_RECORD = "fromRecord";
    public static final String ARCHIVED_LOG_FILE = "archivedLogFile";
    public static final String FROM_DATE = "fromDate";
    public static final String FROM_TIME = "fromTime";
    public static final String TO_DATE = "toDate";
    public static final String TO_TIME = "toTime";
    public static final String LOGGERS = "loggers";
    public static final String LOG_LEVEL = "logLevel";
    public static final String CUSTOM_LOGGERS = "customLogger";
    public static final String NVP = "nvp";
    public static final String NUMBER_TO_DISPLAY = "numberToDisplay";
    public static final String ONLY_LEVEL = "only";
    public static final String LOG_DATE_SORT_DIRECTION = "LOG_DATE_SORT_DIRECTION";
    public static final String SWITCH_DATE_SORT_RESULT = "result";
    public static final String FIRST_LOG_ROW = "firstLogRow";
    public static final String LAST_LOG_ROW = "lastLogRow";
    public static final Integer DEFAULT_NUMBER_TO_DISPLAY = new Integer(40);
    public static final String CUSTOM_LOGGER_DELIMITERS = " \t\n\r\f,;:";
    public static final String NVP_DELIMITERS = " \t\n\r\f,;:";
    public static final char EQUALS = '=';
    public static final String TIME_FORMAT = " HH:mm:ss.SSS";
    public static final String TIME_FORMAT_2 = " HH:mm:ss";
    public static final String TIME_FORMAT_3 = " HH:mm";
    public static final String GET_TIME_RESULT = "value";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String DATE_VALUE = "value";
    public static final String GET_DATE_SHORT = "short";
    public static final String GET_DATE_MEDIUM = "medium";
    public static final String GET_DATE_LONG = "long";
    public static final String GET_DATE_FULL = "full";
    public static final String TRUNCATE_MESSAGE = "truncateMessage";
    public static final String TRUNCATE_LENGTH = "truncateLength";
    public static final String SHOW_LEVEL_IMAGE = "showLevelImage";
    public static final String LEVEL_IMAGE_ROOT = "/com_sun_web_ui/images/alerts/";
    public static final String RESOURCE_BUNDLE = "resourceBundle";
    public static final String PREV_BUTTON_STRING = "prevButtonString";
    public static final String NEXT_BUTTON_STRING = "nextButtonString";
    public static final String END_DISPLAY_STRING = "endDisplayString";
    public static final String LOG_MANAGER_OBJECT_NAME = "logManagerObjectName";
    public static final String INSTANCE_NAME = "instanceName";

    public void filter(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        HttpServletRequest request = ctx.getRequest();
        String archivedLogFile = (String)handlerCtx.getInputValue(ARCHIVED_LOG_FILE);
        Long fromRecord = (Long)handlerCtx.getInputValue(FROM_RECORD);
        Boolean after = (Boolean)handlerCtx.getInputValue(AFTER_RECORD);
        Boolean dateEnabled = (Boolean)handlerCtx.getInputValue(DATE_ENABLED);
        Object fromDate = handlerCtx.getInputValue(FROM_DATE);
        Object fromTime = handlerCtx.getInputValue(FROM_TIME);
        Object toDate = handlerCtx.getInputValue(TO_DATE);
        Object toTime = handlerCtx.getInputValue(TO_TIME);
        Object loggers = handlerCtx.getInputValue(LOGGERS);
        Object logLevel = handlerCtx.getInputValue(LOG_LEVEL);
        Object customLoggers = handlerCtx.getInputValue(CUSTOM_LOGGERS);
        Object nvp = handlerCtx.getInputValue(NVP);
        Integer numberToDisplay = (Integer)handlerCtx.getInputValue(NUMBER_TO_DISPLAY);
        Boolean onlyLevel = (Boolean)handlerCtx.getInputValue(ONLY_LEVEL);
        Boolean direction = (Boolean)handlerCtx.getInputValue(LOG_DATE_SORT_DIRECTION);
        Boolean truncMsg = (Boolean)handlerCtx.getInputValue(TRUNCATE_MESSAGE);
        Integer truncLenInteger = (Integer)handlerCtx.getInputValue(TRUNCATE_LENGTH);
        String logManagerObjectName = (String)handlerCtx.getInputValue(LOG_MANAGER_OBJECT_NAME);
        String instanceName = (String)handlerCtx.getInputValue(INSTANCE_NAME);
        if (instanceName == null || "".equals(instanceName)) {
            handlerCtx.setOutputValue(FIRST_LOG_ROW, (Object)"-1");
            handlerCtx.setOutputValue(LAST_LOG_ROW, (Object)"-1");
            return;
        }
        boolean truncateMessage = true;
        if (truncMsg != null) {
            truncateMessage = truncMsg;
        }
        int truncLen = 100;
        if (truncLenInteger != null) {
            truncLen = truncLenInteger;
        }
        if (archivedLogFile == null || archivedLogFile.equals("")) {
            archivedLogFile = null;
        }
        DefaultModel model = (DefaultModel)handlerCtx.getInputValue(LOG_MODEL);
        DescriptorCCActionTable table = (DescriptorCCActionTable)handlerCtx.getInputValue(TABLE);
        if (table == null && model == null) {
            throw new FrameworkException("Input parameter 'logTable' must be specified with the log table View as the value, or the model to populate should be passed in as Request attribute 'logModel'.", null, view);
        }
        boolean dateEnabledFlag = false;
        if (dateEnabled != null) {
            dateEnabledFlag = dateEnabled;
        }
        if (dateEnabledFlag) {
            fromDate = this.convertDateTime((ServletRequest)request, fromDate, fromTime, table.getViewDescriptor(), view);
            toDate = this.convertDateTime((ServletRequest)request, toDate, toTime, table.getViewDescriptor(), view);
            if (fromDate == null || fromDate == null) {
                throw new FrameworkException("'Specific Date Range' was chosen, however, date fields are incomplete.", null, view);
            }
            if (((Date)fromDate).after((Date)toDate)) {
                throw new FrameworkException("Timestamp value of 'From: ' field " + fromDate + " must not be greater than 'To: ' field value " + toDate, null, view);
            }
        } else {
            fromDate = null;
            toDate = null;
        }
        if (logLevel != null && logLevel.toString().trim().length() == 0) {
            logLevel = null;
        }
        if (onlyLevel == null) {
            onlyLevel = FALSE;
        }
        ArrayList<Object> moduleList = null;
        if (loggers != null) {
            int len = ((Object[])loggers).length;
            moduleList = new ArrayList<Object>(len);
            for (int count = 0; count < len; ++count) {
                Object val = ((Object[])loggers)[count];
                if (val == null || val.toString().trim().length() == 0) continue;
                moduleList.add(val);
            }
        }
        if (customLoggers != null && customLoggers.toString().trim().length() != 0) {
            StringTokenizer tok = new StringTokenizer(customLoggers.toString(), " \t\n\r\f,;:");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (token == null || token.length() == 0) continue;
                moduleList.add(token);
            }
        }
        Properties nvpProps = null;
        if (nvp != null && nvp.toString().trim().length() != 0) {
            nvpProps = new Properties();
            StringTokenizer tok = new StringTokenizer(nvp.toString(), " \t\n\r\f,;:");
            while (tok.hasMoreTokens()) {
                String key;
                ArrayList<String> valueList;
                String token = tok.nextToken();
                if (token == null || token.length() == 0) continue;
                int equalsIdx = token.indexOf(61);
                if (equalsIdx < 0) {
                    throw new FrameworkException("Name-Value Pairs must be in the format \"<name>=<value>\".", null, view);
                }
                if ((valueList = (ArrayList<String>)((Hashtable)nvpProps).get(key = token.substring(0, equalsIdx++))) == null) {
                    valueList = new ArrayList<String>();
                    valueList.add(token.substring(equalsIdx));
                    ((Hashtable)nvpProps).put(key, valueList);
                    continue;
                }
                valueList.add(token.substring(equalsIdx));
            }
        }
        if (numberToDisplay == null) {
            numberToDisplay = DEFAULT_NUMBER_TO_DISPLAY;
        }
        if (direction == null) {
            direction = FALSE;
        }
        if (after == null) {
            after = direction;
        }
        Object[] params = new Object[QUERY_SIGNATURE.length];
        params[0] = archivedLogFile;
        params[1] = fromRecord;
        params[2] = fromRecord == null ? direction : after;
        params[3] = direction;
        params[4] = numberToDisplay;
        params[5] = fromDate;
        params[6] = toDate;
        params[7] = logLevel;
        params[8] = onlyLevel;
        params[9] = moduleList;
        params[10] = nvpProps;
        AttributeList results = null;
        try {
            results = this.getLogRecordsUsingQuery(logManagerObjectName, instanceName, params, QUERY_SIGNATURE);
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while querying Log File.", (Throwable)ex, table == null ? null : table.getViewDescriptor(), view);
        }
        if (model == null) {
            model = (DefaultModel)table.getModel();
        }
        model.clear();
        List headerRow = (List)((Attribute)results.get(0)).getValue();
        List rowList = (List)((Attribute)results.get(1)).getValue();
        Iterator it = rowList.iterator();
        while (it.hasNext()) {
            List row = (List)it.next();
            if (row.size() != headerRow.size()) {
                throw new FrameworkException("Row had '" + row.size() + "' columns, header has '" + headerRow.size() + "' columns!", table.getViewDescriptor(), view);
            }
            model.appendRow();
            model.setValue("recNumber", row.get(0));
            model.setValue("dateTime", (Object)this.formatDateForDisplay(request.getLocale(), (Date)row.get(1)));
            String msgId = (String)row.get(6);
            String level = (String)row.get(2);
            if (level.equalsIgnoreCase("severe")) {
                model.setValue("levelImage", (Object)"/com_sun_web_ui/images/alerts/error_small.gif");
                model.setValue(SHOW_LEVEL_IMAGE, (Object)new Boolean(true));
                model.setValue("diagnosticCauses", (Object)this.getDiagnosticCauses(msgId));
                model.setValue("diagnosticChecks", (Object)this.getDiagnosticChecks(msgId));
                model.setValue("diagnosticURI", (Object)this.getDiagnosticURI(msgId));
            } else {
                model.setValue(SHOW_LEVEL_IMAGE, (Object)new Boolean(false));
                model.setValue("diagnostic", (Object)"");
            }
            model.setValue("level", (Object)level);
            model.setValue("productName", row.get(3));
            model.setValue("logger", row.get(4));
            model.setValue(NVP, row.get(5));
            model.setValue("messageID", (Object)msgId);
            String message = ((String)row.get(7)).trim();
            if (truncateMessage && message.length() > truncLen) {
                message = message.substring(0, truncLen).concat("...\n");
            }
            model.setValue("message", (Object)this.formatMessageForDisplay(message));
        }
        if (rowList.size() > 0) {
            handlerCtx.setOutputValue(FIRST_LOG_ROW, ((List)rowList.get(0)).get(0));
            handlerCtx.setOutputValue(LAST_LOG_ROW, ((List)rowList.get(rowList.size() - 1)).get(0));
        } else {
            handlerCtx.setOutputValue(FIRST_LOG_ROW, (Object)"-1");
            handlerCtx.setOutputValue(LAST_LOG_ROW, (Object)"-1");
        }
    }

    public String generateResultNavBar(RequestContext ctx, HandlerContext handlerCtx) {
        if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
            throw new FrameworkException(this.getClass().getName() + ".generateResultNavBar is only valid for endDisplay events.", null, handlerCtx.getView());
        }
        String firstLogRow = (String)handlerCtx.getInputValue(FIRST_LOG_ROW);
        String lastLogRow = (String)handlerCtx.getInputValue(LAST_LOG_ROW);
        if (firstLogRow == null) {
            firstLogRow = "0";
        }
        if (lastLogRow == null) {
            lastLogRow = "0";
        }
        int firstRow = 0;
        try {
            firstRow = Integer.parseInt(firstLogRow);
            int lastRow = Integer.parseInt(lastLogRow);
            if (firstRow > lastRow) {
                String temp = firstLogRow;
                firstLogRow = lastLogRow;
                lastLogRow = temp;
                firstRow = lastRow;
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        String prevButtonString = (String)handlerCtx.getInputValue(PREV_BUTTON_STRING);
        String nextButtonString = (String)handlerCtx.getInputValue(NEXT_BUTTON_STRING);
        String bundle = (String)handlerCtx.getInputValue(RESOURCE_BUNDLE);
        if (bundle == null) {
            bundle = handlerCtx.getViewDescriptor().getResourceBundle();
        }
        if (bundle == null) {
            throw new FrameworkException("You MUST specify the resource bundle via input parameter: 'resourceBundle'.", null, handlerCtx.getView());
        }
        CCI18N i18n = new CCI18N(ctx, bundle);
        String priorMatches = i18n.getMessage("logViewer.priorMatches");
        String logResultSummary = i18n.getMessage("logViewer.logResultSummary");
        String logResultSummaryThrough = i18n.getMessage("logViewer.logResultSummaryThrough");
        String nextMatches = i18n.getMessage("logViewer.nextMatches");
        StringBuffer content = new StringBuffer(((ChildContentDisplayEvent)handlerCtx.getEvent()).getContent());
        content.append("\n\n");
        content.append("\t<table class=\"Tbl\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
        content.append("\t    <tr><td class=\"TblActTd\" colspan=\"5\" nowrap=\"nowrap\">\n");
        if (firstRow > 0) {
            content.append(prevButtonString);
        }
        content.append("\t\t    <img src=\"../images/spacer.gif\" alt=\"\" width=\"10\" height=\"8\" />\n");
        content.append("\t\t    <span class=\"LblLev2Txt\">\n");
        content.append("\t\t\t<label for=\"page\">" + logResultSummary + " " + firstLogRow + " " + logResultSummaryThrough + " " + lastLogRow + "</label>\n");
        content.append("\t\t    </span><img src=\"../images/spacer.gif\" alt=\"\" width=\"10\" height=\"1\" />\n");
        content.append(nextButtonString);
        content.append("\t\t</td></tr>\n");
        content.append("\t</table>\n<BR>\n\n");
        return content.toString();
    }

    public void getDate(RequestContext ctx, HandlerContext handlerCtx) {
        String formatString = (String)handlerCtx.getInputValue(DATE_FORMAT);
        if (formatString == null || formatString.trim().length() == 0) {
            throw new FrameworkException("You MUST specify the attribute: 'dateFormat' in order for getDate to work!", null, handlerCtx.getView());
        }
        int formatType = -1;
        if (formatString.equals(GET_DATE_SHORT)) {
            formatType = 3;
        } else if (formatString.equals(GET_DATE_MEDIUM)) {
            formatType = 2;
        } else if (formatString.equals(GET_DATE_LONG)) {
            formatType = 1;
        } else if (formatString.equals(GET_DATE_FULL)) {
            formatType = 0;
        }
        DateFormat df = null;
        if (formatType == -1) {
            df = DateFormat.getDateInstance(3, ctx.getRequest().getLocale());
            ((SimpleDateFormat)df).applyLocalizedPattern(formatString);
        } else {
            df = DateFormat.getDateInstance(formatType, ctx.getRequest().getLocale());
        }
        handlerCtx.setOutputValue("value", (Object)df.format(new Date()));
    }

    public void getTime(RequestContext ctx, HandlerContext handlerCtx) {
        DateFormat df = DateFormat.getTimeInstance(3, ctx.getRequest().getLocale());
        ((SimpleDateFormat)df).applyLocalizedPattern(TIME_FORMAT);
        handlerCtx.setOutputValue("value", (Object)df.format(new Date()));
    }

    protected String formatMessageForDisplay(String message) {
        return HtmlUtil.escape((String)message).replaceAll("\n", "<BR>");
    }

    protected String formatArrayListForDisplay(ArrayList diag) {
        StringBuffer buf = new StringBuffer().append("<BR>");
        if (diag == null) {
            return buf.toString();
        }
        for (int i = 0; i < diag.size(); ++i) {
            buf.append((String)diag.get(i));
            buf.append("<BR>");
        }
        return buf.toString();
    }

    protected String formatDateForDisplay(Locale locale, Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat fmt = (SimpleDateFormat)dateFormat;
            fmt.applyLocalizedPattern(fmt.toLocalizedPattern() + TIME_FORMAT);
            return fmt.format(date);
        }
        dateFormat = DateFormat.getDateTimeInstance(2, 1, locale);
        return dateFormat.format(date);
    }

    protected Date convertDateTime(ServletRequest request, Object date, Object time, ViewDescriptor vd, View view) {
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date == null || date.toString().trim().length() == 0) {
            return null;
        }
        if (time.toString().trim().length() == 0) {
            time = null;
        }
        String dateTime = date.toString() + (time == null ? "" : " " + time.toString());
        DateFormat df = DateFormat.getDateInstance(3, request.getLocale());
        if (time != null && df instanceof SimpleDateFormat) {
            SimpleDateFormat fmt = (SimpleDateFormat)df;
            String formatPrefix = fmt.toLocalizedPattern();
            try {
                date = this.parseDateString(fmt, formatPrefix + TIME_FORMAT, dateTime);
            }
            catch (ParseException ex) {
                try {
                    date = this.parseDateString(fmt, formatPrefix + TIME_FORMAT_2, dateTime);
                }
                catch (ParseException ex2) {
                    try {
                        date = this.parseDateString(fmt, formatPrefix + TIME_FORMAT_3, dateTime);
                    }
                    catch (ParseException ex3) {
                        throw new FrameworkException("Unable to parse Date/Time: '" + dateTime + "'.", (Throwable)ex3, vd, view);
                    }
                }
            }
        } else {
            if (time != null) {
                df = DateFormat.getDateTimeInstance(3, 1, request.getLocale());
                try {
                    date = df.parse(dateTime);
                }
                catch (ParseException ex) {
                    throw new FrameworkException("Unable to parse Date/Time: '" + dateTime + "'.", (Throwable)ex, vd, view);
                }
            }
            try {
                date = df.parse(dateTime);
            }
            catch (ParseException ex) {
                throw new FrameworkException("Unable to parse Date/Time: '" + dateTime + "'.", (Throwable)ex, vd, view);
            }
        }
        return (Date)date;
    }

    private Date parseDateString(SimpleDateFormat fmt, String format, String dateTime) throws ParseException {
        fmt.applyLocalizedPattern(format);
        return fmt.parse(dateTime);
    }

    private String getDiagnosticCauses(String msgId) {
        if (msgId == null || "".equals(msgId)) {
            return this.formatArrayListForDisplay(null);
        }
        Object[] params = new String[]{msgId};
        String[] signatures = new String[]{"String"};
        try {
            ArrayList results = (ArrayList)MBeanUtil.invoke("com.sun.appserv:name=logmanager,category=runtime,server=server", "getDiagnosticCausesForMessageId", params, signatures);
            String res = this.formatArrayListForDisplay(results);
            return res;
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while retrieving diagnostic from messageId.", (Throwable)ex);
        }
    }

    private String getDiagnosticChecks(String msgId) {
        if (msgId == null || "".equals(msgId)) {
            return this.formatArrayListForDisplay(null);
        }
        Object[] params = new String[]{msgId};
        String[] signatures = new String[]{"String"};
        try {
            ArrayList results = (ArrayList)MBeanUtil.invoke("com.sun.appserv:name=logmanager,category=runtime,server=server", "getDiagnosticChecksForMessageId", params, signatures);
            String res = this.formatArrayListForDisplay(results);
            return res;
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while retrieving diagnostic checks from messageId.", (Throwable)ex);
        }
    }

    private String getDiagnosticURI(String msgId) {
        if (msgId == null || "".equals(msgId)) {
            return "";
        }
        Object[] params = new String[]{msgId};
        String[] signatures = new String[]{"String"};
        try {
            String res = (String)MBeanUtil.invoke("com.sun.appserv:name=logmanager,category=runtime,server=server", "getDiagnosticURIForMessageId", params, signatures);
            return res;
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while retrieving diagnostic URI from messageId.", (Throwable)ex);
        }
    }

    public boolean hasResults(RequestContext ctx, HandlerContext handlerCtx) {
        DescriptorCCActionTable table = (DescriptorCCActionTable)ctx.getRequest().getAttribute(TABLE);
        if (table == null) {
            return false;
        }
        DefaultModel model = (DefaultModel)table.getModel();
        try {
            int size = model.getSize();
            if (size > 0) {
                handlerCtx.setOutputValue("hasResults", (Object)"true");
                return true;
            }
            handlerCtx.setOutputValue("hasResults", (Object)"false");
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void switchDateSort(RequestContext ctx, HandlerContext handlerCtx) {
        HttpSession session = ctx.getRequest().getSession();
        Boolean dir = (Boolean)handlerCtx.getInputValue(LOG_DATE_SORT_DIRECTION);
        dir = dir == null ? TRUE : new Boolean(dir ^ true);
        handlerCtx.setOutputValue(SWITCH_DATE_SORT_RESULT, (Object)dir);
        ContainerView cv = (ContainerView)handlerCtx.getView().getParent();
        HttpServletRequest request = ctx.getRequest();
        cv.setDisplayFieldValue("PrimarySortOrderHiddenField", (Object)request.getParameter("sortOrder"));
        cv.setDisplayFieldValue("PrimarySortNameHiddenField", (Object)request.getParameter("sortName"));
    }

    public void testRunning(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        HttpServletRequest request = ctx.getRequest();
        String instanceName = (String)handlerCtx.getInputValue(INSTANCE_NAME);
        if (LogViewerHandler.isServerRunning(instanceName)) {
            handlerCtx.setOutputValue("isRunning", (Object)"true");
        } else {
            handlerCtx.setOutputValue("isRunning", (Object)"false");
        }
    }

    public void getLogFilesDirectory(RequestContext ctx, HandlerContext handlerCtx) {
        HttpServletRequest request = ctx.getRequest();
        String instanceName = (String)handlerCtx.getInputValue(INSTANCE_NAME);
        try {
            String dir = LogViewerHandler.getLogFilesDirectory(instanceName);
            handlerCtx.setOutputValue("logFileDirectory", (Object)dir);
        }
        catch (Exception ex) {
            handlerCtx.setOutputValue("logFileDirectory", (Object)"");
        }
    }

    public void displayAdvancedSearchOptions(RequestContext ctx, HandlerContext handlerCtx) {
        DescriptorContainerView descView;
        ViewDescriptor propertySheetDescriptor;
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
                throw new FrameworkException("View is not a DescriptorContainerView!", null, view);
            }
            view = parent;
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        if ((propertySheetDescriptor = (descView = (DescriptorContainerView)view).getViewDescriptor()) == null) {
            throw new FrameworkException("propertySheetDescriptor is null", propertySheetDescriptor, view);
        }
        if (!(propertySheetDescriptor instanceof CCPropertySheetDescriptor)) {
            throw new FrameworkException("propertySheetDescriptor is of wrong type", propertySheetDescriptor, view);
        }
        CCPropertySheetModelInterface model = ((CCPropertySheetDescriptor)propertySheetDescriptor).getModel();
        boolean searchAdvance = new Boolean("" + ctx.getRequest().getAttribute("ShowAdvanceSearch"));
        if (searchAdvance) {
            model.setVisible("advanceSearch", true);
            model.setVisible("advanceLink", false);
            model.setVisible("basicLink", true);
            handlerCtx.setOutputValue("showAdvance", (Object)"true");
        } else {
            model.setVisible("advanceSearch", false);
            model.setVisible("advanceLink", true);
            model.setVisible("basicLink", false);
            handlerCtx.setOutputValue("showAdvance", (Object)"false");
        }
    }

    public String setEndDisplayString(RequestContext ctx, HandlerContext handlerCtx) {
        String endDisplayString = (String)handlerCtx.getInputValue(END_DISPLAY_STRING);
        if (endDisplayString == null) {
            throw new FrameworkException("'endDisplayString' cannot be null!");
        }
        return endDisplayString;
    }

    private static boolean isEmpty(String test) {
        return test == null || "".equals(test);
    }

    public static String getLogFilesDirectory(String instanceName) {
        if (LogViewerHandler.isEmpty(instanceName)) {
            return "";
        }
        String dir = "";
        try {
            if (MBeanUtil.isValidMBean("com.sun.appserv:name=logmanager,category=runtime,server=" + instanceName)) {
                dir = (String)MBeanUtil.invoke("com.sun.appserv:name=logmanager,category=runtime,server=" + instanceName, "getLogFilesDirectory", null, null);
            } else {
                Class<?> provider = Class.forName("com.sun.enterprise.ee.tools.admingui.handlers.NodeAgentLogProvider");
                Class[] type = new Class[]{String.class};
                Method method = provider.getMethod("getLogFilesDirectory", type);
                Object[] args = new Object[]{instanceName};
                dir = (String)method.invoke(null, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dir;
    }

    public static boolean isServerRunning(String instanceName) {
        if (LogViewerHandler.isEmpty(instanceName)) {
            return false;
        }
        return MBeanUtil.isValidMBean("com.sun.appserv:name=logmanager,category=runtime,server=" + instanceName);
    }

    private AttributeList getLogRecordsUsingQuery(String logManagerObjectName, String instanceName, Object[] params, String[] QUERY_SIGNATURE) {
        AttributeList results = null;
        if (MBeanUtil.isValidMBean(logManagerObjectName)) {
            results = (AttributeList)MBeanUtil.invoke(logManagerObjectName, "getLogRecordsUsingQuery", params, QUERY_SIGNATURE);
            return results;
        }
        try {
            Class<?> provider = Class.forName("com.sun.enterprise.ee.tools.admingui.handlers.NodeAgentLogProvider");
            Class[] type = new Class[]{String.class, Object;.class};
            Method method = provider.getMethod("getLogRecordsUsingQuery", type);
            Object[] args = new Object[]{instanceName, params};
            results = (AttributeList)method.invoke(null, args);
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex);
        }
        return results;
    }
}

