/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.sun.enterprise.connectors.util.ConnectionDefinitionUtils;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCTextField;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpSession;

public class JdbcConnectionPoolHandlers {
    public static final String PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_VALUE = "propertyValue";

    public void getValuesFromStep1(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view);
        ViewDescriptor vd = descView.getViewDescriptor();
        HttpSession session = RequestManager.getSession();
        DefaultModel step1Model = (DefaultModel)session.getValue("connectionPoolStep1.model");
        DefaultModel step2Model = (DefaultModel)session.getValue("connectionPoolStep2.model");
        String resourceType = (String)step1Model.getValue("ResourceType");
        String vendor = (String)step1Model.getValue("Vendor");
        boolean changed = true;
        if (step2Model != null && resourceType != null && resourceType.equals(step2Model.getValue("ResourceType")) && vendor != null && vendor.equals(step2Model.getValue("Vendor"))) {
            changed = false;
        }
        descView.setDisplayFieldValue("Name", step1Model.getValue("Name"));
        descView.setDisplayFieldValue("ResourceType", (Object)resourceType);
        descView.setDisplayFieldValue("Vendor", (Object)vendor);
        if (changed) {
            this.setDatasourceClassName(ctx, handlerCtx);
        }
    }

    public void getValuesFromStep2(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view);
        ViewDescriptor vd = descView.getViewDescriptor();
        HttpSession session = RequestManager.getSession();
        DefaultModel step2Model = (DefaultModel)session.getValue("connectionPoolStep2.model");
        String oldDataSource = (String)descView.getDisplayFieldValue("DatasourceClassName");
        String newDataSource = (String)step2Model.getValue("DatasourceClassName");
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("propertiesModel");
        if (oldDataSource == null || newDataSource != null && !oldDataSource.equals(newDataSource)) {
            this.populateProperties(newDataSource, model);
        }
        descView.setDisplayFieldValue("Name", step2Model.getValue("Name"));
        descView.setDisplayFieldValue("Vendor", step2Model.getValue("Vendor"));
        descView.setDisplayFieldValue("ResourceType", step2Model.getValue("ResourceType"));
        descView.setDisplayFieldValue("DatasourceClassName", step2Model.getValue("DatasourceClassName"));
    }

    public void setDatasourceClassName(RequestContext ctx, HandlerContext handlerCtx) {
        String resourceType;
        DescriptorContainerView descView = (DescriptorContainerView)handlerCtx.getView();
        ViewDescriptor vd = descView.getViewDescriptor();
        String vendor = (String)descView.getDisplayFieldValue("Vendor");
        String datasourceClassName = JdbcConnectionPoolHandlers.getDatasourceClassName(vendor, resourceType = (String)descView.getDisplayFieldValue("ResourceType"));
        if (datasourceClassName != null) {
            descView.setDisplayFieldValue("DatasourceClassName", (Object)datasourceClassName.trim());
        }
    }

    public void enableGuaranteeIsolation(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        CCCheckBox guaranteeIsolation = (CCCheckBox)view;
        DescriptorContainerView descView = (DescriptorContainerView)view.getParent();
        String transIsolation = (String)descView.getDisplayFieldValue("TransactionIsolation");
        if (transIsolation != null && transIsolation.length() > 0) {
            guaranteeIsolation.setDisabled(false);
        } else {
            guaranteeIsolation.setValue((Object)"false");
            guaranteeIsolation.setDisabled(true);
        }
    }

    public void enableTableName(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        CCTextField tableName = (CCTextField)view;
        DescriptorContainerView descView = (DescriptorContainerView)view.getParent();
        String validMethod = (String)descView.getDisplayFieldValue("ConnectionValidationMethod");
        if (validMethod != null && validMethod.equals("table")) {
            tableName.setDisabled(false);
        } else {
            tableName.setDisabled(true);
        }
    }

    public static String getDatasourceClassName(String vendor, String resourceType) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.sun.enterprise.tools.admingui.resources.JdbcVendors");
        if (vendor != null) {
            try {
                return bundle.getString(vendor.toLowerCase() + "," + resourceType);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public void populateProperties(String dataSource, CCActionTableModelInterface model) throws ModelControlException {
        String[] defaultProperties = new String[]{"databaseName", "serverName", "port", "networkProtocol", "user", "password", "roleName", "datasourceName"};
        RequestContext ctx = RequestManager.getRequestContext();
        Map properties = null;
        try {
            properties = ConnectionDefinitionUtils.getConnectionDefinitionPropertiesAndDefaults((String)dataSource.trim());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (properties == null || properties.size() == 0) {
            ((DefaultModel)model).clear();
            model.beforeFirst();
            for (int i = 0; i < defaultProperties.length; ++i) {
                model.appendRow();
                model.setValue(PROPERTY_NAME, (Object)defaultProperties[i]);
                model.setValue(PROPERTY_VALUE, (Object)"");
                model.setRowSelected(false);
            }
        } else {
            Iterator keys = properties.keySet().iterator();
            ((DefaultModel)model).clear();
            model.beforeFirst();
            while (keys.hasNext()) {
                model.appendRow();
                String name = (String)keys.next();
                model.setValue(PROPERTY_NAME, (Object)name);
                model.setValue(PROPERTY_VALUE, properties.get(name));
                model.setRowSelected(false);
            }
        }
    }

    public static void main(String[] __args) {
        System.out.println("DS = " + JdbcConnectionPoolHandlers.getDatasourceClassName("sybase", "javax.sql.XADataSource"));
    }
}

