/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.ModelManager;
import com.iplanet.jato.ModelTypeMap;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.View;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.admingui.LockhartEntityResolver;
import com.sun.enterprise.tools.admingui.ModelTypeMapImpl;
import com.sun.enterprise.tools.admingui.PlainFormatter;
import com.sun.enterprise.tools.admingui.handlers.CommonHandlers;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.util.LogUtil;
import com.sun.enterprise.tools.guiframework.view.BaseServlet;
import com.sun.enterprise.tools.guiframework.view.ViewXMLEntityResolver;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.ErrorEvent;
import com.sun.web.ui.common.CCPrivateConfiguration;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.xml.sax.EntityResolver;

public class AdminGUIServlet
extends BaseServlet {
    private static final boolean debug = false;
    public static final String DEFAULT_MODULE_URL = "../admingui";
    public static String PACKAGE_NAME = AdminGUIServlet.getPackageName((String)AdminGUIServlet.class.getName());
    protected static final String UNCAUGHT_REDIR = "__uncaughtRedirFlag";
    protected EntityResolver entityResolver;
    protected static ModelTypeMap MODEL_TYPE_MAP;

    public AdminGUIServlet() {
        this.setDefaultHandlerName("TopFrameset");
        this.setEnforceStrictSessionTimeout(true);
        this.setupConfig();
        CCPrivateConfiguration.setEntityResolver((EntityResolver)new LockhartEntityResolver());
    }

    protected void handleUncaughtException(ErrorEvent errorEvent) {
        block13: {
            if (Util.isLoggableWARNING()) {
                Util.logWARNING("Exception NOT handled!", errorEvent.getException());
            }
            ViewDescriptor viewDesc = errorEvent.getCauseViewDescriptor();
            if (Util.isLoggableINFO() && viewDesc != null) {
                Util.logINFO("Problem near ViewDescriptor: '" + viewDesc.getName() + "'");
            }
            String cause = errorEvent.getCauseMessage();
            if (Util.isLoggableINFO() && cause != null) {
                Util.logINFO(cause);
            }
            if (Util.isLoggableINFO()) {
                Util.logINFO(errorEvent.getRegularTrace());
            }
            if (viewDesc != null) {
                while (viewDesc.getParent() != null) {
                    viewDesc = viewDesc.getParent();
                }
                RequestContext ctx = RequestManager.getRequestContext();
                String redirName = null;
                View view = null;
                try {
                    view = viewDesc.getView(ctx);
                    while (view.getParent() != null) {
                        view = view.getParent();
                    }
                    redirName = view.getName();
                }
                catch (Exception ex) {
                    if (Util.isLoggableWARNING()) {
                        Util.logWARNING(ex);
                    }
                    redirName = viewDesc.getName();
                }
                try {
                    HttpServletRequest req = ctx.getRequest();
                    if (req.getAttribute(UNCAUGHT_REDIR) != null) {
                        return;
                    }
                    ctx.getRequest().setAttribute(UNCAUGHT_REDIR, (Object)"true");
                    ctx.getResponse().sendRedirect(redirName);
                }
                catch (Throwable ex) {
                    if (!Util.isLoggableWARNING()) break block13;
                    Util.logWARNING(ex);
                }
            }
        }
    }

    private void changeLogFileFormatter() {
        Handler[] h = LogUtil._logger.getHandlers();
        for (int i = 0; i < h.length; ++i) {
            h[i].setFormatter(new PlainFormatter());
        }
    }

    protected URL getViewXMLURL() {
        String viewXMLFile = ConfigProperties.getInstance().getViewXMLFileName();
        URL viewXML = null;
        viewXML = ((Object)((Object)this)).getClass().getClassLoader().getResource(viewXMLFile);
        if (viewXML == null) {
            if (Util.isLoggableSEVERE()) {
                Util.logSEVERE("Unable to find XML FILE in the CLASSPATH: " + viewXMLFile);
            }
            String sURL = "file:///" + this.getServletConfig().getServletContext().getRealPath(viewXMLFile);
            System.out.println("sURL: " + sURL);
            try {
                viewXML = new URL(sURL);
            }
            catch (Exception exc) {
                throw new FrameworkException("Unable to create URL: '" + sURL + "' while attempting to locate '" + viewXMLFile + "'", (Throwable)exc);
            }
        }
        return viewXML;
    }

    protected EntityResolver getViewXMLEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = new ViewXMLEntityResolver();
        }
        return this.entityResolver;
    }

    protected String getJSPRoot() {
        return "/jsp/";
    }

    protected String getPackageName() {
        return PACKAGE_NAME;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        MODEL_TYPE_MAP = new ModelTypeMapImpl();
    }

    protected void setupConfig() {
        ConfigProperties config = ConfigProperties.getInstance();
        config.setViewXMLFileName("xml/viewDescriptor.xml");
        config.setTreeXMLFileName("xml/treeDescriptor.xml", "index");
        config.setDefaultDisplayURLDir("/jsp/");
        config.setTargetSupported(new Boolean(false));
        config.setInitialRightPage("homePageFrameset");
        config.setLoggerName("javax.enterprise.system.tools.admin");
        config.setDefaultTarget("server");
        config.setConsoleTitleKey("common.consoleTitlePE");
    }

    protected void onBeforeRequest(RequestContext requestContext) throws ServletException {
        block5: {
            HttpSession session = requestContext.getRequest().getSession();
            if (session != null) {
                try {
                    String timeOutSet = (String)session.getAttribute("AdminGUItimeOut");
                    if (timeOutSet == null) {
                        session.setAttribute("AdminGUItimeOut", (Object)"true");
                        CommonHandlers.setTimeOut(requestContext);
                    }
                }
                catch (CompleteRequestException cre) {
                    throw new CompleteRequestException();
                }
                catch (Exception ex) {
                    if (!Util.isLoggableINFO()) break block5;
                    Util.logINFO(ex);
                }
            }
        }
    }

    protected void onNewSession(RequestContext requestContext) throws ServletException {
        super.onNewSession(requestContext);
        CommonHandlers.setTimeOut(requestContext);
    }

    protected void onSessionTimeout(RequestContext requestContext) throws ServletException {
        block4: {
            try {
                String fileName = Util.getLocalizedHTML(requestContext, "/index.html");
                requestContext.getResponse().sendRedirect(".." + fileName);
            }
            catch (IOException ex) {
                if (Util.isLoggableWARNING()) {
                    Util.logWARNING(ex);
                }
            }
            catch (IllegalStateException ex) {
                if (!Util.isLoggableWARNING()) break block4;
                Util.logWARNING(ex);
            }
        }
        throw new CompleteRequestException();
    }

    protected void initializeRequestContext(RequestContext requestContext) {
        block3: {
            super.initializeRequestContext(requestContext);
            try {
                HttpServletRequest request = requestContext.getRequest();
                if (request != null) {
                    request.setCharacterEncoding("UTF-8");
                }
            }
            catch (UnsupportedEncodingException ex) {
                if (!Util.isLoggableWARNING()) break block3;
                Util.logWARNING(ex);
            }
        }
        com.sun.enterprise.tools.guiframework.model.ModelManager modelManager = new com.sun.enterprise.tools.guiframework.model.ModelManager(requestContext, MODEL_TYPE_MAP);
        ((RequestContextImpl)requestContext).setModelManager((ModelManager)modelManager);
    }

    public String getModuleURL() {
        String result = super.getModuleURL();
        if (result != null) {
            return result;
        }
        return DEFAULT_MODULE_URL;
    }

    static {
        LogUtil.setLevel((Level)LogUtil.WARNING);
    }
}

