/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.dom.DOMErrorImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DOMStringListImpl;
import com.sun.org.apache.xerces.internal.dom3.DOMConfiguration;
import com.sun.org.apache.xerces.internal.dom3.DOMErrorHandler;
import com.sun.org.apache.xerces.internal.dom3.DOMStringList;
import com.sun.org.apache.xerces.internal.impl.Constants;
import com.sun.org.apache.xerces.internal.parsers.AbstractDOMParser;
import com.sun.org.apache.xerces.internal.parsers.XML11Configuration;
import com.sun.org.apache.xerces.internal.util.DOMEntityResolverWrapper;
import com.sun.org.apache.xerces.internal.util.DOMErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration;
import java.io.StringReader;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSParserFilter;
import org.w3c.dom.ls.LSResourceResolver;

public class DOMParserImpl
extends AbstractDOMParser
implements LSParser,
DOMConfiguration {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String PSVI_AUGMENT = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected String fSchemaType = null;
    protected boolean fBusy = false;
    protected static final boolean DEBUG = false;
    private Vector fSchemaLocations = new Vector();
    private String fSchemaLocation = null;
    private DOMStringList fRecognizedParameters;

    public DOMParserImpl(String configuration, String schemaType) {
        this(new XML11Configuration());
        if (schemaType != null) {
            if (schemaType.equals(Constants.NS_DTD)) {
                this.fConfiguration.setFeature(XMLSCHEMA, false);
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                this.fSchemaType = Constants.NS_DTD;
            } else if (schemaType.equals(Constants.NS_XMLSCHEMA)) {
                this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
            }
        }
    }

    public DOMParserImpl(XMLParserConfiguration config) {
        super(config);
        String[] domRecognizedFeatures = new String[]{"canonical-form", "cdata-sections", "charset-overrides-xml-encoding", "infoset", "namespace-declarations", "supported-media-types-only", "certified", "well-formed", "ignore-unknown-character-denormalizations"};
        this.fConfiguration.addRecognizedFeatures(domRecognizedFeatures);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.fConfiguration.setFeature("namespace-declarations", true);
        this.fConfiguration.setFeature("well-formed", true);
        this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", true);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", true);
        this.fConfiguration.setFeature(NAMESPACES, true);
        this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
        this.fConfiguration.setFeature(NORMALIZE_DATA, false);
        this.fConfiguration.setFeature("http://apache.org/xml/features/create-cdata-nodes", false);
        this.fConfiguration.setFeature("canonical-form", false);
        this.fConfiguration.setFeature("charset-overrides-xml-encoding", true);
        this.fConfiguration.setFeature("supported-media-types-only", false);
        this.fConfiguration.setFeature("ignore-unknown-character-denormalizations", true);
        this.fConfiguration.setFeature("certified", true);
        this.fConfiguration.setFeature(NORMALIZE_DATA, false);
    }

    public DOMParserImpl(SymbolTable symbolTable) {
        this(new XML11Configuration());
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
    }

    public DOMParserImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this(new XML11Configuration());
        this.fConfiguration.setProperty(SYMBOL_TABLE, symbolTable);
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
    }

    public void reset() {
        super.reset();
        if (this.fSkippedElemStack != null) {
            this.fSkippedElemStack.removeAllElements();
        }
        this.fSchemaLocations.clear();
        this.fRejectedElement.clear();
        this.fFilterReject = false;
        this.fSchemaType = null;
    }

    public DOMConfiguration getDomConfig() {
        return this;
    }

    public LSParserFilter getFilter() {
        return this.fDOMFilter;
    }

    public void setFilter(LSParserFilter filter) {
        this.fDOMFilter = filter;
        if (this.fSkippedElemStack == null) {
            this.fSkippedElemStack = new Stack();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameter(String name, Object value) throws DOMException {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            try {
                if (name.equals("comments")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", state);
                    return;
                }
                if (name.equals("datatype-normalization")) {
                    this.fConfiguration.setFeature(NORMALIZE_DATA, state);
                    return;
                }
                if (name.equals("entities")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", state);
                    return;
                }
                if (name.equals("disallow-doctype")) {
                    this.fConfiguration.setFeature(DISALLOW_DOCTYPE_DECL_FEATURE, state);
                    return;
                }
                if (name.equals("supported-media-types-only") || name.equals("normalize-characters") || name.equals("check-character-normalization") || name.equals("canonical-form")) {
                    if (!state) return;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
                if (name.equals("namespaces")) {
                    this.fConfiguration.setFeature(NAMESPACES, state);
                    return;
                }
                if (name.equals("infoset")) {
                    if (!state) return;
                    this.fConfiguration.setFeature(NAMESPACES, true);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", true);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", true);
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
                    this.fConfiguration.setFeature(NORMALIZE_DATA, false);
                    this.fConfiguration.setFeature("http://apache.org/xml/features/create-cdata-nodes", false);
                    return;
                }
                if (name.equals("cdata-sections")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/create-cdata-nodes", state);
                    return;
                }
                if (name.equals("namespace-declarations") || name.equals("well-formed") || name.equals("ignore-unknown-character-denormalizations")) {
                    if (state) return;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
                if (name.equals("validate")) {
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, state);
                    if (this.fSchemaType != Constants.NS_DTD) {
                        this.fConfiguration.setFeature(XMLSCHEMA, state);
                    }
                    if (!state) return;
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, false);
                    return;
                }
                if (name.equals("validate-if-schema")) {
                    this.fConfiguration.setFeature(DYNAMIC_VALIDATION, state);
                    if (!state) return;
                    this.fConfiguration.setFeature(VALIDATION_FEATURE, false);
                    return;
                }
                if (name.equals("element-content-whitespace")) {
                    this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", state);
                    return;
                }
                if (name.equals("psvi")) {
                    this.fConfiguration.setFeature(PSVI_AUGMENT, true);
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", "com.sun.org.apache.xerces.internal.dom.PSVIDocumentImpl");
                    return;
                }
                this.fConfiguration.setFeature(name, state);
                return;
            }
            catch (XMLConfigurationException e) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
                throw new DOMException(8, msg);
            }
        }
        if (name.equals("error-handler")) {
            if (value == null) {
                return;
            }
            if (value instanceof DOMErrorHandler) {
                try {
                    this.fErrorHandler = new DOMErrorHandlerWrapper((DOMErrorHandler)value);
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", this.fErrorHandler);
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("resource-resolver")) {
            if (value instanceof LSResourceResolver) {
                try {
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper((LSResourceResolver)value));
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("schema-location")) {
            if (value instanceof String) {
                try {
                    if (this.fSchemaType == Constants.NS_XMLSCHEMA) {
                        this.fSchemaLocation = (String)value;
                        StringTokenizer t = new StringTokenizer(this.fSchemaLocation, " \n\t\r");
                        if (t.hasMoreTokens()) {
                            this.fSchemaLocations.clear();
                            this.fSchemaLocations.add(t.nextToken());
                            while (t.hasMoreTokens()) {
                                this.fSchemaLocations.add(t.nextToken());
                            }
                            this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.fSchemaLocations.toArray());
                            return;
                        } else {
                            this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", value);
                        }
                        return;
                    }
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                    throw new DOMException(9, msg);
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("schema-type")) {
            if (value instanceof String) {
                try {
                    if (value.equals(Constants.NS_XMLSCHEMA)) {
                        this.fConfiguration.setFeature(XMLSCHEMA, true);
                        this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_XMLSCHEMA);
                        this.fSchemaType = Constants.NS_XMLSCHEMA;
                        return;
                    }
                    if (!value.equals(Constants.NS_DTD)) return;
                    this.fConfiguration.setFeature(XMLSCHEMA, false);
                    this.fConfiguration.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", Constants.NS_DTD);
                    this.fSchemaType = Constants.NS_DTD;
                    return;
                }
                catch (XMLConfigurationException e) {}
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("http://apache.org/xml/properties/dom/document-class-name")) {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/dom/document-class-name", value);
            return;
        } else {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
    }

    public Object getParameter(String name) throws DOMException {
        if (name.equals("comments")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("datatype-normalization")) {
            return this.fConfiguration.getFeature(NORMALIZE_DATA) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("entities")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("namespaces")) {
            return this.fConfiguration.getFeature(NAMESPACES) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("validate")) {
            return this.fConfiguration.getFeature(VALIDATION_FEATURE) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("validate-if-schema")) {
            return this.fConfiguration.getFeature(DYNAMIC_VALIDATION) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("element-content-whitespace")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("disallow-doctype")) {
            return this.fConfiguration.getFeature(DISALLOW_DOCTYPE_DECL_FEATURE) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("infoset")) {
            boolean infoset = this.fConfiguration.getFeature(NAMESPACES) && this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments") && this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace") && !this.fConfiguration.getFeature(DYNAMIC_VALIDATION) && !this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes") && !this.fConfiguration.getFeature(NORMALIZE_DATA) && !this.fConfiguration.getFeature("http://apache.org/xml/features/create-cdata-nodes");
            return infoset ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("cdata-sections")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/create-cdata-nodes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("check-character-normalization") || name.equals("normalize-characters")) {
            return Boolean.FALSE;
        }
        if (name.equals("namespace-declarations") || name.equals("well-formed") || name.equals("ignore-unknown-character-denormalizations") || name.equals("canonical-form") || name.equals("supported-media-types-only") || name.equals("charset-overrides-xml-encoding")) {
            return this.fConfiguration.getFeature(name) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("error-handler")) {
            if (this.fErrorHandler != null) {
                return this.fErrorHandler.getErrorHandler();
            }
            return null;
        }
        if (name.equals("resource-resolver")) {
            try {
                XMLEntityResolver entityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
                if (entityResolver != null && entityResolver instanceof DOMEntityResolverWrapper) {
                    return ((DOMEntityResolverWrapper)entityResolver).getEntityResolver();
                }
                return null;
            }
            catch (XMLConfigurationException e) {}
        } else {
            if (name.equals("schema-type")) {
                return this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            }
            if (name.equals("schema-location")) {
                return this.fSchemaLocation;
            }
            if (name.equals(SYMBOL_TABLE)) {
                return this.fConfiguration.getProperty(SYMBOL_TABLE);
            }
            if (name.equals("http://apache.org/xml/properties/dom/document-class-name")) {
                return this.fConfiguration.getProperty("http://apache.org/xml/properties/dom/document-class-name");
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
        return null;
    }

    public boolean canSetParameter(String name, Object value) {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            if (name.equals("supported-media-types-only") || name.equals("normalize-characters") || name.equals("check-character-normalization") || name.equals("canonical-form")) {
                return !state;
            }
            if (name.equals("namespace-declarations") || name.equals("well-formed") || name.equals("ignore-unknown-character-denormalizations")) {
                return state;
            }
            if (name.equals("cdata-sections") || name.equals("charset-overrides-xml-encoding") || name.equals("comments") || name.equals("datatype-normalization") || name.equals("disallow-doctype") || name.equals("entities") || name.equals("infoset") || name.equals("namespaces") || name.equals("validate") || name.equals("validate-if-schema") || name.equals("element-content-whitespace") || name.equals("xml-declaration")) {
                return true;
            }
            try {
                this.fConfiguration.getFeature(name);
                return true;
            }
            catch (XMLConfigurationException e) {
                return false;
            }
        }
        if (name.equals("error-handler")) {
            return value instanceof DOMErrorHandler;
        }
        if (name.equals("resource-resolver")) {
            return value instanceof LSResourceResolver;
        }
        if (name.equals("schema-type")) {
            return value instanceof String && (value.equals(Constants.NS_XMLSCHEMA) || value.equals(Constants.NS_DTD));
        }
        if (name.equals("schema-location")) {
            return value instanceof String;
        }
        return name.equals("http://apache.org/xml/properties/dom/document-class-name");
    }

    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            Vector<String> parameters = new Vector<String>();
            parameters.add("namespaces");
            parameters.add("cdata-sections");
            parameters.add("canonical-form");
            parameters.add("namespace-declarations");
            parameters.add("entities");
            parameters.add("validate-if-schema");
            parameters.add("validate");
            parameters.add("datatype-normalization");
            parameters.add("charset-overrides-xml-encoding");
            parameters.add("check-character-normalization");
            parameters.add("supported-media-types-only");
            parameters.add("ignore-unknown-character-denormalizations");
            parameters.add("normalize-characters");
            parameters.add("well-formed");
            parameters.add("infoset");
            parameters.add("disallow-doctype");
            parameters.add("element-content-whitespace");
            parameters.add("entities");
            parameters.add("element-content-whitespace");
            parameters.add("comments");
            parameters.add("error-handler");
            parameters.add("resource-resolver");
            parameters.add("schema-location");
            parameters.add("schema-type");
            this.fRecognizedParameters = new DOMStringListImpl(parameters);
        }
        return this.fRecognizedParameters;
    }

    public Document parseURI(String uri) throws LSException {
        block4: {
            if (this.fBusy) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null);
                throw new DOMException(11, msg);
            }
            XMLInputSource source = new XMLInputSource(null, uri, null);
            try {
                this.fBusy = true;
                this.parse(source);
                this.fBusy = false;
            }
            catch (Exception e) {
                this.fBusy = false;
                if (e == abort) break block4;
                if (this.fErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(error);
                }
                throw new LSException(81, e.getMessage());
            }
        }
        return this.getDocument();
    }

    public Document parse(LSInput is) throws LSException {
        block4: {
            XMLInputSource xmlInputSource = this.dom2xmlInputSource(is);
            if (this.fBusy) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null);
                throw new DOMException(11, msg);
            }
            try {
                this.fBusy = true;
                this.parse(xmlInputSource);
                this.fBusy = false;
            }
            catch (Exception e) {
                this.fBusy = false;
                if (e == abort) break block4;
                if (this.fErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)3;
                    this.fErrorHandler.getErrorHandler().handleError(error);
                }
                throw new LSException(81, e.getMessage());
            }
        }
        return this.getDocument();
    }

    public Node parseWithContext(LSInput is, Node cnode, short action) throws DOMException, LSException {
        throw new DOMException(9, "Not supported");
    }

    XMLInputSource dom2xmlInputSource(LSInput is) {
        XMLInputSource xis = null;
        xis = is.getStringData() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), new StringReader(is.getStringData()), "UTF-16") : (is.getCharacterStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getCharacterStream(), "UTF-16") : (is.getByteStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getByteStream(), is.getEncoding()) : new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI())));
        return xis;
    }

    public boolean getAsync() {
        return false;
    }

    public boolean getBusy() {
        return this.fBusy;
    }

    public void abort() {
        if (this.fBusy) {
            this.fBusy = false;
            throw abort;
        }
    }
}

