/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.opti;

import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaSymbols;
import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultXMLDocumentHandler;
import com.sun.org.apache.xerces.internal.impl.xs.opti.SchemaDOM;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Document;

public class SchemaDOMParser
extends DefaultXMLDocumentHandler {
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected XMLLocator fLocator;
    protected NamespaceContext fNamespaceContext = null;
    SchemaDOM schemaDOM;
    XMLParserConfiguration config;
    private int fAnnotationDepth = -1;
    private int fInnerAnnotationDepth = -1;
    private int fDepth = -1;
    XMLErrorReporter fErrorReporter;

    public SchemaDOMParser(XMLParserConfiguration config) {
        this.config = config;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.fErrorReporter = (XMLErrorReporter)this.config.getProperty(ERROR_REPORTER);
        this.schemaDOM = new SchemaDOM();
        this.fAnnotationDepth = -1;
        this.fInnerAnnotationDepth = -1;
        this.fDepth = -1;
        this.fLocator = locator;
        this.fNamespaceContext = namespaceContext;
    }

    public void endDocument(Augmentations augs) throws XNIException {
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth > -1) {
            this.schemaDOM.comment(text);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth > -1) {
            this.schemaDOM.processingInstruction(target, data.toString());
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.fInnerAnnotationDepth == -1) {
            for (int i = text.offset; i < text.offset + text.length; ++i) {
                if (XMLChar.isSpace(text.ch[i])) continue;
                String txt = new String(text.ch, i, text.length + text.offset - i);
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-elt-character", new Object[]{txt}, (short)1);
                break;
            }
        } else {
            this.schemaDOM.characters(text);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        ++this.fDepth;
        if (this.fAnnotationDepth == -1) {
            if (element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && element.localpart == SchemaSymbols.ELT_ANNOTATION) {
                this.fAnnotationDepth = this.fDepth;
                this.schemaDOM.startAnnotation(element, attributes, this.fNamespaceContext);
            }
        } else if (this.fDepth == this.fAnnotationDepth + 1) {
            this.fInnerAnnotationDepth = this.fDepth;
            this.schemaDOM.startAnnotationElement(element, attributes);
        } else {
            this.schemaDOM.startAnnotationElement(element, attributes);
            return;
        }
        this.schemaDOM.startElement(element, attributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth == -1) {
            if (element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && element.localpart == SchemaSymbols.ELT_ANNOTATION) {
                this.schemaDOM.startAnnotation(element, attributes, this.fNamespaceContext);
            }
        } else {
            this.schemaDOM.startAnnotationElement(element, attributes);
        }
        this.schemaDOM.emptyElement(element, attributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
        if (this.fAnnotationDepth == -1) {
            if (element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && element.localpart == SchemaSymbols.ELT_ANNOTATION) {
                this.schemaDOM.endAnnotationElement(element, true);
            }
        } else {
            this.schemaDOM.endAnnotationElement(element, false);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth > -1) {
            if (this.fInnerAnnotationDepth == this.fDepth) {
                this.fInnerAnnotationDepth = -1;
                this.schemaDOM.endAnnotationElement(element, false);
                this.schemaDOM.endElement();
            } else if (this.fAnnotationDepth == this.fDepth) {
                this.fAnnotationDepth = -1;
                this.schemaDOM.endAnnotationElement(element, true);
                this.schemaDOM.endElement();
            } else {
                this.schemaDOM.endAnnotationElement(element, false);
            }
        } else {
            this.schemaDOM.endElement();
        }
        --this.fDepth;
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth != -1) {
            this.schemaDOM.characters(text);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.schemaDOM.startAnnotationCDATA();
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.schemaDOM.endAnnotationCDATA();
    }

    public Document getDocument() {
        return this.schemaDOM;
    }
}

