/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.html.internal.dom;

import com.sun.org.apache.html.internal.dom.HTMLBodyElementImpl;
import com.sun.org.apache.html.internal.dom.HTMLCollectionImpl;
import com.sun.org.apache.html.internal.dom.HTMLElementImpl;
import com.sun.org.apache.html.internal.dom.HTMLHeadElementImpl;
import com.sun.org.apache.html.internal.dom.HTMLHtmlElementImpl;
import com.sun.org.apache.html.internal.dom.HTMLTitleElementImpl;
import com.sun.org.apache.html.internal.dom.NameNodeListImpl;
import com.sun.org.apache.html.internal.dom.ObjectFactory;
import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import com.sun.org.apache.xerces.internal.dom.NodeImpl;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFrameSetElement;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLHtmlElement;
import org.w3c.dom.html.HTMLTitleElement;

public class HTMLDocumentImpl
extends DocumentImpl
implements HTMLDocument {
    private HTMLCollectionImpl _anchors;
    private HTMLCollectionImpl _forms;
    private HTMLCollectionImpl _images;
    private HTMLCollectionImpl _links;
    private HTMLCollectionImpl _applets;
    private StringWriter _writer;
    private static Hashtable _elementTypesHTML;
    private static final Class[] _elemClassSigHTML;
    static /* synthetic */ Class class$com$sun$org$apache$html$internal$dom$HTMLDocumentImpl;
    static /* synthetic */ Class class$java$lang$String;

    public HTMLDocumentImpl() {
        HTMLDocumentImpl.populateElementTypes();
    }

    public synchronized Element getDocumentElement() {
        Node html;
        for (html = this.getFirstChild(); html != null; html = html.getNextSibling()) {
            if (!(html instanceof HTMLHtmlElement)) continue;
            return (HTMLElement)html;
        }
        html = new HTMLHtmlElementImpl(this, "HTML");
        Node child = this.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            html.appendChild(child);
            child = next;
        }
        this.appendChild(html);
        return (HTMLElement)html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HTMLElement getHead() {
        Node head;
        Element html;
        Element element = html = this.getDocumentElement();
        synchronized (element) {
            for (head = html.getFirstChild(); head != null && !(head instanceof HTMLHeadElement); head = head.getNextSibling()) {
            }
            if (head != null) {
                Node node = head;
                synchronized (node) {
                    Node child = html.getFirstChild();
                    while (child != null && child != head) {
                        Node next = child.getNextSibling();
                        head.insertBefore(child, head.getFirstChild());
                        child = next;
                    }
                }
                return (HTMLElement)head;
            }
            head = new HTMLHeadElementImpl(this, "HEAD");
            html.insertBefore(head, html.getFirstChild());
        }
        return (HTMLElement)head;
    }

    public synchronized String getTitle() {
        HTMLElement head = this.getHead();
        Node title = head.getElementsByTagName("TITLE").item(0);
        NodeList list = head.getElementsByTagName("TITLE");
        if (list.getLength() > 0) {
            title = list.item(0);
            return ((HTMLTitleElement)title).getText();
        }
        return "";
    }

    public synchronized void setTitle(String newTitle) {
        HTMLElement head = this.getHead();
        NodeList list = head.getElementsByTagName("TITLE");
        if (list.getLength() > 0) {
            Node title = list.item(0);
            if (title.getParentNode() != head) {
                head.appendChild(title);
            }
            ((HTMLTitleElement)title).setText(newTitle);
        } else {
            HTMLTitleElementImpl title = new HTMLTitleElementImpl(this, "TITLE");
            ((HTMLTitleElement)title).setText(newTitle);
            head.appendChild(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HTMLElement getBody() {
        Node body;
        Element html = this.getDocumentElement();
        HTMLElement head = this.getHead();
        Element element = html;
        synchronized (element) {
            for (body = head.getNextSibling(); body != null && !(body instanceof HTMLBodyElement) && !(body instanceof HTMLFrameSetElement); body = body.getNextSibling()) {
            }
            if (body != null) {
                Node node = body;
                synchronized (node) {
                    Node child = head.getNextSibling();
                    while (child != null && child != body) {
                        Node next = child.getNextSibling();
                        body.insertBefore(child, body.getFirstChild());
                        child = next;
                    }
                }
                return (HTMLElement)body;
            }
            body = new HTMLBodyElementImpl(this, "BODY");
            html.appendChild(body);
        }
        return (HTMLElement)body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBody(HTMLElement newBody) {
        HTMLElement hTMLElement = newBody;
        synchronized (hTMLElement) {
            Element html = this.getDocumentElement();
            HTMLElement head = this.getHead();
            Element element = html;
            synchronized (element) {
                NodeList list = this.getElementsByTagName("BODY");
                if (list.getLength() > 0) {
                    Node body;
                    Node node = body = list.item(0);
                    synchronized (node) {
                        for (Node child = head; child != null; child = child.getNextSibling()) {
                            if (!(child instanceof Element)) continue;
                            if (child != body) {
                                html.insertBefore(newBody, child);
                            } else {
                                html.replaceChild(newBody, body);
                            }
                            return;
                        }
                        html.appendChild(newBody);
                    }
                    return;
                }
                html.appendChild(newBody);
            }
        }
    }

    public synchronized Element getElementById(String elementId) {
        return this.getElementById(elementId, this);
    }

    public NodeList getElementsByName(String elementName) {
        return new NameNodeListImpl(this, elementName);
    }

    public final NodeList getElementsByTagName(String tagName) {
        return super.getElementsByTagName(tagName.toUpperCase(Locale.ENGLISH));
    }

    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.length() > 0) {
            return super.getElementsByTagNameNS(namespaceURI, localName.toUpperCase(Locale.ENGLISH));
        }
        return super.getElementsByTagName(localName.toUpperCase(Locale.ENGLISH));
    }

    public Element createElementNS(String namespaceURI, String qualifiedName, String localpart) throws DOMException {
        return this.createElementNS(namespaceURI, qualifiedName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return this.createElement(qualifiedName);
        }
        return super.createElementNS(namespaceURI, qualifiedName);
    }

    public Element createElement(String tagName) throws DOMException {
        Class elemClass = (Class)_elementTypesHTML.get(tagName = tagName.toUpperCase(Locale.ENGLISH));
        if (elemClass != null) {
            try {
                Constructor cnst = elemClass.getConstructor(_elemClassSigHTML);
                return (Element)cnst.newInstance(this, tagName);
            }
            catch (Exception except) {
                if (except instanceof InvocationTargetException) {
                    Throwable thrw = ((InvocationTargetException)except).getTargetException();
                } else {
                    Exception thrw = except;
                }
                throw new IllegalStateException("HTM15 Tag '" + tagName + "' associated with an Element class that failed to construct.\n" + tagName);
            }
        }
        return new HTMLElementImpl(this, tagName);
    }

    public Attr createAttribute(String name) throws DOMException {
        return super.createAttribute(name.toLowerCase(Locale.ENGLISH));
    }

    public String getReferrer() {
        return null;
    }

    public String getDomain() {
        return null;
    }

    public String getURL() {
        return null;
    }

    public String getCookie() {
        return null;
    }

    public void setCookie(String cookie) {
    }

    public HTMLCollection getImages() {
        if (this._images == null) {
            this._images = new HTMLCollectionImpl(this.getBody(), 3);
        }
        return this._images;
    }

    public HTMLCollection getApplets() {
        if (this._applets == null) {
            this._applets = new HTMLCollectionImpl(this.getBody(), 4);
        }
        return this._applets;
    }

    public HTMLCollection getLinks() {
        if (this._links == null) {
            this._links = new HTMLCollectionImpl(this.getBody(), 5);
        }
        return this._links;
    }

    public HTMLCollection getForms() {
        if (this._forms == null) {
            this._forms = new HTMLCollectionImpl(this.getBody(), 2);
        }
        return this._forms;
    }

    public HTMLCollection getAnchors() {
        if (this._anchors == null) {
            this._anchors = new HTMLCollectionImpl(this.getBody(), 1);
        }
        return this._anchors;
    }

    public void open() {
        if (this._writer == null) {
            this._writer = new StringWriter();
        }
    }

    public void close() {
        if (this._writer != null) {
            this._writer = null;
        }
    }

    public void write(String text) {
        if (this._writer != null) {
            this._writer.write(text);
        }
    }

    public void writeln(String text) {
        if (this._writer != null) {
            this._writer.write(text + "\n");
        }
    }

    public Node cloneNode(boolean deep) {
        HTMLDocumentImpl clone = new HTMLDocumentImpl();
        if (deep) {
            for (NodeImpl node = (NodeImpl)this.getFirstChild(); node != null; node = (NodeImpl)node.getNextSibling()) {
                clone.appendChild(clone.importNode(node, true));
            }
        }
        return clone;
    }

    private Element getElementById(String elementId, Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            if (elementId.equals(((Element)child).getAttribute("id"))) {
                return (Element)child;
            }
            Element result = this.getElementById(elementId, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static synchronized void populateElementTypes() {
        if (_elementTypesHTML != null) {
            return;
        }
        _elementTypesHTML = new Hashtable(63);
        HTMLDocumentImpl.populateElementType("A", "HTMLAnchorElementImpl");
        HTMLDocumentImpl.populateElementType("APPLET", "HTMLAppletElementImpl");
        HTMLDocumentImpl.populateElementType("AREA", "HTMLAreaElementImpl");
        HTMLDocumentImpl.populateElementType("BASE", "HTMLBaseElementImpl");
        HTMLDocumentImpl.populateElementType("BASEFONT", "HTMLBaseFontElementImpl");
        HTMLDocumentImpl.populateElementType("BLOCKQUOTE", "HTMLQuoteElementImpl");
        HTMLDocumentImpl.populateElementType("BODY", "HTMLBodyElementImpl");
        HTMLDocumentImpl.populateElementType("BR", "HTMLBRElementImpl");
        HTMLDocumentImpl.populateElementType("BUTTON", "HTMLButtonElementImpl");
        HTMLDocumentImpl.populateElementType("DEL", "HTMLModElementImpl");
        HTMLDocumentImpl.populateElementType("DIR", "HTMLDirectoryElementImpl");
        HTMLDocumentImpl.populateElementType("DIV", "HTMLDivElementImpl");
        HTMLDocumentImpl.populateElementType("DL", "HTMLDListElementImpl");
        HTMLDocumentImpl.populateElementType("FIELDSET", "HTMLFieldSetElementImpl");
        HTMLDocumentImpl.populateElementType("FONT", "HTMLFontElementImpl");
        HTMLDocumentImpl.populateElementType("FORM", "HTMLFormElementImpl");
        HTMLDocumentImpl.populateElementType("FRAME", "HTMLFrameElementImpl");
        HTMLDocumentImpl.populateElementType("FRAMESET", "HTMLFrameSetElementImpl");
        HTMLDocumentImpl.populateElementType("HEAD", "HTMLHeadElementImpl");
        HTMLDocumentImpl.populateElementType("H1", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H2", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H3", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H4", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H5", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H6", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("HR", "HTMLHRElementImpl");
        HTMLDocumentImpl.populateElementType("HTML", "HTMLHtmlElementImpl");
        HTMLDocumentImpl.populateElementType("IFRAME", "HTMLIFrameElementImpl");
        HTMLDocumentImpl.populateElementType("IMG", "HTMLImageElementImpl");
        HTMLDocumentImpl.populateElementType("INPUT", "HTMLInputElementImpl");
        HTMLDocumentImpl.populateElementType("INS", "HTMLModElementImpl");
        HTMLDocumentImpl.populateElementType("ISINDEX", "HTMLIsIndexElementImpl");
        HTMLDocumentImpl.populateElementType("LABEL", "HTMLLabelElementImpl");
        HTMLDocumentImpl.populateElementType("LEGEND", "HTMLLegendElementImpl");
        HTMLDocumentImpl.populateElementType("LI", "HTMLLIElementImpl");
        HTMLDocumentImpl.populateElementType("LINK", "HTMLLinkElementImpl");
        HTMLDocumentImpl.populateElementType("MAP", "HTMLMapElementImpl");
        HTMLDocumentImpl.populateElementType("MENU", "HTMLMenuElementImpl");
        HTMLDocumentImpl.populateElementType("META", "HTMLMetaElementImpl");
        HTMLDocumentImpl.populateElementType("OBJECT", "HTMLObjectElementImpl");
        HTMLDocumentImpl.populateElementType("OL", "HTMLOListElementImpl");
        HTMLDocumentImpl.populateElementType("OPTGROUP", "HTMLOptGroupElementImpl");
        HTMLDocumentImpl.populateElementType("OPTION", "HTMLOptionElementImpl");
        HTMLDocumentImpl.populateElementType("P", "HTMLParagraphElementImpl");
        HTMLDocumentImpl.populateElementType("PARAM", "HTMLParamElementImpl");
        HTMLDocumentImpl.populateElementType("PRE", "HTMLPreElementImpl");
        HTMLDocumentImpl.populateElementType("Q", "HTMLQuoteElementImpl");
        HTMLDocumentImpl.populateElementType("SCRIPT", "HTMLScriptElementImpl");
        HTMLDocumentImpl.populateElementType("SELECT", "HTMLSelectElementImpl");
        HTMLDocumentImpl.populateElementType("STYLE", "HTMLStyleElementImpl");
        HTMLDocumentImpl.populateElementType("TABLE", "HTMLTableElementImpl");
        HTMLDocumentImpl.populateElementType("CAPTION", "HTMLTableCaptionElementImpl");
        HTMLDocumentImpl.populateElementType("TD", "HTMLTableCellElementImpl");
        HTMLDocumentImpl.populateElementType("TH", "HTMLTableCellElementImpl");
        HTMLDocumentImpl.populateElementType("COL", "HTMLTableColElementImpl");
        HTMLDocumentImpl.populateElementType("COLGROUP", "HTMLTableColElementImpl");
        HTMLDocumentImpl.populateElementType("TR", "HTMLTableRowElementImpl");
        HTMLDocumentImpl.populateElementType("TBODY", "HTMLTableSectionElementImpl");
        HTMLDocumentImpl.populateElementType("THEAD", "HTMLTableSectionElementImpl");
        HTMLDocumentImpl.populateElementType("TFOOT", "HTMLTableSectionElementImpl");
        HTMLDocumentImpl.populateElementType("TEXTAREA", "HTMLTextAreaElementImpl");
        HTMLDocumentImpl.populateElementType("TITLE", "HTMLTitleElementImpl");
        HTMLDocumentImpl.populateElementType("UL", "HTMLUListElementImpl");
    }

    private static void populateElementType(String tagName, String className) {
        try {
            _elementTypesHTML.put(tagName, ObjectFactory.findProviderClass("com.sun.org.apache.html.internal.dom." + className, (class$com$sun$org$apache$html$internal$dom$HTMLDocumentImpl == null ? (class$com$sun$org$apache$html$internal$dom$HTMLDocumentImpl = HTMLDocumentImpl.class$("com.sun.org.apache.html.internal.dom.HTMLDocumentImpl")) : class$com$sun$org$apache$html$internal$dom$HTMLDocumentImpl).getClassLoader(), true));
        }
        catch (Exception except) {
            new RuntimeException("HTM019 OpenXML Error: Could not find or execute class " + className + " implementing HTML element " + tagName + "\n" + className + "\t" + tagName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _elemClassSigHTML = new Class[]{class$com$sun$org$apache$html$internal$dom$HTMLDocumentImpl == null ? (class$com$sun$org$apache$html$internal$dom$HTMLDocumentImpl = HTMLDocumentImpl.class$("com.sun.org.apache.html.internal.dom.HTMLDocumentImpl")) : class$com$sun$org$apache$html$internal$dom$HTMLDocumentImpl, class$java$lang$String == null ? (class$java$lang$String = HTMLDocumentImpl.class$("java.lang.String")) : class$java$lang$String};
    }
}

