/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdeploy;

import com.sun.xml.rpc.processor.config.HandlerChainInfo;
import com.sun.xml.rpc.processor.config.HandlerInfo;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.streaming.XMLReaderFactory;
import com.sun.xml.rpc.tools.wsdeploy.Constants;
import com.sun.xml.rpc.tools.wsdeploy.DeploymentException;
import com.sun.xml.rpc.tools.wsdeploy.EndpointClientInfo;
import com.sun.xml.rpc.tools.wsdeploy.EndpointInfo;
import com.sun.xml.rpc.tools.wsdeploy.EndpointMappingInfo;
import com.sun.xml.rpc.tools.wsdeploy.WebServicesInfo;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class DeploymentDescriptorParser {
    public WebServicesInfo parse(InputStream is) {
        try {
            XMLReader reader = XMLReaderFactory.newInstance().createXMLReader(is);
            reader.next();
            return this.parseWebServices(reader);
        }
        catch (XMLReaderException e) {
            throw new DeploymentException("deployment.parser.xmlReader", e);
        }
    }

    protected WebServicesInfo parseWebServices(XMLReader reader) {
        if (!reader.getName().equals(Constants.QNAME_WEB_SERVICES)) {
            DeploymentDescriptorParser.failWithFullName("deployment.parser.invalidElement", reader);
        }
        WebServicesInfo wsInfo = new WebServicesInfo();
        String version = this.getMandatoryNonEmptyAttribute(reader, "version");
        if (!version.equals("1.0")) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidVersionNumber", reader, version);
        }
        wsInfo.setTargetNamespaceBase(this.getNonEmptyAttribute(reader, "targetNamespaceBase"));
        wsInfo.setTypeNamespaceBase(this.getNonEmptyAttribute(reader, "typeNamespaceBase"));
        wsInfo.setUrlPatternBase(this.getNonEmptyAttribute(reader, "urlPatternBase"));
        boolean gotEndpointMapping = false;
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_ENDPOINT)) {
                if (gotEndpointMapping) {
                    DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidElement", reader);
                    continue;
                }
                wsInfo.add(this.parseEndpoint(reader));
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_ENDPOINT_MAPPING)) {
                wsInfo.add(this.parseEndpointMapping(reader));
                gotEndpointMapping = true;
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_ENDPOINT_CLIENT_MAPPING)) continue;
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidElement", reader);
        }
        reader.close();
        Map endpoints = wsInfo.getEndpoints();
        Map endpointMappings = wsInfo.getEndpointMappings();
        Map endpointClients = wsInfo.getEndpointClients();
        boolean gotModels = true;
        boolean gotMappings = true;
        Iterator iter = endpoints.values().iterator();
        while (iter.hasNext()) {
            EndpointInfo endpoint = (EndpointInfo)iter.next();
            if (endpoint.getModel() == null) {
                gotModels = false;
            }
            if (endpointMappings.get(endpoint.getName()) != null) continue;
            gotMappings = false;
        }
        if (!gotModels) {
            if (wsInfo.getTargetNamespaceBase() == null) {
                throw new DeploymentException("deployment.parser.missing.attribute.no.line", new Object[]{Constants.QNAME_WEB_SERVICES.getLocalPart(), "targetNamespaceBase"});
            }
            if (wsInfo.getTypeNamespaceBase() == null) {
                throw new DeploymentException("deployment.parser.missing.attribute.no.line", new Object[]{Constants.QNAME_WEB_SERVICES.getLocalPart(), "typeNamespaceBase"});
            }
        }
        if (!gotMappings && wsInfo.getUrlPatternBase() == null) {
            throw new DeploymentException("deployment.parser.missing.attribute.no.line", new Object[]{Constants.QNAME_WEB_SERVICES.getLocalPart(), "urlPatternBase"});
        }
        iter = endpointClients.values().iterator();
        while (iter.hasNext()) {
            EndpointClientInfo endpointClient = (EndpointClientInfo)iter.next();
            if (endpointClient.getModel() == null) {
                throw new DeploymentException("deployment.parser.missing.attribute.no.line", new Object[]{Constants.QNAME_ENDPOINT_CLIENT_MAPPING.getLocalPart(), Constants.QNAME_ENDPOINT_CLIENT_MAPPING});
            }
            if (endpointClient.getService() != null) continue;
            throw new DeploymentException("deployment.parser.missing.attribute.no.line", new Object[]{"service"});
        }
        return wsInfo;
    }

    protected EndpointClientInfo parseEndpointClient(XMLReader reader) {
        EndpointClientInfo client = new EndpointClientInfo();
        client.setName(this.getMandatoryNonEmptyAttribute(reader, "name"));
        client.setDisplayName(this.getAttribute(reader, "displayName"));
        client.setDescription(this.getAttribute(reader, "description"));
        client.setModel(this.getAttribute(reader, "model"));
        client.setService(this.getAttribute(reader, "service"));
        return client;
    }

    protected EndpointInfo parseEndpoint(XMLReader reader) {
        EndpointInfo endpoint = new EndpointInfo();
        endpoint.setName(this.getMandatoryNonEmptyAttribute(reader, "name"));
        endpoint.setDisplayName(this.getAttribute(reader, "displayName"));
        endpoint.setDescription(this.getAttribute(reader, "description"));
        endpoint.setInterface(this.getAttribute(reader, "interface"));
        endpoint.setImplementation(this.getAttribute(reader, "implementation"));
        endpoint.setModel(this.getAttribute(reader, "model"));
        if (this.getAttribute(reader, "port") != null) {
            String portValue = this.getAttribute(reader, "port");
            StringTokenizer str = new StringTokenizer(portValue, "}");
            QName portQName = new QName(new StringTokenizer(str.nextToken(), "{").nextToken(), str.nextToken());
            endpoint.setRuntimePortName(portQName);
        }
        if (this.getAttribute(reader, "wsdl") != null) {
            String wsdlValue = this.getAttribute(reader, "wsdl");
            endpoint.setRuntimeWSDL(wsdlValue);
        }
        if (reader.nextElementContent() == 1) {
            if (reader.getName().equals(Constants.QNAME_HANDLER_CHAINS)) {
                while (reader.nextElementContent() != 2) {
                    if (reader.getName().equals(Constants.QNAME_CHAIN)) {
                        String runatAttr = this.getMandatoryNonEmptyAttribute(reader, "runAt");
                        HandlerChainInfo handlerChainInfo = new HandlerChainInfo();
                        String rolesAttr = this.getAttribute(reader, "roles");
                        if (rolesAttr != null) {
                            List rolesList = XmlUtil.parseTokenList(rolesAttr);
                            Iterator iter = rolesList.iterator();
                            while (iter.hasNext()) {
                                handlerChainInfo.addRole((String)iter.next());
                            }
                        }
                        while (reader.nextElementContent() != 2) {
                            if (reader.getName().equals(Constants.QNAME_HANDLER)) {
                                HandlerInfo handlerInfo = new HandlerInfo();
                                String className = this.getMandatoryNonEmptyAttribute(reader, "className");
                                handlerInfo.setHandlerClassName(className);
                                String headers = this.getAttribute(reader, "headers");
                                if (headers != null) {
                                    List headersList = XmlUtil.parseTokenList(headers);
                                    Iterator iter = headersList.iterator();
                                    while (iter.hasNext()) {
                                        String uri;
                                        String name = (String)iter.next();
                                        String prefix = XmlUtil.getPrefix(name);
                                        String localPart = XmlUtil.getLocalPart(name);
                                        if (prefix == null) {
                                            prefix = "";
                                        }
                                        if ((uri = reader.getURI(prefix)) == null) {
                                            DeploymentDescriptorParser.failWithLocalName("configuration.invalidAttributeValue", reader, "headers");
                                        }
                                        handlerInfo.addHeaderName(new QName(uri, localPart));
                                    }
                                }
                                Map properties = handlerInfo.getProperties();
                                while (reader.nextElementContent() != 2) {
                                    if (reader.getName().equals(Constants.QNAME_PROPERTY)) {
                                        String name = this.getMandatoryNonEmptyAttribute(reader, "name");
                                        String value = this.getMandatoryAttribute(reader, "value");
                                        properties.put(name, value);
                                        DeploymentDescriptorParser.ensureNoContent(reader);
                                        continue;
                                    }
                                    DeploymentDescriptorParser.failWithLocalName("configuration.invalidElement", reader);
                                }
                                handlerChainInfo.add(handlerInfo);
                                continue;
                            }
                            DeploymentDescriptorParser.failWithLocalName("configuration.invalidElement", reader);
                        }
                        if (runatAttr.equals("client")) {
                            endpoint.setClientHandlerChainInfo(handlerChainInfo);
                            continue;
                        }
                        if (runatAttr.equals("server")) {
                            endpoint.setServerHandlerChainInfo(handlerChainInfo);
                            continue;
                        }
                        DeploymentDescriptorParser.failWithLocalName("configuration.invalidAttributeValue", reader, "runAt");
                        continue;
                    }
                    DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidElement", reader);
                }
                DeploymentDescriptorParser.ensureNoContent(reader);
            } else {
                DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidElement", reader);
            }
        }
        return endpoint;
    }

    protected EndpointMappingInfo parseEndpointMapping(XMLReader reader) {
        EndpointMappingInfo endpointMapping = new EndpointMappingInfo();
        endpointMapping.setName(this.getMandatoryNonEmptyAttribute(reader, "endpointName"));
        endpointMapping.setUrlPattern(this.getMandatoryNonEmptyAttribute(reader, "urlPattern"));
        DeploymentDescriptorParser.ensureNoContent(reader);
        return endpointMapping;
    }

    protected String getAttribute(XMLReader reader, String name) {
        Attributes attributes = reader.getAttributes();
        String value = attributes.getValue(name);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected String getNonEmptyAttribute(XMLReader reader, String name) {
        String value = this.getAttribute(reader, name);
        if (value != null && value.equals("")) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidAttributeValue", reader, name);
        }
        return value;
    }

    protected String getMandatoryAttribute(XMLReader reader, String name) {
        String value = this.getAttribute(reader, name);
        if (value == null) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.missing.attribute", reader, name);
        }
        return value;
    }

    protected String getMandatoryNonEmptyAttribute(XMLReader reader, String name) {
        String value = this.getAttribute(reader, name);
        if (value == null) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.missing.attribute", reader, name);
        } else if (value.equals("")) {
            DeploymentDescriptorParser.failWithLocalName("deployment.parser.invalidAttributeValue", reader, name);
        }
        return value;
    }

    protected static void ensureNoContent(XMLReader reader) {
        if (reader.nextElementContent() != 2) {
            DeploymentDescriptorParser.fail("deployment.parser.unexpectedContent", reader);
        }
    }

    protected static void fail(String key, XMLReader reader) {
        throw new DeploymentException(key, Integer.toString(reader.getLineNumber()));
    }

    protected static void failWithFullName(String key, XMLReader reader) {
        throw new DeploymentException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getName().toString()});
    }

    protected static void failWithLocalName(String key, XMLReader reader) {
        throw new DeploymentException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getLocalName()});
    }

    protected static void failWithLocalName(String key, XMLReader reader, String arg) {
        throw new DeploymentException(key, new Object[]{Integer.toString(reader.getLineNumber()), reader.getLocalName(), arg});
    }
}

