/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.schema.AnnotationComponent;
import com.sun.xml.rpc.processor.schema.AttributeDeclarationComponent;
import com.sun.xml.rpc.processor.schema.AttributeGroupDefinitionComponent;
import com.sun.xml.rpc.processor.schema.AttributeUseComponent;
import com.sun.xml.rpc.processor.schema.ComplexTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.ComponentVisitor;
import com.sun.xml.rpc.processor.schema.ElementDeclarationComponent;
import com.sun.xml.rpc.processor.schema.IdentityConstraintDefinitionComponent;
import com.sun.xml.rpc.processor.schema.ModelGroupComponent;
import com.sun.xml.rpc.processor.schema.ModelGroupDefinitionComponent;
import com.sun.xml.rpc.processor.schema.NotationDeclarationComponent;
import com.sun.xml.rpc.processor.schema.ParticleComponent;
import com.sun.xml.rpc.processor.schema.SimpleTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.WildcardComponent;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class ComponentWriter
implements ComponentVisitor {
    private IndentingWriter _writer;

    public ComponentWriter(IndentingWriter w) {
        this._writer = w;
    }

    public void visit(AnnotationComponent component) throws Exception {
    }

    public void visit(AttributeDeclarationComponent component) throws Exception {
        this._writer.p("ATTRIBUTE ");
        this.writeName(component.getName());
        this._writer.pln();
        this._writer.pI();
        if (component.getScope() == null) {
            this._writer.pln("SCOPE global");
        }
        if (component.getTypeDefinition() != null) {
            this._writer.pln("TYPE");
            this._writer.pI();
            component.getTypeDefinition().accept(this);
            this._writer.pO();
        }
        this._writer.pO();
    }

    public void visit(AttributeGroupDefinitionComponent component) throws Exception {
    }

    public void visit(AttributeUseComponent component) throws Exception {
        this._writer.p("ATTRIBUTE USE ");
        this._writer.pln(component.isRequired() ? "required" : "optional");
        this._writer.pI();
        component.getAttributeDeclaration().accept(this);
        this._writer.pO();
    }

    public void visit(ComplexTypeDefinitionComponent component) throws Exception {
        this._writer.p("COMPLEX-TYPE ");
        this.writeName(component.getName());
        this._writer.pln();
        if (component.getName() != null && component.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
            return;
        }
        this._writer.pI();
        if (component.getBaseTypeDefinition() != null) {
            this._writer.pln("BASE-TYPE");
            this._writer.pI();
            component.getBaseTypeDefinition().accept(this);
            this._writer.pO();
        }
        Iterator iter = component.attributeUses();
        while (iter.hasNext()) {
            ((AttributeUseComponent)iter.next()).accept(this);
        }
        switch (component.getContentTag()) {
            case 1: {
                this._writer.pln("EMPTY");
                break;
            }
            case 2: {
                this._writer.pln("SIMPLE");
                component.getSimpleTypeContent().accept(this);
                break;
            }
            case 3: {
                this._writer.pln("MIXED");
                component.getParticleContent().accept(this);
                break;
            }
            case 4: {
                this._writer.pln("ELEMENT-ONLY");
                component.getParticleContent().accept(this);
                break;
            }
        }
        this._writer.pO();
    }

    public void visit(ElementDeclarationComponent component) throws Exception {
        this._writer.p("ELEMENT ");
        this.writeName(component.getName());
        this._writer.pln();
        this._writer.pI();
        if (component.getScope() == null) {
            this._writer.pln("SCOPE global");
        }
        if (component.getTypeDefinition() != null) {
            component.getTypeDefinition().accept(this);
        }
        this._writer.pO();
    }

    public void visit(IdentityConstraintDefinitionComponent component) throws Exception {
    }

    public void visit(ModelGroupComponent component) throws Exception {
        this._writer.p("GROUP ");
        this._writer.p(component.getCompositor().getName());
        this._writer.pln();
        this._writer.pI();
        Iterator iter = component.particles();
        while (iter.hasNext()) {
            ParticleComponent particle = (ParticleComponent)iter.next();
            particle.accept(this);
        }
        this._writer.pO();
    }

    public void visit(ModelGroupDefinitionComponent component) throws Exception {
    }

    public void visit(NotationDeclarationComponent component) throws Exception {
    }

    public void visit(ParticleComponent component) throws Exception {
        this._writer.p("PARTICLE (");
        this._writer.p(Integer.toString(component.getMinOccurs()));
        this._writer.p(", ");
        if (component.isMaxOccursUnbounded()) {
            this._writer.p("UNBOUNDED)");
        } else {
            this._writer.p(Integer.toString(component.getMaxOccurs()));
            this._writer.p(")");
        }
        this._writer.pln();
        this._writer.pI();
        if (component.getModelGroupTerm() != null) {
            component.getModelGroupTerm().accept(this);
        } else if (component.getElementTerm() != null) {
            component.getElementTerm().accept(this);
        }
        this._writer.pO();
    }

    public void visit(SimpleTypeDefinitionComponent component) throws Exception {
        this._writer.p("SIMPLE-TYPE ");
        this.writeName(component.getName());
        this._writer.pln();
        if (component.getName() != null && component.getName().equals(SchemaConstants.QNAME_TYPE_SIMPLE_URTYPE)) {
            return;
        }
        this._writer.pI();
        this._writer.pO();
    }

    public void visit(WildcardComponent component) throws Exception {
    }

    private void writeName(QName name) throws IOException {
        if (name != null) {
            String nsURI = name.getNamespaceURI();
            if (nsURI.equals("http://www.w3.org/2001/XMLSchema")) {
                this._writer.p("xsd:");
            } else if (nsURI.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                this._writer.p("soap-enc:");
            }
            this._writer.p(name.getLocalPart());
        }
    }
}

