/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.j2ee;

import com.sun.xml.rpc.processor.modeler.j2ee.xml.javaWsdlMapping;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.javaWsdlMappingFactory;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.packageMappingType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.InputSource;

public class JaxRpcMappingXml {
    javaWsdlMappingFactory factory = new javaWsdlMappingFactory();
    javaWsdlMapping javaWsdlMap;
    HashMap nsMap;

    public JaxRpcMappingXml(String systemId) throws IOException {
        InputSource src = new InputSource(systemId);
        this.factory.setPackageName("com.sun.xml.rpc.processor.modeler.j2ee.xml");
        this.javaWsdlMap = (javaWsdlMapping)this.factory.loadDocument("javaWsdlMapping", src);
        if (this.javaWsdlMap == null) {
            throw new IOException("Unable to load mapping meta data at: " + systemId);
        }
    }

    public javaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMap;
    }

    public HashMap getNSToPkgMapping() {
        if (this.nsMap == null) {
            this.nsMap = new HashMap();
            int numPkgMap = this.javaWsdlMap.getPackageMappingCount();
            for (int i = 0; i < numPkgMap; ++i) {
                packageMappingType pkgMap = this.javaWsdlMap.getPackageMapping(i);
                this.nsMap.put(pkgMap.getNamespaceURI().getElementValue(), pkgMap.getPackageType().getElementValue());
            }
        }
        return this.nsMap;
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 1) {
                System.out.println("usage: com.ibm.webservices.ri.deploy.JaxRpcMappingXml systemId");
                System.exit(1);
            }
            JaxRpcMappingXml jaxRpcMap = new JaxRpcMappingXml(argv[0]);
            HashMap nsMap = jaxRpcMap.getNSToPkgMapping();
            Set keys = nsMap.keySet();
            System.out.println(nsMap.size() + " namespace to package mapping:");
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String ns = (String)it.next();
                String pkg = (String)nsMap.get(ns);
                System.out.println("'" + ns + "' : '" + pkg + "'");
            }
            javaWsdlMapping javaWsdlMap = jaxRpcMap.getJavaWsdlMapping();
            int numJavaXmlTypeMapping = javaWsdlMap.getJavaXmlTypeMappingCount();
            System.out.println("There are " + numJavaXmlTypeMapping + " java-xml-type-mapping");
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

