/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model;

import com.sun.xml.rpc.processor.config.ImportedDocumentInfo;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.ModelVisitor;
import com.sun.xml.rpc.processor.model.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class Model
extends ModelObject
implements com.sun.xml.rpc.spi.model.Model {
    private QName name;
    private String targetNamespace;
    private List services = new ArrayList();
    private Map servicesByName = new HashMap();
    private Set extraTypes = new HashSet();
    private Map importedDocuments = new HashMap();
    private String source;

    public Model() {
    }

    public Model(QName name) {
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public String getTargetNamespaceURI() {
        return this.targetNamespace;
    }

    public void setTargetNamespaceURI(String s) {
        this.targetNamespace = s;
    }

    public void addService(Service service) {
        if (this.servicesByName.containsKey(service.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this.services.add(service);
        this.servicesByName.put(service.getName(), service);
    }

    public Iterator getServices() {
        return this.services.iterator();
    }

    public Service getServiceByName(QName name) {
        if (this.servicesByName.size() != this.services.size()) {
            this.initializeServicesByName();
        }
        return (Service)this.servicesByName.get(name);
    }

    public List getServicesList() {
        return this.services;
    }

    public void setServicesList(List l) {
        this.services = l;
    }

    private void initializeServicesByName() {
        this.servicesByName = new HashMap();
        if (this.services != null) {
            Iterator iter = this.services.iterator();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                if (service.getName() != null && this.servicesByName.containsKey(service.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this.servicesByName.put(service.getName(), service);
            }
        }
    }

    public void addExtraType(AbstractType type) {
        this.extraTypes.add(type);
    }

    public Iterator getExtraTypes() {
        return this.extraTypes.iterator();
    }

    public Set getExtraTypesSet() {
        return this.extraTypes;
    }

    public void setExtraTypesSet(Set s) {
        this.extraTypes = s;
    }

    public Iterator getImportedDocuments() {
        return this.importedDocuments.values().iterator();
    }

    public ImportedDocumentInfo getImportedDocument(String namespace) {
        return (ImportedDocumentInfo)this.importedDocuments.get(namespace);
    }

    public void addImportedDocument(ImportedDocumentInfo i) {
        this.importedDocuments.put(i.getNamespace(), i);
    }

    public Map getImportedDocumentsMap() {
        return this.importedDocuments;
    }

    public void setImportedDocumentsMap(Map m) {
        this.importedDocuments = m;
    }

    public void accept(ModelVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string2) {
        this.source = string2;
    }
}

