/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.MissingTrailingBlockIDException;
import com.sun.xml.rpc.encoding.PostDeserializationAction;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPNamespaceConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.soap.SOAPMessage;

public class SOAPDeserializationContext {
    protected Stack encodingStyleContext = new Stack();
    protected String curEncodingStyle = null;
    protected boolean isSOAPEncodingStyle = false;
    protected List encodingStyleURIs = null;
    protected SOAPMessage message;
    protected Map stateIds = new HashMap();
    private SOAPVersion soapVer = SOAPVersion.SOAP_11;
    private SOAPNamespaceConstants soapNamespaceConstants = null;
    private Hashtable idTable;
    private ArrayList idResolver;
    private int idResolverLength = 0;

    private void init(SOAPVersion ver) {
        this.soapNamespaceConstants = SOAPConstantsFactory.getSOAPNamespaceConstants(ver);
        this.soapVer = ver;
    }

    public SOAPDeserializationContext() {
        this(SOAPVersion.SOAP_11);
    }

    public SOAPDeserializationContext(SOAPVersion ver) {
        this.init(ver);
        this.pushEncodingStyle("");
    }

    public SOAPDeserializationState getStateFor(String id) {
        if (id == null) {
            return null;
        }
        SOAPDeserializationState elementState = (SOAPDeserializationState)this.stateIds.get(id);
        if (elementState == null) {
            elementState = new SOAPDeserializationState();
            this.stateIds.put(id, elementState);
        }
        return elementState;
    }

    public void deserializeMultiRefObjects(XMLReader reader) {
        try {
            while (reader.nextElementContent() == 1) {
                String id = reader.getAttributes().getValue("", "id");
                if (id == null) {
                    throw new MissingTrailingBlockIDException("soap.missingTrailingBlockID");
                }
                SOAPDeserializationState elementState = this.getStateFor(id);
                elementState.deserialize(null, reader, this);
            }
        }
        catch (MissingTrailingBlockIDException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public void doneDeserializing() {
        Iterator iter = this.stateIds.values().iterator();
        while (iter.hasNext()) {
            SOAPDeserializationState state = (SOAPDeserializationState)iter.next();
            state.promoteToCompleteOrFail();
        }
    }

    public void setMessage(SOAPMessage m) {
        this.message = m;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    public void pushEncodingStyle(String newEncodingStyle) {
        this.encodingStyleContext.push(newEncodingStyle);
        this.initEncodingStyleInfo();
    }

    public void popEncodingStyle() {
        this.encodingStyleContext.pop();
        this.initEncodingStyleInfo();
    }

    public String getEncodingStyle() {
        return this.curEncodingStyle;
    }

    public boolean processEncodingStyle(XMLReader reader) throws Exception {
        Attributes attrs = reader.getAttributes();
        String newEncodingStyle = attrs.getValue(this.soapNamespaceConstants.getEnvelope(), this.soapNamespaceConstants.getAttrEncodingStyle());
        if (newEncodingStyle == null) {
            return false;
        }
        this.pushEncodingStyle(newEncodingStyle);
        return true;
    }

    public void verifyEncodingStyle(String expectedEncodingStyle) {
        if (expectedEncodingStyle == null) {
            return;
        }
        if (expectedEncodingStyle == this.soapNamespaceConstants.getEncoding() || expectedEncodingStyle.equals(this.soapNamespaceConstants.getEncoding())) {
            if (this.isSOAPEncodingStyle) {
                return;
            }
        } else if (this.encodingStyleURIs == null) {
            if (this.curEncodingStyle.startsWith(expectedEncodingStyle)) {
                return;
            }
        } else {
            for (int i = 0; i < this.encodingStyleURIs.size(); ++i) {
                String uri = (String)this.encodingStyleURIs.get(i);
                if (!uri.startsWith(expectedEncodingStyle)) continue;
                return;
            }
        }
        throw new DeserializationException("soap.unexpectedEncodingStyle", new Object[]{expectedEncodingStyle, this.curEncodingStyle});
    }

    private void initEncodingStyleInfo() {
        this.curEncodingStyle = (String)this.encodingStyleContext.peek();
        if (this.curEncodingStyle.indexOf(32) == -1) {
            this.encodingStyleURIs = null;
            this.isSOAPEncodingStyle = this.curEncodingStyle.startsWith(this.soapNamespaceConstants.getEncoding());
        } else {
            this.encodingStyleURIs = XmlUtil.parseTokenList(this.curEncodingStyle);
            this.isSOAPEncodingStyle = false;
            for (int i = 0; i < this.encodingStyleURIs.size(); ++i) {
                String uri = (String)this.encodingStyleURIs.get(i);
                if (!uri.startsWith(this.soapNamespaceConstants.getEncoding())) continue;
                this.isSOAPEncodingStyle = true;
                break;
            }
        }
    }

    public SOAPVersion getSOAPVersion() {
        return this.soapVer;
    }

    public void addXSDIdObjectSerializer(String id, Object obj) {
        if (this.idTable == null) {
            this.idTable = new Hashtable();
        }
        if (this.idTable.containsKey(id)) {
            throw new DeserializationException("xsd.duplicateID", new Object[]{id});
        }
        this.idTable.put(id, obj);
    }

    public Object getXSDIdObjectSerializer(String id) {
        if (this.idTable == null) {
            return null;
        }
        return this.idTable.get(id);
    }

    public void addPostDeserializationAction(PostDeserializationAction action) {
        if (this.idResolver == null) {
            this.idResolver = new ArrayList();
        }
        this.idResolver.add(action);
    }

    public void runPostDeserializationAction() {
        if (this.idResolver != null) {
            Iterator iter = this.idResolver.iterator();
            while (iter.hasNext()) {
                ((PostDeserializationAction)iter.next()).run(this);
            }
        }
    }
}

