/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.client.dii.OperationInfo;
import com.sun.xml.rpc.client.dii.ParameterMemberInfo;
import com.sun.xml.rpc.client.dii.PortInfo;
import com.sun.xml.rpc.client.dii.ServiceInfo;
import com.sun.xml.rpc.client.dii.webservice.WebService;
import com.sun.xml.rpc.client.dii.webservice.WebServicesClient;
import com.sun.xml.rpc.client.dii.webservice.parser.WebServicesClientParser;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.exporter.ModelImporter;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.util.ClientProcessorEnvironment;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;

public class ServiceInfoBuilder {
    protected WSDLModelInfo modelInfo;
    protected QName serviceName;
    private SOAPEncodingConstants soapEncodingConstants = null;
    private Package[] packages;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public ServiceInfoBuilder(String wsdlLocation, QName serviceName) {
        this(wsdlLocation, serviceName, SOAPVersion.SOAP_11);
    }

    public ServiceInfoBuilder(String wsdlLocation, QName serviceName, SOAPVersion ver) {
        this.init(ver);
        ClientProcessorEnvironment env = new ClientProcessorEnvironment(new ByteArrayOutputStream(), null, null);
        Configuration config = new Configuration(env);
        this.modelInfo = new WSDLModelInfo();
        config.setModelInfo(this.modelInfo);
        this.modelInfo.setParent(config);
        this.modelInfo.setLocation(wsdlLocation);
        this.serviceName = serviceName;
        this.modelInfo.setName(serviceName.getLocalPart());
    }

    public void setPackage(String packageName) {
        this.modelInfo.setJavaPackageName(packageName);
    }

    public ServiceInfo buildServiceInfo() throws ServiceException {
        Service serviceModel;
        Model wsdlModel = null;
        wsdlModel = this.getModel(this.modelInfo.getLocation());
        if (wsdlModel == null) {
            wsdlModel = this.getModel(true, false);
        }
        if ((serviceModel = wsdlModel.getServiceByName(this.serviceName)) == null) {
            String knownServiceNames = "";
            Iterator eachService = wsdlModel.getServices();
            while (eachService.hasNext()) {
                Service service = (Service)eachService.next();
                knownServiceNames = knownServiceNames + service.getName().toString();
                if (!eachService.hasNext()) continue;
                knownServiceNames = knownServiceNames + "\n";
            }
            throw new DynamicInvocationException("dii.wsdl.service.unknown", new Object[]{this.serviceName, knownServiceNames});
        }
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setDefaultNamespace(wsdlModel.getTargetNamespaceURI());
        Iterator eachPort = serviceModel.getPorts();
        while (eachPort.hasNext()) {
            Port portModel = (Port)eachPort.next();
            PortInfo portInfo = serviceInfo.getPortInfo((QName)portModel.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName"));
            portInfo.setPortTypeName((QName)portModel.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName"));
            this.buildPortInfo(portInfo, portModel);
        }
        return serviceInfo;
    }

    protected Model getModel() {
        Properties options = new Properties();
        options.put("validationWSDL", new Boolean(false));
        options.put("explicitServiceContext", new Boolean(false));
        options.put("useWSIBasicProfile", "true");
        options.put("unwrapDocLitWrappers", "false");
        return this.modelInfo.buildModel(options);
    }

    protected Model getModel(boolean useWSI, boolean done) throws ServiceException, ModelerException {
        Properties options = new Properties();
        options.put("validationWSDL", new Boolean(false));
        options.put("explicitServiceContext", new Boolean(false));
        if (useWSI) {
            options.put("useWSIBasicProfile", "true");
            options.put("unwrapDocLitWrappers", "false");
        }
        Model model = null;
        try {
            model = this.modelInfo.buildModel(options);
        }
        catch (ModelerException ex) {
            if (!done) {
                model = this.getModel(false, true);
            }
            throw ex;
        }
        return model;
    }

    protected void buildPortInfo(PortInfo portInfo, Port portModel) {
        portInfo.setTargetEndpoint(portModel.getAddress());
        Iterator eachOperation = portModel.getOperations();
        while (eachOperation.hasNext()) {
            Operation operationModel = (Operation)eachOperation.next();
            OperationInfo operationInfo = portInfo.createOperationForName(operationModel.getName().getLocalPart());
            this.buildOperationInfo(operationInfo, operationModel);
        }
    }

    private Package[] getPackages() {
        if (this.packages == null) {
            this.packages = Package.getPackages();
        }
        return this.packages;
    }

    protected void buildOperationInfo(OperationInfo operationInfo, Operation operationModel) {
        if (operationModel.getStyle() == SOAPStyle.DOCUMENT && operationModel.getUse() == SOAPUse.LITERAL) {
            this.buildDocumentOperation(operationInfo, operationModel);
        } else if (operationModel.getStyle() == SOAPStyle.RPC && operationModel.getUse() == SOAPUse.LITERAL) {
            this.buildRpcLiteralOperation(operationInfo, operationModel);
        } else if (operationModel.getStyle() == SOAPStyle.RPC && operationModel.getUse() == SOAPUse.ENCODED) {
            this.buildRpcOperation(operationInfo, operationModel);
        }
    }

    protected void buildRpcOperation(OperationInfo operationInfo, Operation operationModel) {
        SOAPStructureMember currentWsdlParameter;
        Parameter currentParameter;
        JavaType returnJavaTypeModel;
        JavaMethod methodModel = operationModel.getJavaMethod();
        Request requestModel = operationModel.getRequest();
        Response responseModel = operationModel.getResponse();
        Block requestWsdlModel = (Block)requestModel.getBodyBlocks().next();
        Block responseWsdlModel = null;
        if (responseModel != null) {
            responseWsdlModel = (Block)responseModel.getBodyBlocks().next();
        } else {
            operationInfo.setIsOneWay(true);
        }
        RPCRequestUnorderedStructureType requestType = (RPCRequestUnorderedStructureType)requestWsdlModel.getType();
        RPCResponseStructureType responseType = null;
        if (responseWsdlModel != null) {
            responseType = (RPCResponseStructureType)responseWsdlModel.getType();
        }
        Iterator eachRequestParameter = requestModel.getParameters();
        Iterator eachResponseParameter = null;
        if (responseModel != null) {
            eachResponseParameter = responseModel.getParameters();
        }
        Iterator eachRequestWsdlParameter = requestType.getMembers();
        Iterator eachResponseWsdlParameter = null;
        if (responseType != null) {
            eachResponseWsdlParameter = responseType.getMembers();
        }
        if ((returnJavaTypeModel = methodModel.getReturnType()) != null && !"void".equals(returnJavaTypeModel.getName())) {
            Parameter returnParameter = (Parameter)eachResponseParameter.next();
            SOAPStructureMember returnWsdlParameter = (SOAPStructureMember)eachResponseWsdlParameter.next();
            QName returnXmlType = returnParameter.getType().getName();
            Class returnJavaType = this.getJavaClassFor(returnParameter.getType());
            operationInfo.setReturnType(returnXmlType, returnJavaType);
        }
        while (eachRequestParameter.hasNext()) {
            currentParameter = (Parameter)eachRequestParameter.next();
            currentWsdlParameter = (SOAPStructureMember)eachRequestWsdlParameter.next();
            ParameterMode mode = ParameterMode.IN;
            if (currentParameter.getLinkedParameter() != null) {
                mode = ParameterMode.INOUT;
            }
            this.addParameterTo(operationInfo, currentWsdlParameter, mode);
        }
        if (eachResponseParameter != null) {
            while (eachResponseParameter.hasNext()) {
                currentParameter = (Parameter)eachResponseParameter.next();
                currentWsdlParameter = (SOAPStructureMember)eachResponseWsdlParameter.next();
                if (currentParameter.getLinkedParameter() != null) continue;
                this.addParameterTo(operationInfo, currentWsdlParameter, ParameterMode.OUT);
            }
        }
        operationInfo.setProperty("javax.xml.rpc.soap.operation.style", "rpc");
        operationInfo.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", this.soapEncodingConstants.getURIEncoding());
    }

    protected void buildDocumentOperation(OperationInfo operationInfo, Operation operationModel) {
        LiteralType currentParameterLitType;
        Parameter currentParameter;
        ParameterMemberInfo info;
        QName xmlTypeName;
        Class javaClass;
        JavaType javaType;
        LiteralType memberType;
        String memName;
        LiteralElementMember member;
        Iterator members;
        ArrayList<ParameterMemberInfo> memberInfos;
        JavaType returnJavaTypeModel;
        JavaMethod methodModel = operationModel.getJavaMethod();
        Request requestModel = operationModel.getRequest();
        Response responseModel = operationModel.getResponse();
        Block requestWsdlModel = null;
        Block responseWsdlModel = null;
        Iterator eachRequestParameter = null;
        Iterator eachResponseParameter = null;
        if (requestModel != null) {
            Iterator requestIter = requestModel.getBodyBlocks();
            if (requestIter.hasNext()) {
                requestWsdlModel = (Block)requestIter.next();
            }
            eachRequestParameter = requestModel.getParameters();
        }
        if (responseModel != null) {
            Iterator responseIter = responseModel.getBodyBlocks();
            if (responseIter.hasNext()) {
                responseWsdlModel = (Block)responseIter.next();
            }
            eachResponseParameter = responseModel.getParameters();
        } else {
            operationInfo.setIsOneWay(true);
        }
        LiteralType requestType = null;
        QName requestWsdlName = null;
        QName requestXmlType = null;
        if (requestWsdlModel != null) {
            requestType = (LiteralType)requestWsdlModel.getType();
            requestXmlType = requestType.getName();
            requestWsdlName = requestWsdlModel.getName();
        }
        LiteralType responseType = null;
        QName responseWsdlName = null;
        if (responseWsdlModel != null) {
            responseType = (LiteralType)responseWsdlModel.getType();
            responseWsdlName = responseWsdlModel.getName();
        }
        if ((returnJavaTypeModel = methodModel.getReturnType()) != null && !"void".equals(returnJavaTypeModel.getName()) && eachResponseParameter.hasNext()) {
            Parameter returnParameter = (Parameter)eachResponseParameter.next();
            LiteralType returnParameterLitType = (LiteralType)returnParameter.getType();
            memberInfos = new ArrayList();
            if (returnParameterLitType instanceof LiteralSequenceType || returnParameterLitType instanceof LiteralStructuredType) {
                members = ((LiteralStructuredType)returnParameterLitType).getElementMembers();
                while (members.hasNext()) {
                    member = (LiteralElementMember)members.next();
                    memName = member.getName().getLocalPart();
                    memberType = member.getType();
                    javaType = memberType.getJavaType();
                    javaClass = this.getJavaClassFor(memberType);
                    xmlTypeName = memberType.getName();
                    info = new ParameterMemberInfo();
                    info.addParameterMemberInfo(memName, xmlTypeName, javaClass);
                    memberInfos.add(info);
                }
            }
            operationInfo.setReturnTypeQName(returnParameterLitType.getName());
            operationInfo.setReturnMembers(memberInfos);
            operationInfo.setReturnTypeModel(new LiteralElementMember(responseWsdlName, responseType));
            Class returnJavaType = this.getJavaClassFor(returnParameter.getType());
            operationInfo.setReturnClassName(returnParameter.getType().getJavaType().getName());
            operationInfo.setReturnType(responseWsdlName, returnJavaType);
            operationInfo.setReturnTypeQName(returnParameterLitType.getName());
            operationInfo.setReturnMembers(memberInfos);
        }
        while (eachRequestParameter.hasNext()) {
            currentParameter = (Parameter)eachRequestParameter.next();
            currentParameterLitType = (LiteralType)currentParameter.getType();
            memberInfos = new ArrayList<ParameterMemberInfo>();
            if (currentParameterLitType instanceof LiteralSequenceType || currentParameterLitType instanceof LiteralStructuredType) {
                members = ((LiteralStructuredType)currentParameterLitType).getElementMembers();
                while (members.hasNext()) {
                    member = (LiteralElementMember)members.next();
                    memName = member.getName().getLocalPart();
                    memberType = member.getType();
                    javaType = memberType.getJavaType();
                    javaClass = this.getJavaClassFor(memberType);
                    xmlTypeName = memberType.getName();
                    info = new ParameterMemberInfo();
                    info.addParameterMemberInfo(memName, xmlTypeName, javaClass);
                    memberInfos.add(info);
                }
            }
            ParameterMode mode = ParameterMode.IN;
            if (currentParameter.getLinkedParameter() != null) {
                mode = ParameterMode.INOUT;
            }
            operationInfo.addMemberInfos(memberInfos);
            Class parameterJavaType = this.getJavaClassFor(currentParameter.getType());
            operationInfo.addParameterModel(requestWsdlName.getLocalPart(), new LiteralElementMember(requestWsdlName, requestType));
            operationInfo.addParameter(requestWsdlName.getLocalPart(), requestWsdlName, parameterJavaType, mode);
            operationInfo.addMemberInfos(memberInfos);
            operationInfo.addParameterXmlTypeQName(currentParameterLitType.getName());
        }
        if (eachResponseParameter != null) {
            while (eachResponseParameter.hasNext()) {
                currentParameter = (Parameter)eachResponseParameter.next();
                currentParameterLitType = (LiteralType)currentParameter.getType();
                memberInfos = new ArrayList();
                if (currentParameterLitType instanceof LiteralSequenceType || currentParameterLitType instanceof LiteralStructuredType) {
                    members = ((LiteralStructuredType)currentParameterLitType).getElementMembers();
                    while (members.hasNext()) {
                        member = (LiteralElementMember)members.next();
                        memName = member.getName().getLocalPart();
                        memberType = member.getType();
                        javaType = memberType.getJavaType();
                        javaClass = this.getJavaClassFor(memberType);
                        xmlTypeName = memberType.getName();
                        info = new ParameterMemberInfo();
                        info.addParameterMemberInfo(memName, xmlTypeName, javaClass);
                        memberInfos.add(info);
                    }
                }
                operationInfo.addMemberInfos(memberInfos);
                if (currentParameter.getLinkedParameter() != null) continue;
                Class parameterJavaType = this.getJavaClassFor(currentParameter.getType());
                operationInfo.addParameterModel(requestWsdlName.getLocalPart(), new LiteralElementMember(requestWsdlName, requestType));
                operationInfo.addParameterXmlTypeQName(currentParameterLitType.getName());
                operationInfo.addParameter(responseWsdlName.getLocalPart(), responseWsdlName, parameterJavaType, ParameterMode.OUT);
                operationInfo.addParameterXmlTypeQName(currentParameterLitType.getName());
                operationInfo.addMemberInfos(memberInfos);
            }
        }
        if (operationModel.getStyle() == SOAPStyle.DOCUMENT) {
            operationInfo.setProperty("javax.xml.rpc.soap.operation.style", "document");
        }
        operationInfo.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", "");
    }

    protected void buildRpcLiteralOperation(OperationInfo operationInfo, Operation operationModel) {
        LiteralElementMember currentWsdlParameter;
        Parameter currentParameter;
        ParameterMemberInfo info;
        QName xmlTypeName;
        Class javaClass;
        JavaType javaType;
        LiteralType memberType;
        String memName;
        LiteralElementMember member;
        Iterator members;
        ArrayList<ParameterMemberInfo> memberInfos;
        LiteralType parameterParameterLitType;
        JavaMethod methodModel = operationModel.getJavaMethod();
        Request requestModel = operationModel.getRequest();
        Response responseModel = operationModel.getResponse();
        Block requestWsdlModel = null;
        Block responseWsdlModel = null;
        LiteralStructuredType requestType = null;
        LiteralStructuredType responseType = null;
        QName requestWsdlName = null;
        QName responseWsdlName = null;
        Iterator eachRequestParameter = null;
        Iterator eachResponseParameter = null;
        Iterator eachRequestWsdlParameter = null;
        Iterator eachResponseWsdlParameter = null;
        if (requestModel != null) {
            requestWsdlModel = (Block)requestModel.getBodyBlocks().next();
            eachRequestParameter = requestModel.getParameters();
            if (requestWsdlModel != null) {
                requestType = (LiteralStructuredType)requestWsdlModel.getType();
                eachRequestWsdlParameter = requestType.getElementMembers();
                requestWsdlName = requestWsdlModel.getName();
            }
        }
        if (responseModel != null) {
            responseWsdlModel = (Block)responseModel.getBodyBlocks().next();
            eachResponseParameter = responseModel.getParameters();
            if (responseWsdlModel != null) {
                responseType = (LiteralStructuredType)responseWsdlModel.getType();
                eachResponseWsdlParameter = responseType.getElementMembers();
                responseWsdlName = responseWsdlModel.getName();
            }
        } else {
            operationInfo.setIsOneWay(true);
        }
        operationInfo.setRequestQName(requestWsdlName);
        operationInfo.setResponseQName(responseWsdlName);
        JavaType returnJavaTypeModel = methodModel.getReturnType();
        if (returnJavaTypeModel != null && !"void".equals(returnJavaTypeModel.getName()) && eachResponseParameter != null) {
            Parameter returnParameter = (Parameter)eachResponseParameter.next();
            LiteralElementMember returnWsdlParameter = (LiteralElementMember)eachResponseWsdlParameter.next();
            parameterParameterLitType = returnWsdlParameter.getType();
            memberInfos = new ArrayList();
            if (parameterParameterLitType instanceof LiteralSequenceType || parameterParameterLitType instanceof LiteralStructuredType) {
                members = ((LiteralStructuredType)parameterParameterLitType).getElementMembers();
                while (members.hasNext()) {
                    member = (LiteralElementMember)members.next();
                    memName = member.getName().getLocalPart();
                    memberType = member.getType();
                    javaType = memberType.getJavaType();
                    javaClass = this.getJavaClassFor(memberType);
                    xmlTypeName = memberType.getName();
                    info = new ParameterMemberInfo();
                    info.addParameterMemberInfo(memName, xmlTypeName, javaClass);
                    memberInfos.add(info);
                }
            }
            operationInfo.setReturnTypeModel(returnWsdlParameter);
            operationInfo.setReturnMembers(memberInfos);
            QName returnXmlType = returnParameter.getType().getName();
            String parameterName = returnParameter.getType().getName().getLocalPart();
            Class returnJavaType = this.getJavaClassFor(returnParameter.getType());
            operationInfo.setReturnClassName(returnParameter.getType().getJavaType().getName());
            operationInfo.setReturnType(returnXmlType, returnJavaType);
        }
        if (eachRequestParameter != null) {
            while (eachRequestParameter.hasNext()) {
                currentParameter = (Parameter)eachRequestParameter.next();
                currentWsdlParameter = (LiteralElementMember)eachRequestWsdlParameter.next();
                parameterParameterLitType = currentWsdlParameter.getType();
                memberInfos = new ArrayList<ParameterMemberInfo>();
                if (parameterParameterLitType instanceof LiteralSequenceType || parameterParameterLitType instanceof LiteralStructuredType) {
                    members = ((LiteralStructuredType)parameterParameterLitType).getElementMembers();
                    while (members.hasNext()) {
                        member = (LiteralElementMember)members.next();
                        memName = member.getName().getLocalPart();
                        memberType = member.getType();
                        javaType = memberType.getJavaType();
                        javaClass = this.getJavaClassFor(memberType);
                        xmlTypeName = memberType.getName();
                        info = new ParameterMemberInfo();
                        info.addParameterMemberInfo(memName, xmlTypeName, javaClass);
                        memberInfos.add(info);
                    }
                }
                ParameterMode mode = ParameterMode.IN;
                if (currentParameter.getLinkedParameter() != null) {
                    mode = ParameterMode.INOUT;
                }
                operationInfo.addMemberInfos(memberInfos);
                this.addParameterTo(operationInfo, currentWsdlParameter, mode);
            }
        }
        if (eachResponseParameter != null) {
            while (eachResponseParameter.hasNext()) {
                currentParameter = (Parameter)eachResponseParameter.next();
                currentWsdlParameter = (LiteralElementMember)eachResponseWsdlParameter.next();
                parameterParameterLitType = currentWsdlParameter.getType();
                memberInfos = new ArrayList();
                if (parameterParameterLitType instanceof LiteralSequenceType || parameterParameterLitType instanceof LiteralStructuredType) {
                    members = ((LiteralStructuredType)parameterParameterLitType).getElementMembers();
                    while (members.hasNext()) {
                        member = (LiteralElementMember)members.next();
                        memName = member.getName().getLocalPart();
                        memberType = member.getType();
                        javaType = memberType.getJavaType();
                        javaClass = this.getJavaClassFor(memberType);
                        xmlTypeName = memberType.getName();
                        info = new ParameterMemberInfo();
                        info.addParameterMemberInfo(memName, xmlTypeName, javaClass);
                        memberInfos.add(info);
                    }
                }
                if (currentParameter.getLinkedParameter() != null) continue;
                operationInfo.addMemberInfos(memberInfos);
                this.addParameterTo(operationInfo, currentWsdlParameter, ParameterMode.OUT);
            }
        }
        operationInfo.setProperty("javax.xml.rpc.soap.operation.style", "rpc");
        operationInfo.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", "");
    }

    protected void addParameterTo(OperationInfo operationInfo, SOAPStructureMember currentParameter, ParameterMode mode) {
        String parameterName = currentParameter.getName().getLocalPart();
        QName parameterXmlType = currentParameter.getType().getName();
        Class parameterJavaType = this.getJavaClassFor(currentParameter.getType());
        operationInfo.addParameter(parameterName, parameterXmlType, parameterJavaType, mode);
    }

    protected void addParameterTo(OperationInfo operationInfo, LiteralElementMember currentParameter, ParameterMode mode) {
        String parameterName = currentParameter.getName().getLocalPart();
        QName parameterXmlType = currentParameter.getType().getName();
        Class parameterJavaType = this.getJavaClassFor(currentParameter.getType());
        operationInfo.addParameterModel(parameterName, currentParameter);
        operationInfo.addParameter(parameterName, parameterXmlType, parameterJavaType, mode);
    }

    protected Class getJavaClassFor(AbstractType parameterType) {
        String elementTypeName;
        JavaType javaType = parameterType.getJavaType();
        String parameterJavaTypeName = javaType.getName();
        if (parameterJavaTypeName.indexOf("[][]") != -1) {
            elementTypeName = this.getArrayElementTypeName(javaType);
            if (elementTypeName != null) {
                parameterJavaTypeName = "[[L" + elementTypeName + ";";
            }
        } else if (parameterJavaTypeName.indexOf("[]") != -1 && (elementTypeName = this.getArrayElementTypeName(javaType)) != null) {
            parameterJavaTypeName = "[L" + elementTypeName + ";";
        }
        Class<?> parameterJavaType = null;
        try {
            if (parameterJavaTypeName != null) {
                parameterJavaType = this.getClassForName(parameterJavaTypeName, Arrays.asList(this.getPackages()));
                return parameterJavaType;
            }
        }
        catch (NoClassDefFoundError e) {
            String qualifiedName;
            String message = e.getMessage();
            if (message.indexOf("wrong name:") != -1 && (qualifiedName = this.findQualifiedName(message)) != null) {
                try {
                    parameterJavaType = Class.forName(qualifiedName);
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return parameterJavaType;
    }

    private String getArrayElementTypeName(JavaType javaType) {
        JavaType elementType = null;
        if (javaType instanceof JavaArrayType) {
            elementType = ((JavaArrayType)javaType).getElementType();
        }
        if (elementType != null) {
            return elementType.getName();
        }
        return null;
    }

    private String findQualifiedName(String message) {
        StringTokenizer tokens = new StringTokenizer(message);
        while (tokens.hasMoreElements()) {
            String currentToken = tokens.nextToken();
            if (!currentToken.equals("name:")) continue;
            String qualifiedToken = tokens.nextToken();
            if (qualifiedToken.indexOf("\\") != -1) {
                qualifiedToken = qualifiedToken.replace('\\', '.');
            } else if (qualifiedToken.indexOf("/") != -1) {
                qualifiedToken = qualifiedToken.replace('/', '.');
            }
            qualifiedToken = qualifiedToken.replace(')', ' ');
            return qualifiedToken.trim();
        }
        return null;
    }

    protected Class getClassForName(String name, Collection packages) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            Iterator iter = packages.iterator();
            while (iter.hasNext()) {
                String qualifiedName = ((Package)iter.next()).getName() + "." + name;
                try {
                    Class<?> kclass = Class.forName(qualifiedName);
                    if (kclass == null) continue;
                    return kclass;
                }
                catch (ClassNotFoundException cfe) {
                }
            }
            return null;
        }
    }

    private Model getModel(String wsdlLocation) throws ServiceException {
        Model model;
        block12: {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            model = null;
            try {
                Enumeration<URL> urls = null;
                try {
                    urls = loader.getResources("META-INF/client.xml");
                    if (urls == null || !urls.hasMoreElements()) {
                        urls = loader.getResources("client.xml");
                    }
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
                if (!urls.hasMoreElements()) break block12;
                URL url = urls.nextElement();
                InputStream in = null;
                try {
                    in = url.openStream();
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
                WebServicesClientParser parser = new WebServicesClientParser();
                WebServicesClient client = parser.parse(in);
                Iterator iter = client.getWebServices().iterator();
                while (iter.hasNext()) {
                    WebService webservice = (WebService)iter.next();
                    String webServiceLocation = webservice.getWsdlLocation();
                    String webServiceModel = webservice.getModel();
                    if (!wsdlLocation.equalsIgnoreCase(webServiceLocation)) continue;
                    URL modelURL = null;
                    try {
                        modelURL = new URL(webServiceModel);
                    }
                    catch (MalformedURLException e) {
                        throw new ServiceException((Throwable)e);
                    }
                    InputStream is = null;
                    try {
                        is = modelURL.openStream();
                    }
                    catch (IOException e) {
                        throw new ServiceException((Throwable)e);
                    }
                    ModelImporter importer = new ModelImporter(is);
                    model = importer.doImport();
                    return model;
                }
            }
            catch (ModelException ex) {
                throw new ServiceException((Throwable)((Object)ex));
            }
        }
        return model;
    }
}

