/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DocDefHandler;
import org.netbeans.modules.schema2beans.DocDefParser;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GraphLink;
import org.netbeans.modules.schema2beans.GraphNode;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.TreeParser;

public class TreeBuilder
implements DocDefHandler,
TreeParser {
    GraphNode rootNode;
    String docRoot;
    GenBeans.Config config;
    private Stack curLinkStack = new Stack();
    private GraphLink curLink;
    private Stack curElementTypeStack = new Stack();
    private int curElementType;
    private Stack curAttrStack = new Stack();
    private AttrProp curAttr = null;
    Map nameHash = new HashMap();
    private String defaultNamespace = null;
    private static final int CREATE = 1;
    private static final int GET = 2;
    private static final int REFERENCE = 3;
    private static final String INDENT = "  ";

    void pushLevel() {
        this.curLinkStack.push(this.curLink);
        this.curElementTypeStack.push(new Integer(this.curElementType));
        this.curAttrStack.push(this.curAttr);
    }

    void popLevel() {
        this.curLink = (GraphLink)this.curLinkStack.pop();
        this.curElementType = (Integer)this.curElementTypeStack.pop();
        this.curAttr = (AttrProp)this.curAttrStack.pop();
    }

    TreeBuilder(GenBeans.Config config) {
        this.config = config;
    }

    public void startDocument(String root) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 1, root);
            this.config.messageOut.println("Building the schema object graph.");
        }
        this.docRoot = root;
    }

    public void endDocument() {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 2);
            this.config.messageOut.println("schema Object graph built.");
        }
        try {
            this.findRootNode();
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
        if (DDLogFlags.debug) {
            this.config.messageOut.println(this.dump());
        }
    }

    private GraphNode getGraphNode(String name, int mode) throws Schema2BeansException {
        String uniqueName = name;
        GraphNode node = (GraphNode)this.nameHash.get(uniqueName);
        if (node != null) {
            if (node.isCreated() && mode == 1) {
                throw new Schema2BeansException(Common.getMessage("DuplicateElement_msg", uniqueName));
            }
        } else {
            node = new GraphNode(name, uniqueName);
            node.setGraphLink(new GraphLink(null));
            this.nameHash.put(uniqueName, node);
        }
        if (mode == 1) {
            node.setCreated(true);
        } else if (mode == 3) {
            node.incrRefCount();
        }
        return node;
    }

    public void startElement(String uniqueName, String typeName, int type) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 3, uniqueName + " - " + typeName + " - " + TreeBuilder.typeToString(type));
        }
        this.pushLevel();
        this.curElementType = type;
        try {
            if (type == 2) {
                GraphNode node = this.getGraphNode(typeName, 1);
                this.curLink = node.getGraphLink();
            } else if (type == 3) {
                GraphNode node = this.getGraphNode(typeName, 2);
                this.curAttr = new AttrProp(typeName);
                node.addAttribute(this.curAttr);
            }
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
    }

    public void startElement(String name, int type) {
        this.startElement(name, name, type);
    }

    public void endElement() {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 4);
        }
        if (this.curElementType == 3) {
            this.curAttr.validate();
        }
        this.curElementType = 0;
        this.popLevel();
    }

    public void character(char c) {
        if (this.curElementType == 2) {
            if (c == '|') {
                this.curLink.parent.setSequence(2);
            }
        } else if (this.curElementType == 3 && c == '|') {
            this.curAttr.checkEnum();
        }
    }

    public void element(String uniqueName, String typeName, String attrName, int instance, boolean externalType, String defaultValue) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 1, 5, attrName + " : " + typeName + TreeBuilder.instanceToString(instance, false));
        }
        try {
            if (this.curElementType == 0 && !externalType) {
                if (DDLogFlags.debug) {
                    System.out.println("Top element def for " + attrName);
                }
                GraphNode attrNode = this.getGraphNode(attrName, 1);
                GraphNode node = this.getGraphNode(typeName, 3);
                attrNode.setAlias(node);
            } else if (this.curElementType == 2) {
                GraphNode node = this.getGraphNode(typeName, 3);
                GraphLink link = new GraphLink(attrName);
                link.setDefaultValue(defaultValue);
                this.curLink.sibling = link;
                link.parent = this.curLink.parent;
                this.curLink = link;
                this.curLink.element = node;
                this.curLink.setElementInstance(instance);
                if (externalType) {
                    node.setJavaType(typeName);
                }
            } else if (this.curElementType == 3) {
                if (this.curAttr.isComplete()) {
                    throw new DocDefParser.MissingEndOfEltException(this.curAttr.getPropertyName());
                }
                if (defaultValue != null) {
                    this.curAttr.setDefaultValue(defaultValue);
                }
                this.curAttr.addValue(attrName);
                if (externalType) {
                    this.curAttr.setJavaType(typeName);
                }
            }
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
    }

    public void element(String typeName, int instance) {
        this.element(typeName, typeName, typeName, instance, false, null);
    }

    public void addExtraDataNode(String typeName, Object data) throws Schema2BeansException {
        GraphNode node = this.getGraphNode(typeName, 2);
        node.addExtraData(data);
    }

    public void addExtraDataCurLink(Object data) {
        if (this.curLink != null) {
            this.curLink.extraData.add(data);
        }
    }

    public void setExtendedProperty(String typeName, String propertyName, Object value) throws Schema2BeansException {
        GraphNode node = this.getGraphNode(typeName, 2);
        node.setExtendedProperty(propertyName, value);
    }

    public void javaType(String uniqueName, String name, String javaType) {
        if (this.curElementType == 3) {
            this.curAttr.setJavaType(javaType);
        } else {
            GraphNode node;
            try {
                node = this.getGraphNode(name, 2);
            }
            catch (Schema2BeansException e) {
                throw new Schema2BeansRuntimeException(e);
            }
            node.setJavaType(javaType);
            node.setCreated(false);
        }
    }

    public void startGroupElements() {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 5, 6);
        }
        if (this.curElementType == 2) {
            GraphLink link = new GraphLink(null);
            link.parent = this.curLink;
            if (this.curLink.child == null) {
                this.curLink.child = link;
            } else {
                GraphLink l = this.curLink.child;
                while (l.sibling != null) {
                    l = l.sibling;
                }
                l.sibling = link;
            }
            this.curLink = link;
        } else if (this.curElementType == 3) {
            this.curAttr.setEnum(true);
        }
    }

    public void endGroupElements(int instance) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 12, 5, 7, TreeBuilder.instanceToString(instance, false));
        }
        if (this.curElementType == 2) {
            this.curLink = this.curLink.parent;
            this.curLink.setGroupInstance(instance);
        } else if (this.curElementType == 3) {
            this.curAttr.setEnum(false);
        }
    }

    public void setDefaultNamespace(String ns) {
        this.defaultNamespace = ns;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    private void findRootNode() throws Schema2BeansException {
        GraphNode node;
        Iterator it = this.nameHash.values().iterator();
        int count = 0;
        ArrayList<GraphNode> list = new ArrayList<GraphNode>();
        while (it.hasNext()) {
            node = (GraphNode)it.next();
            if (DDLogFlags.debug) {
                System.out.println("refCount=" + node.getRefCount() + " created=" + node.isCreated() + " javaType=" + node.getJavaType() + " node=" + node);
            }
            if (!node.isCreated() || node.getRefCount() != 0) continue;
            ++count;
            list.add(node);
        }
        if (count > 1) {
            int highestPoints = 0;
            GraphNode highestNode = null;
            int tieCount = 0;
            Iterator highit = list.iterator();
            while (highit.hasNext()) {
                GraphLink link;
                int points = 0;
                node = (GraphNode)highit.next();
                if (node.getAlias() != null) {
                    ++points;
                }
                boolean bl = this.defaultNamespace == null ? node.getNamespace() == null : this.defaultNamespace.equals(node.getNamespace());
                if (bl) {
                    ++points;
                }
                if ((link = node.getGraphLink()) != null && link.child != null) {
                    ++points;
                    if (link.child.sibling != null) {
                        ++points;
                    }
                    if (link.child.child != null) {
                        ++points;
                    }
                }
                if (points > highestPoints) {
                    highestPoints = points;
                    highestNode = node;
                    tieCount = 0;
                    continue;
                }
                if (points != highestPoints) continue;
                ++tieCount;
            }
            if (tieCount == 0 && highestNode != null) {
                count = 1;
                list.clear();
                list.add(highestNode);
            }
        }
        if (count == 1) {
            this.rootNode = (GraphNode)list.get(0);
            if (this.docRoot != null && !this.docRoot.equals(this.rootNode.getName())) {
                String str = "Mismatch between doc root name specified (" + this.docRoot + ") and the root name found in the DTD graph (" + this.rootNode.getName() + ")";
                throw new IllegalStateException(str);
            }
        } else if (count == 0) {
            this.rootNode = null;
            if (this.docRoot != null) {
                it = this.nameHash.values().iterator();
                while (it.hasNext()) {
                    node = (GraphNode)it.next();
                    if (!this.docRoot.equals(node.getName())) continue;
                    this.rootNode = node;
                    break;
                }
            }
            if (this.rootNode == null) {
                throw new IllegalStateException(Common.getMessage("NoRootElementCandidate"));
            }
        } else {
            this.config.messageOut.println("The following elements could be the root of the document:");
            int i = 0;
            while (i < list.size()) {
                GraphNode n = (GraphNode)list.get(i);
                this.config.messageOut.print(i + 1 + ". " + n);
                if (this.docRoot != null && this.docRoot.equals(n.getName())) {
                    this.rootNode = n;
                    this.config.messageOut.println(" <= parameter value");
                } else {
                    this.config.messageOut.println("");
                }
                ++i;
            }
            if (this.rootNode == null) {
                String errStr = "Could not find the root of the document. Use the -d option to specify the doc root";
                if (this.config.auto) {
                    throw new IllegalStateException(errStr);
                }
                try {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
                    this.config.messageOut.print("Enter the element that should be used as the root: ");
                    String str = rd.readLine();
                    int i2 = Integer.parseInt(str) - 1;
                    if (i2 < 0 || i2 >= list.size()) {
                        throw new IllegalStateException(errStr);
                    }
                    this.rootNode = (GraphNode)list.get(i2);
                }
                catch (Exception e) {
                    TraceLogger.error(e);
                    throw new Schema2BeansNestedException(errStr, e);
                }
            }
        }
        if (DDLogFlags.debug) {
            this.config.messageOut.println("Using " + this.rootNode.getName() + " as the root of the document.");
        }
    }

    static String instanceToString(int instance, boolean bean) {
        switch (instance) {
            case 16: {
                return "?";
            }
            case 48: {
                if (bean) {
                    return "[0,n]";
                }
                return "*";
            }
            case 64: {
                if (bean) {
                    return "[1,n]";
                }
                return "+";
            }
        }
        return "";
    }

    static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "comment";
            }
            case 2: {
                return "element";
            }
            case 3: {
                return "attlist";
            }
        }
        return "unknown value: " + type;
    }

    public GraphNode[] getNodes() {
        int maxSize = this.nameHash.values().size();
        GraphNode[] ret = new GraphNode[maxSize];
        HashMap insertedNodes = new HashMap();
        int pos = 0;
        pos = this.getNodesInsertNode(this.rootNode, ret, pos, insertedNodes);
        pos = this.getNodes(this.rootNode.getGraphLink(), ret, pos, insertedNodes);
        Iterator it = this.nameHash.values().iterator();
        while (pos < maxSize && it.hasNext()) {
            GraphNode node = (GraphNode)it.next();
            if (insertedNodes.containsKey(node)) continue;
            this.config.messageOut.println(Common.getMessage("MSG_FoundUnreferencedNode", node.toString()));
            ret[pos++] = node;
        }
        return ret;
    }

    private int getNodes(GraphLink l, GraphNode[] ret, int pos, Map insertedNodes) {
        Stack<GraphLink> linkStack = new Stack<GraphLink>();
        linkStack.push(l);
        while (!linkStack.isEmpty()) {
            l = (GraphLink)linkStack.pop();
            while (l != null) {
                if (l.element != null && !insertedNodes.containsKey(l.element)) {
                    pos = this.getNodesInsertNode(l.element, ret, pos, insertedNodes);
                    linkStack.push(l.element.getGraphLink());
                }
                linkStack.push(l.child);
                l = l.sibling;
            }
        }
        return pos;
    }

    private int getNodesInsertNode(GraphNode node, GraphNode[] ret, int pos, Map insertedNodes) {
        if (insertedNodes.containsKey(node)) {
            return pos;
        }
        ret[pos++] = node;
        insertedNodes.put(node, null);
        if (node.getAlias() != null && !insertedNodes.containsKey(node.getAlias())) {
            ret[pos++] = node.getAlias();
            insertedNodes.put(node.getAlias(), null);
        }
        return pos;
    }

    public GraphNode getNode(String uniqueName) {
        return (GraphNode)this.nameHash.get(uniqueName);
    }

    public GraphNode getRoot() {
        return this.rootNode;
    }

    public String dumpHash() {
        StringBuffer str = new StringBuffer();
        Iterator it = this.nameHash.values().iterator();
        str.append("List of elements:\n");
        while (it.hasNext()) {
            GraphNode node = (GraphNode)it.next();
            str.append(INDENT + node.toString() + " ");
            str.append(node.getGraphLink().parent == null ? "" : "P ");
            str.append(node.getGraphLink().sibling == null ? "" : "S ");
            str.append(node.getGraphLink().child == null ? "" : "C ");
            str.append(" [" + node.getRefCount() + "]\n");
        }
        return str.toString();
    }

    static void dumpAttributes(GraphNode elt, StringBuffer str, String indent) {
        AttrProp[] attrList = elt.getAttributes();
        int i = 0;
        while (i < attrList.length) {
            str.append(indent + INDENT + "[attr: " + attrList[i] + "]\n");
            ++i;
        }
    }

    static void dumpTree(GraphLink l, StringBuffer str, String indent, boolean tree) {
        while (l != null) {
            if (l.element != null) {
                str.append(indent);
                str.append(l.name + " : " + l.element.toString());
                str.append(TreeBuilder.instanceToString(l.getElementInstance(), false) + "\n");
                TreeBuilder.dumpAttributes(l.element, str, indent);
                if (tree && !l.element.getMarked()) {
                    l.element.setMarked(true);
                    TreeBuilder.dumpTree(l.element.getGraphLink(), str, indent + INDENT + TreeBuilder.instanceToString(l.getGroupInstance(), false) + (l.isSequenceOr() ? "| " : " "), tree);
                    l.element.setMarked(false);
                }
            }
            if (l.isSequenceOr() || l.getGroupInstance() != 32) {
                str.append(indent + TreeBuilder.instanceToString(l.getGroupInstance(), false) + (l.isSequenceOr() ? "|\n" : "\n"));
            }
            TreeBuilder.dumpTree(l.child, str, indent + INDENT, tree);
            l = l.sibling;
        }
    }

    void dumpElt(GraphLink l, StringBuffer str, String indent) {
        while (l != null) {
            str.append(indent + "GraphLink= " + l + "\n\t" + indent + "E= " + l.element + "\n\t" + indent + "C= " + l.child + "\n\t" + indent + "P=" + l.parent + "\n\t" + indent + "S=" + l.sibling + "\n\t" + indent + "pE = " + TreeBuilder.instanceToString(l.getElementInstance(), false) + "\n\t" + indent + "pG = " + TreeBuilder.instanceToString(l.getGroupInstance(), false) + "\n\t" + indent + "seq = " + (l.isSequenceOr() ? "or\n" : "and\n"));
            this.dumpElt(l.child, str, indent + "\t");
            l = l.sibling;
        }
    }

    public String dump() {
        StringBuffer str = new StringBuffer();
        str.append("Tree:\n");
        str.append(this.rootNode.toString());
        str.append("\n");
        TreeBuilder.dumpAttributes(this.rootNode, str, INDENT);
        TreeBuilder.dumpTree(this.rootNode.getGraphLink(), str, INDENT, true);
        return str.toString();
    }

    public String dumpElement(GraphNode n) {
        StringBuffer str = new StringBuffer();
        str.append("Element:\n");
        str.append(n.toString());
        str.append("\n");
        this.dumpElt(n.getGraphLink(), str, "\t");
        return str.toString();
    }
}

