/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DDParser;
import org.netbeans.modules.schema2beans.DDRegistryParser;
import org.netbeans.modules.schema2beans.TraceLogger;

public class DDRegistry {
    private ArrayList scopes = new ArrayList();
    private ChangeTracer changeTracer = new ChangeTracer(this);

    public void createEntry(BaseBean bean, String ID, String name) {
        RegEntry entry = this.getRegEntry(bean, false);
        if (entry != null) {
            throw new IllegalArgumentException(Common.getMessage("BeanGraphAlreadyInRegistry_msg", bean.name()));
        }
        entry = this.getRegEntry(ID);
        if (entry != null) {
            throw new IllegalArgumentException(Common.getMessage("CantRegisterGraphSameID_msg", bean.name(), entry, ID));
        }
        bean.addPropertyChangeListener(this.changeTracer);
        this.scopes.add(new RegEntry(bean, ID, name));
    }

    public void updateEntry(String ID, BaseBean bean) {
        RegEntry entry = this.getRegEntry(ID);
        if (entry == null) {
            throw new IllegalArgumentException(Common.getMessage("CantUpdateGraphNotInRegistry_msg", ID));
        }
        entry.setBean(bean);
    }

    public void removeEntry(BaseBean bean) {
        RegEntry entry = this.getRegEntry(bean, false);
        if (entry != null) {
            entry.getBean().removePropertyChangeListener(this.changeTracer);
            this.removeRegEntry(entry);
        }
    }

    public void renameEntry(String oldID, String newID, String newName) {
        RegEntry entry = this.getRegEntry(oldID);
        if (entry != null) {
            entry.setID(newID);
            if (newName != null) {
                entry.setName(newName);
            }
        }
    }

    public void renameEntry(String oldID, String newID) {
        this.renameEntry(oldID, newID, null);
    }

    public void removeEntry(String ID) {
        RegEntry entry = this.getRegEntry(ID);
        if (entry != null) {
            entry.getBean().removePropertyChangeListener(this.changeTracer);
        }
        this.removeRegEntry(entry);
    }

    public DDChangeMarker createChangeMarker() {
        return new DDChangeMarker(this);
    }

    public boolean hasType(BaseBean bean, String type) {
        RegEntry r = this.getRegEntry(bean, false);
        if (r != null) {
            return r.hasType(type);
        }
        return false;
    }

    public void clearCache() {
        int i = 0;
        while (i < this.scopes.size()) {
            RegEntry se = (RegEntry)this.scopes.get(i);
            if (se != null) {
                se.setTimestamp();
            }
            ++i;
        }
    }

    public void clearCache(BaseBean bean) {
        this.setTimestamp(bean);
    }

    public void setTimestamp(BaseBean bean) {
        RegEntry r = this.getRegEntry(bean, false);
        if (r != null) {
            r.setTimestamp();
        }
    }

    public long getTimestamp(BaseBean bean) {
        RegEntry r = this.getRegEntry(bean, false);
        if (r != null) {
            return r.getTimestamp();
        }
        return 0L;
    }

    public String getID(BaseBean bean) {
        RegEntry r = this.getRegEntry(bean, false);
        if (r != null) {
            return r.getID();
        }
        return null;
    }

    public String getID(DDRegistryParser.DDCursor c) {
        RegEntry r = this.getRegEntry(c.getRoot(), false);
        if (r != null) {
            return r.getID();
        }
        return null;
    }

    public String getName(DDRegistryParser.DDCursor c) {
        RegEntry r = this.getRegEntry(c.getRoot(), false);
        if (r != null) {
            return r.getName();
        }
        return null;
    }

    public DDRegistryParser newParser(DDRegistryParser parser, String path) {
        return new DDRegistryParser(this, parser, path);
    }

    public DDRegistryParser newParser(DDRegistryParser.DDCursor cursor, String path) {
        return new DDRegistryParser(this, cursor, path);
    }

    public DDRegistryParser newParser(String scope) {
        return new DDRegistryParser(this, scope);
    }

    public DDRegistryParser.DDCursor newCursor(DDRegistryParser.DDCursor c, String path) {
        return new DDRegistryParser.DDCursor(c, path);
    }

    public DDRegistryParser.DDCursor newCursor(String path) {
        return new DDRegistryParser.DDCursor(this, path);
    }

    public DDRegistryParser.DDCursor newCursor(BaseBean bean) {
        return new DDRegistryParser.DDCursor(this, bean);
    }

    public void addType(BaseBean bean, String type) {
        if (DDLogFlags.debug) {
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 16, 1, 1, bean.name() + " " + type);
        }
        RegEntry se = this.getRegEntry(bean, true);
        se.add(type);
    }

    public String getName(String ID) {
        RegEntry r = this.getRegEntry(ID);
        if (r != null) {
            return r.getName();
        }
        return null;
    }

    public String dump() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.scopes.size()) {
            RegEntry se = (RegEntry)this.scopes.get(i);
            if (se != null) {
                s.append(se.toString() + "\n");
            }
            ++i;
        }
        return s.toString();
    }

    public String dumpAll() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.scopes.size()) {
            RegEntry se = (RegEntry)this.scopes.get(i);
            if (se != null) {
                s.append("\n*** Graph:" + se.toString() + "\n");
                s.append(se.getBean().dumpBeanNode());
            }
            ++i;
        }
        return s.toString();
    }

    public RegEntry getRegEntry(BaseBean bean, boolean raise) {
        int i = 0;
        while (i < this.scopes.size()) {
            RegEntry se = (RegEntry)this.scopes.get(i);
            if (se.getBean() == bean) {
                return se;
            }
            ++i;
        }
        if (bean != null && !bean.isRoot()) {
            while ((bean = bean.parent()) != null && !bean.isRoot()) {
            }
            return this.getRegEntry(bean, raise);
        }
        if (raise) {
            throw new IllegalArgumentException(Common.getMessage("BeanGraphEntryNotInRegistry_msg", bean.name()));
        }
        return null;
    }

    private RegEntry getRegEntry(String ID) {
        int i = 0;
        while (i < this.scopes.size()) {
            RegEntry se = (RegEntry)this.scopes.get(i);
            if (se.getID().equals(ID)) {
                return se;
            }
            ++i;
        }
        return null;
    }

    private void removeRegEntry(RegEntry entry) {
        int i = this.scopes.indexOf(entry);
        if (i != -1) {
            this.scopes.remove(i);
        }
    }

    public static String getGraphName(String s) {
        if (s != null && (s = s.trim()).startsWith("[")) {
            int i = s.indexOf(93);
            if (i != -1) {
                s = s.substring(1, i);
            } else {
                return null;
            }
        }
        return s;
    }

    public boolean hasGraph(String str) {
        return this.hasGraph(str, null);
    }

    public boolean hasGraph(String str, DDRegistryParser.DDCursor c) {
        String s = DDRegistry.getGraphName(str);
        if (s != null) {
            if (!s.equals(".")) {
                return this.getRoot(s) != null;
            }
            if (c == null) {
                return true;
            }
            return this.getID(c) != null;
        }
        return false;
    }

    public static String createGraphName(String s) {
        if (s != null) {
            s.trim();
            int i = s.indexOf(91);
            if (i != -1 && i < s.indexOf(93)) {
                return s;
            }
            return "[" + s + "]";
        }
        throw new IllegalArgumentException(Common.getMessage("GraphNameCantBeNull_msg"));
    }

    public BaseBean getRoot(String s) {
        BaseBean[] r = this.getRoots(s);
        if (r.length > 0) {
            return r[0];
        }
        return null;
    }

    public BaseBean[] getRoots(String s) {
        RegEntry se = this.getRegEntry(s = DDRegistry.getGraphName(s));
        if (se == null) {
            ArrayList<BaseBean> list = new ArrayList<BaseBean>();
            int i = 0;
            while (i < this.scopes.size()) {
                se = (RegEntry)this.scopes.get(i);
                if (se.hasType(s)) {
                    list.add(se.getBean());
                }
                ++i;
            }
            BaseBean[] ret = new BaseBean[list.size()];
            return list.toArray(ret);
        }
        return new BaseBean[]{se.getBean()};
    }

    static class RegEntry {
        private BaseBean bean;
        private ArrayList types;
        private String ID;
        private String name;
        private long timestamp;

        RegEntry(BaseBean b, String ID, String name) {
            this.bean = b;
            this.types = new ArrayList();
            this.ID = ID;
            this.name = name;
            this.setTimestamp();
        }

        void setTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        long getTimestamp() {
            return this.timestamp;
        }

        void setBean(BaseBean bean) {
            this.bean = bean;
        }

        BaseBean getBean() {
            return this.bean;
        }

        String getName() {
            return this.name;
        }

        String getID() {
            return this.ID;
        }

        void setID(String ID) {
            this.ID = ID;
        }

        void setName(String name) {
            this.name = name;
        }

        void add(String type) {
            this.types.add(type);
        }

        boolean hasType(String type) {
            int i = 0;
            while (i < this.types.size()) {
                String t = (String)this.types.get(i);
                if (type != null && t.equals(type)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String toString() {
            String s = this.bean.name() + "(id:" + this.ID + "-name:" + this.name + ")" + " [";
            int i = 0;
            while (i < this.types.size()) {
                String t = (String)this.types.get(i);
                s = s + " " + t;
                ++i;
            }
            return s + "]";
        }
    }

    class IterateParser
    implements Iterator {
        private ArrayList list = new ArrayList();
        private int pos;

        void addParser(BaseBean b, String parsingPath) {
            this.list.add(new DDParser(b, parsingPath));
        }

        public boolean hasNext() {
            return this.pos < this.list.size();
        }

        public Object next() {
            return this.list.get(this.pos++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ChangeTracer
    implements PropertyChangeListener {
        DDRegistry reg;

        public ChangeTracer(DDRegistry reg) {
            this.reg = reg;
        }

        public void propertyChange(PropertyChangeEvent e) {
            try {
                BaseBean s = (BaseBean)e.getSource();
                RegEntry re = this.reg.getRegEntry(s, false);
                re.setTimestamp();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class DDChangeMarker {
        private DDRegistry reg;
        private long timestamp;
        private ArrayList elts = null;

        DDChangeMarker(DDRegistry reg) {
            this.reg = reg;
            this.elts = new ArrayList();
            this.timestamp = 0L;
        }

        public int size() {
            return this.elts.size();
        }

        public void add(DDChangeMarker cm) {
            if (cm == this) {
                Thread.dumpStack();
            }
            this.elts.add(cm);
        }

        public void add(BaseBean b) {
            RegEntry re = this.reg.getRegEntry(b, false);
            if (re != null && !this.elts.contains(re)) {
                this.elts.add(re);
            }
        }

        public void add(DDRegistryParser.DDCursor c) {
            String id = this.reg.getID(c);
            if (id != null) {
                BaseBean b = this.reg.getRoot(id);
                this.add(b);
            }
        }

        public void remove(DDChangeMarker cm) {
            ((AbstractCollection)this.elts).remove(cm);
        }

        public void remove(BaseBean b) {
            RegEntry re = this.reg.getRegEntry(b, false);
            if (re != null) {
                ((AbstractCollection)this.elts).remove(re);
            }
        }

        public void remove(DDRegistryParser.DDCursor c) {
            String id = this.reg.getID(c);
            if (id != null) {
                BaseBean b = this.reg.getRoot(id);
                this.remove(b);
            }
        }

        public void resetTime() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean hasChanged() {
            boolean b = this.hasChanged(this.timestamp);
            return b;
        }

        private boolean hasChanged(long ts) {
            int i = 0;
            while (i < this.elts.size()) {
                Object o = this.elts.get(i);
                if (o != null && (o instanceof DDChangeMarker ? ((DDChangeMarker)o).hasChanged(ts) : o instanceof RegEntry && ((RegEntry)o).getTimestamp() > ts)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String dump() {
            return this.dump(new StringBuffer(), "", this.timestamp).toString();
        }

        public StringBuffer dump(StringBuffer sb, String indent, long ts) {
            sb.append(indent + this.toString() + "\n");
            int i = 0;
            while (i < this.elts.size()) {
                Object o = this.elts.get(i);
                if (o != null) {
                    if (o instanceof DDChangeMarker) {
                        ((DDChangeMarker)o).dump(sb, indent + "  ", ts);
                    } else if (o instanceof RegEntry) {
                        RegEntry re = (RegEntry)o;
                        sb.append(indent + "  " + re.getBean() + "-0x" + Integer.toHexString(re.getBean().hashCode()));
                        long l = re.getTimestamp();
                        if (l > ts) {
                            sb.append(" Changed  (bean ts:" + l + " > cm ts:" + ts);
                        } else {
                            sb.append(" No_Change (bean ts:" + l + " < cm ts:" + ts + ")");
                        }
                        sb.append("\n");
                    }
                }
                ++i;
            }
            return sb;
        }

        public String toString() {
            return "DDChangeMarker-0x" + Integer.toHexString(this.hashCode());
        }
    }
}

