/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support.oldconfig;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.ObjectNames;
import com.sun.enterprise.management.support.OldTypeToJ2EETypeMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public final class OldProps {
    private final ObjectName mObjectName;
    private final Map mValues;
    private static final String SERVER_CONFIG_KEY = "ServerConfig";
    private static final String[] OLD_NAMES = new String[]{"name", "id", "ref", "thread-pool-id", "jndi-name", "resource-adapter-name"};

    public ObjectName getOldObjectName() {
        return this.mObjectName;
    }

    public String getNewProps() {
        return JMXUtil.mapToProps(this.mValues);
    }

    private String getOldName(ObjectName oldObjectName) {
        String oldName = null;
        for (int i = 0; i < OLD_NAMES.length && (oldName = oldObjectName.getKeyProperty(OLD_NAMES[i])) == null; ++i) {
        }
        if (oldName == null && oldObjectName.getKeyProperty("type").equals("root")) {
            oldName = oldObjectName.getKeyProperty("server");
        }
        return oldName;
    }

    private static String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    public static Set j2eeTypesToOldTypes(Set j2eeTypes, OldTypeToJ2EETypeMapper mapper) {
        Iterator iter = j2eeTypes.iterator();
        HashSet<String> old = new HashSet<String>();
        Object match = null;
        while (iter.hasNext()) {
            String j2eeType = (String)iter.next();
            String oldType = mapper.j2eeTypeToOldType(j2eeType);
            if (oldType == null) continue;
            old.add(oldType);
        }
        return old;
    }

    public OldProps(ObjectName oldObjectName, OldTypeToJ2EETypeMapper mapper) {
        this.mObjectName = oldObjectName;
        this.mValues = new HashMap();
        String j2eeType = mapper.oldObjectNameToJ2EEType(oldObjectName);
        this.mValues.put("j2eeType", j2eeType);
        String oldName = this.getOldName(oldObjectName);
        String name = oldName != null ? oldName : ObjectNames.getSingletonName(j2eeType);
        this.mValues.put("name", name);
        Iterator<String> iter = oldObjectName.getKeyPropertyList().keySet().iterator();
        while (iter.hasNext()) {
            String prop = iter.next();
            String newType = mapper.oldTypeToJ2EEType(prop, oldObjectName);
            if (newType == null) continue;
            this.mValues.put(newType, oldObjectName.getKeyProperty(prop));
        }
        if (j2eeType.equals("X-JMXConnectorConfig")) {
            if (this.mValues.containsKey("X-ConfigConfig")) {
                this.mValues.put("X-AdminServiceConfig", ObjectNames.getSingletonName("X-AdminServiceConfig"));
            } else if (!this.mValues.containsKey("X-NodeAgentConfig")) {
                throw new IllegalArgumentException("unrecognized ObjectName for jmx-connector");
            }
        } else if (j2eeType.equals("X-SSLConfig")) {
            if (this.mValues.containsKey("X-NodeAgentConfig")) {
                this.mValues.put("X-JMXConnectorConfig", ObjectNames.getSingletonName("X-JMXConnectorConfig"));
            } else if (this.mValues.containsKey("X-JMXConnectorConfig")) {
                this.mValues.put("X-AdminServiceConfig", ObjectNames.getSingletonName("X-AdminServiceConfig"));
            } else if (this.mValues.containsKey("X-ConfigConfig") && !this.mValues.containsKey("X-HTTPListenerConfig") && !this.mValues.containsKey("X-IIOPListenerConfig")) {
                this.mValues.put("X-IIOPServiceConfig", ObjectNames.getSingletonName("X-IIOPServiceConfig"));
            }
        } else if (j2eeType.equals("X-AuthRealmConfig")) {
            if (this.mValues.containsKey("X-ConfigConfig")) {
                this.mValues.put("X-SecurityServiceConfig", ObjectNames.getSingletonName("X-SecurityServiceConfig"));
            } else if (!this.mValues.containsKey("X-NodeAgentConfig")) {
                throw new IllegalArgumentException("unrecognized ObjectName for ssl or jmx-connector");
            }
        }
    }
}

