/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.misc.StringUtil;

public final class WebModuleSupport {
    public static final String VIRTUAL_SERVER_PREFIX = "//";
    public static final String VIRTUAL_SERVER_DELIM = "/";

    private WebModuleSupport() {
    }

    public static boolean isLegalVirtualServerName(String candidate) {
        return !candidate.startsWith(VIRTUAL_SERVER_PREFIX) && candidate.indexOf(VIRTUAL_SERVER_DELIM) < 0;
    }

    public static String formCompositeName(String virtualServerName, String moduleName) {
        return VIRTUAL_SERVER_PREFIX + virtualServerName + VIRTUAL_SERVER_DELIM + moduleName;
    }

    public static String extractVirtualServerName(String compositeName) {
        if (!compositeName.startsWith(VIRTUAL_SERVER_PREFIX)) {
            throw new IllegalArgumentException(compositeName);
        }
        String temp = StringUtil.stripPrefix(compositeName, VIRTUAL_SERVER_PREFIX);
        int delimIdx = temp.indexOf(VIRTUAL_SERVER_DELIM);
        String virtualServerName = temp.substring(0, delimIdx);
        return virtualServerName;
    }

    public static String extractWebModuleName(String compositeName) {
        String prefix = VIRTUAL_SERVER_PREFIX + WebModuleSupport.extractVirtualServerName(compositeName) + VIRTUAL_SERVER_DELIM;
        return compositeName.substring(prefix.length(), compositeName.length());
    }
}

