/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.SystemInfo;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.support.AMXImplBase;
import com.sun.enterprise.management.support.BootUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class SystemInfoImpl
extends AMXImplBase
implements SystemInfo {
    private final MBeanServer mServer;
    private BootUtil mBootUtil;
    public static final String NAME_PROP_VALUE = "system-info";
    private final Map mFeatures;
    private static final String[] FEATURE_NAMES = new String[]{"SupportsClusters", "SupportsMultipleServers", "RunningInDomainAdminServer"};

    private final boolean supportsClusters() {
        ObjectName serversObjectName = this.getOldServersMBeanObjectName();
        boolean supportsClusters = false;
        if (serversObjectName != null) {
            try {
                MBeanInfo info = this.mServer.getMBeanInfo(serversObjectName);
                String operationName = "listUnclusteredServerInstancesAsString";
                Set operations = JMXUtil.findInfoByName(info.getOperations(), "listUnclusteredServerInstancesAsString");
                supportsClusters = operations.size() != 0;
            }
            catch (JMException e) {
                throw new RuntimeException("problem with 'servers' MBean: " + serversObjectName, e);
            }
        } else {
            supportsClusters = true;
        }
        return supportsClusters;
    }

    private ObjectName getOldServersMBeanObjectName() {
        ObjectName pattern = Util.newObjectName("com.sun.appserv", "category=config,type=servers");
        Set<ObjectName> serversSet = this.mServer.queryNames(pattern, null);
        ObjectName objectName = serversSet.size() == 0 ? null : (ObjectName)SetUtil.getSingleton(serversSet);
        return objectName;
    }

    private boolean isRunningInDomainAdminServer() {
        return this.getOldServersMBeanObjectName() != null;
    }

    public SystemInfoImpl(MBeanServer server, BootUtil bootUtil) {
        this.mServer = server;
        this.mBootUtil = bootUtil;
        this.mFeatures = new HashMap();
        boolean supportsClusters = this.supportsClusters();
        this.mFeatures.put("SupportsClusters", supportsClusters);
        this.mFeatures.put("SupportsMultipleServers", supportsClusters);
        this.mFeatures.put("RunningInDomainAdminServer", this.isRunningInDomainAdminServer());
    }

    public final String getGroup() {
        return "utility";
    }

    public String[] getFeatureNames() {
        return (String[])FEATURE_NAMES.clone();
    }

    public boolean supportsFeature(String key) {
        boolean supports = false;
        Boolean result = (Boolean)this.mFeatures.get(key);
        if (result == null) {
            result = Boolean.FALSE;
        }
        return result;
    }
}

