/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.TypeInfo;
import com.sun.enterprise.management.support.TypeInfos;
import java.util.Collections;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class ObjectNames {
    private final String mJMXDomain;
    private static final String[] EMPTY_STRING_ARRAY;
    public static final String MISSING_PARENT_NAME = "null";
    static final /* synthetic */ boolean $assertionsDisabled;

    private ObjectNames(String jmxDomain) {
        this.mJMXDomain = jmxDomain;
    }

    public static ObjectNames getInstance(String jmxDomain) {
        return new ObjectNames(jmxDomain);
    }

    public String getJMXDomain() {
        return this.mJMXDomain;
    }

    public static String getJ2EEType(Class theInterface) {
        return (String)ClassUtil.getFieldValue(theInterface, "J2EE_TYPE");
    }

    private ObjectName newObjectName(String props) {
        return Util.newObjectName(this.getJMXDomain(), props);
    }

    public static String makeWild(String props) {
        return Util.concatenateProps(props, ",*");
    }

    public ObjectName buildContaineeObjectName(ObjectName parentObjectName, String parentFullType, String childJ2EEType, String childName) {
        String domain = parentObjectName.getDomain();
        String props = "";
        TypeInfo info = TypeInfos.getInstance().getInfo(childJ2EEType);
        if (info.isSubType()) {
            String parentProp = Util.getSelfProp(parentObjectName);
            Object[] parentFullTypes = Util.getTypeArray(parentFullType);
            Set ancestorKeys = SetUtil.newSet(parentFullTypes, 0, parentFullTypes.length - 1);
            String ancestorProps = JMXUtil.getProps(parentObjectName, ancestorKeys, true);
            props = Util.concatenateProps(parentProp, ancestorProps);
        }
        String requiredProps = Util.makeRequiredProps(childJ2EEType, childName);
        String allProps = Util.concatenateProps(requiredProps, props);
        return Util.newObjectName(domain, allProps);
    }

    public ObjectName buildContaineeObjectName(ObjectName parentObjectName, String parentFullType, String childJ2EEType) {
        String name = ObjectNames.getSingletonName(childJ2EEType);
        return this.buildContaineeObjectName(parentObjectName, parentFullType, childJ2EEType, name);
    }

    public ObjectName getDomainRootObjectName() {
        return this.newObjectName(Util.makeRequiredProps("X-DomainRoot", this.getJMXDomain()));
    }

    public ObjectName getSingletonObjectName(String j2eeType) {
        TypeInfo info = TypeInfos.getInstance().getInfo(j2eeType);
        if (info.isSubType()) {
            throw new IllegalArgumentException("singletons may not be sub-types: " + j2eeType);
        }
        String props = Util.makeRequiredProps(j2eeType, ObjectNames.getSingletonName(j2eeType));
        return this.newObjectName(props);
    }

    public static String getSingletonName(String j2eeType) {
        if (TypeInfos.getInstance().getInfo(j2eeType) == null) {
            throw new IllegalArgumentException(j2eeType);
        }
        if (!$assertionsDisabled && "na".equals(MISSING_PARENT_NAME)) {
            throw new AssertionError();
        }
        return "na";
    }

    public ObjectName getContainerObjectNamePattern(ObjectName childObjectName, String childFullType) {
        ObjectName parentPattern = null;
        String domain = childObjectName.getDomain();
        Object[] fullType = Util.getTypeArray(childFullType);
        if (!$assertionsDisabled && fullType.length < 1) {
            throw new AssertionError();
        }
        String childType = fullType[fullType.length - 1];
        if (fullType.length == 1) {
            TypeInfo info = TypeInfos.getInstance().getInfo(childType);
            String containedByJ2EEType = info.getContainedByJ2EEType();
            if (containedByJ2EEType != null) {
                String parentProps = "";
                parentProps = containedByJ2EEType.equals("X-DomainRoot") || containedByJ2EEType.equals("J2EEDomain") ? Util.makeRequiredProps(containedByJ2EEType, domain) : Util.makeRequiredProps(containedByJ2EEType, ObjectNames.getSingletonName(containedByJ2EEType));
                parentPattern = Util.newObjectNamePattern(domain, parentProps);
            } else {
                parentPattern = null;
            }
        } else {
            String parentJ2EEType = null;
            String parentName = null;
            Set remainingKeys = Collections.EMPTY_SET;
            for (int i = fullType.length - 2; i >= 0; --i) {
                String tempType = fullType[i];
                String tempName = childObjectName.getKeyProperty(tempType);
                if (!$assertionsDisabled && tempName == null) {
                    throw new AssertionError((Object)("missing ObjectName property: " + tempType));
                }
                if (MISSING_PARENT_NAME.equals(tempName)) continue;
                parentJ2EEType = tempType;
                parentName = tempName;
                int numItems = i;
                remainingKeys = SetUtil.newSet(fullType, 0, numItems);
                break;
            }
            String parentProps = Util.makeRequiredProps(parentJ2EEType, parentName);
            String ancestorProps = JMXUtil.getProps(childObjectName, remainingKeys);
            String props = Util.concatenateProps(parentProps, ancestorProps);
            parentPattern = Util.newObjectNamePattern(domain, props);
        }
        return parentPattern;
    }

    private static String getFullType(MBeanServer server, ObjectName objectName) {
        try {
            String fullType = (String)server.getAttribute(objectName, "FullType");
            return fullType;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectName getContainerObjectName(MBeanServer server, ObjectName containedObjectName) throws InstanceNotFoundException {
        String containedFullType = ObjectNames.getFullType(server, containedObjectName);
        ObjectName parentPattern = this.getContainerObjectNamePattern(containedObjectName, containedFullType);
        ObjectName containingObjectName = null;
        if (parentPattern != null) {
            Set<ObjectName> names = server.queryNames(parentPattern, null);
            if (names.size() == 0) {
                throw new InstanceNotFoundException(parentPattern.toString());
            }
            containingObjectName = (ObjectName)SetUtil.getSingleton(names);
        } else {
            String j2eeType = Util.getJ2EEType(containedObjectName);
            if (!j2eeType.equals("X-DomainRoot")) {
                throw new IllegalArgumentException(containedObjectName.toString());
            }
        }
        return containingObjectName;
    }

    private static String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    static {
        $assertionsDisabled = !ObjectNames.class.desiredAssertionStatus();
        EMPTY_STRING_ARRAY = new String[0];
    }
}

