/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.enterprise.management.support.AMXImplBase;
import com.sun.enterprise.management.support.NotificationServiceImpl;
import com.sun.enterprise.management.support.UniqueIDGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class NotificationServiceMgrImpl
extends AMXImplBase
implements NotificationListener {
    private final Map mServices = Collections.synchronizedMap(new HashMap());
    private final UniqueIDGenerator mUniqueIDs = new UniqueIDGenerator("notif-service-");

    public void handleNotification(Notification notifIn, Object handback) {
        MBeanServerNotification notif;
        ObjectName objectName;
        String type = notifIn.getType();
        if (type.equals("JMX.mbean.unregistered") && Util.getJ2EEType(objectName = (notif = (MBeanServerNotification)notifIn).getMBeanName()).equals("X-NotificationService")) {
            this.mServices.remove(objectName);
        }
    }

    public String getGroup() {
        return "utility";
    }

    public Map getNotificationServiceObjectNameMap() {
        return this.getContaineeObjectNameMap("X-NotificationService");
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ObjectName myName = super.preRegister(server, name);
        JMXUtil.listenToMBeanServerDelegate(server, this, null, null);
        return myName;
    }

    public ObjectName createNotificationService(Object userData, int bufferSize) {
        NotificationServiceImpl service = new NotificationServiceImpl(userData, bufferSize);
        ObjectName self = this.getObjectName();
        String domain = self.getDomain();
        String childName = this.mUniqueIDs.createID().toString();
        String requiredProps = Util.makeRequiredProps("X-NotificationService", childName);
        ObjectName tempName = JMXUtil.newObjectName(domain, requiredProps);
        ObjectName objectName = null;
        try {
            objectName = this.registerMBean(service, tempName);
            this.mServices.put(objectName, service);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return objectName;
    }

    public ObjectName getNotificationServiceObjectName(String name) {
        return this.getContaineeObjectName("X-NotificationService", name);
    }

    public synchronized void removeNotificationService(String name) throws InstanceNotFoundException {
        ObjectName objectName = this.getNotificationServiceObjectName(name);
        if (objectName == null) {
            throw new IllegalArgumentException(name);
        }
        if (!this.mServices.containsKey(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        try {
            this.getMBeanServer().unregisterMBean(objectName);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
        this.mServices.remove(objectName);
    }
}

