/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.AMXMBeanLogging;
import com.sun.appserv.management.util.jmx.AttributeChangeNotificationBuilder;
import com.sun.appserv.management.util.jmx.NotificationBuilder;
import com.sun.appserv.management.util.jmx.NotificationEmitterSupport;
import com.sun.appserv.management.util.jmx.NotificationSender;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.AMXMBeanLogger;
import com.sun.enterprise.management.support.AMXMBeanRootLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class MBeanImplBase
implements MBeanRegistration,
AMXMBeanLogging,
NotificationSender {
    protected MBeanServer mServer;
    protected ObjectName mSelfObjectName;
    private NotificationEmitterSupport mNotificationEmitter = null;
    protected Logger mLogger = null;
    private Map mNotificationBuilders;
    private static final Level[] LOG_LEVELS;
    protected static final boolean DEBUG = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final int getNumListeners() {
        return this.getNotificationEmitter().getNumListeners();
    }

    protected final synchronized NotificationEmitterSupport getNotificationEmitter() {
        if (this.mNotificationEmitter == null) {
            this.mNotificationEmitter = new NotificationEmitterSupport(true);
            this.mNotificationEmitter.setLogger(this.getMBeanLogger());
        }
        return this.mNotificationEmitter;
    }

    public synchronized void addNotificationListener(NotificationListener listener) {
        this.getNotificationEmitter().addNotificationListener(listener, null, null);
    }

    public synchronized void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.getNotificationEmitter().addNotificationListener(listener, filter, handback);
    }

    public synchronized void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.getNotificationEmitter().removeNotificationListener(listener);
    }

    public synchronized void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.getNotificationEmitter().removeNotificationListener(listener, filter, handback);
    }

    public void sendNotification(Notification notification) {
        this.getNotificationEmitter().sendNotification(notification);
    }

    protected NotificationBuilder createNotificationBuilder(String notificationType) {
        NotificationBuilder builder = null;
        builder = notificationType.equals("jmx.attribute.change") ? new AttributeChangeNotificationBuilder(this.getObjectName()) : new NotificationBuilder(notificationType, this.getObjectName());
        return builder;
    }

    protected synchronized NotificationBuilder getNotificationBuilder(String notificationType) {
        NotificationBuilder builder;
        if (this.mNotificationBuilders == null) {
            this.mNotificationBuilders = new HashMap();
        }
        if ((builder = (NotificationBuilder)this.mNotificationBuilders.get(notificationType)) == null) {
            builder = this.createNotificationBuilder(notificationType);
            this.mNotificationBuilders.put(notificationType, builder);
        }
        return builder;
    }

    protected void sendNotification(String notificationType) {
        this.sendNotification(notificationType, null, null);
    }

    protected void sendNotification(String notificationType, String key, Object value) {
        NotificationBuilder builder = this.getNotificationBuilder(notificationType);
        Notification notif = builder.buildNew(key, value);
        this.sendNotification(notif);
    }

    public final ObjectName getObjectName() {
        return this.mSelfObjectName;
    }

    public String getJMXDomain() {
        return this.getObjectName().getDomain();
    }

    public final MBeanServer getMBeanServer() {
        return this.mServer;
    }

    protected static String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    protected final void trace(Object o) {
        if (this.getMBeanLogLevelInt() <= Level.FINER.intValue()) {
            this.getMBeanLogger().finer(MBeanImplBase.toString(o));
        }
    }

    protected final void logSevere(Object o) {
        if (this.getMBeanLogLevelInt() <= Level.SEVERE.intValue()) {
            this.getMBeanLogger().severe(MBeanImplBase.toString(o));
        }
    }

    protected final void logWarning(Object o) {
        if (this.getMBeanLogLevelInt() <= Level.WARNING.intValue()) {
            this.getMBeanLogger().warning(MBeanImplBase.toString(o));
        }
    }

    protected final void logInfo(Object o) {
        if (this.getMBeanLogLevelInt() <= Level.INFO.intValue()) {
            this.getMBeanLogger().info(MBeanImplBase.toString(o));
        }
    }

    protected final void logFine(Object o) {
        if (this.getMBeanLogLevelInt() <= Level.FINE.intValue()) {
            this.getMBeanLogger().fine(MBeanImplBase.toString(o));
        }
    }

    protected final void logFiner(Object o) {
        if (this.getMBeanLogLevelInt() <= Level.FINER.intValue()) {
            this.getMBeanLogger().finer(MBeanImplBase.toString(o));
        }
    }

    protected final void logFinest(Object o) {
        if (this.getMBeanLogLevelInt() <= Level.FINEST.intValue()) {
            this.getMBeanLogger().finest(MBeanImplBase.toString(o));
        }
    }

    protected final Logger getMBeanLogger() {
        Logger logger = this.mLogger;
        if (logger == null) {
            logger = AMXMBeanRootLogger.getInstance();
        }
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        return logger;
    }

    public final Level getMBeanLogLevel() {
        Logger logger = this.getMBeanLogger();
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        Level level = logger.getLevel();
        while (level == null) {
            logger = logger.getParent();
            level = logger.getLevel();
        }
        return level;
    }

    public final void setMBeanLogLevel(Level level) {
        this.getMBeanLogger().setLevel(level);
    }

    protected final int getMBeanLogLevelInt() {
        return this.getMBeanLogLevel().intValue();
    }

    public final String getMBeanLoggerName() {
        return this.getMBeanLogger().getName();
    }

    public final void setMBeanLogLevelString(String levelString) {
        Level level = null;
        for (int i = 0; i < LOG_LEVELS.length; ++i) {
            if (!levelString.equals(LOG_LEVELS[i].getName())) continue;
            level = LOG_LEVELS[i];
            break;
        }
        if (level == null) {
            throw new IllegalArgumentException(levelString);
        }
        this.setMBeanLogLevel(level);
    }

    public boolean getMBeanEmitLogNotifications() {
        return false;
    }

    public void setMBeanEmitLogNotifications(boolean emit) {
        throw new IllegalArgumentException("not supported yet: EmitLogNotifications");
    }

    protected static String quote(Object o) {
        return StringUtil.quote(o.toString());
    }

    public ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        this.mServer = server;
        this.mSelfObjectName = nameIn;
        return this.mSelfObjectName;
    }

    protected Logger createLogger() {
        return AMXMBeanLogger.createNew(this.getObjectName());
    }

    public void postRegister(Boolean registrationDone) {
        if (this.mLogger == null) {
            this.mLogger = this.createLogger();
        }
        if (registrationDone.booleanValue()) {
            this.getMBeanLogger().finest("postRegister: " + this.getObjectName());
        } else {
            this.getMBeanLogger().finest("postRegister: FAILURE: " + this.getObjectName());
        }
    }

    public void preDeregister() throws Exception {
        this.getMBeanLogger().finest("preDeregister: " + this.getObjectName());
    }

    public void postDeregister() {
        this.getMBeanLogger().finest("postDeregister: " + this.getObjectName());
        if (this.mNotificationEmitter != null) {
            this.mNotificationEmitter.cleanup();
            this.mNotificationEmitter = null;
        }
        if (this.mNotificationBuilders != null) {
            this.mNotificationBuilders.clear();
            this.mNotificationBuilders = null;
        }
        this.mLogger = null;
        this.mServer = null;
        this.mSelfObjectName = null;
    }

    protected void debug(Object o) {
    }

    static {
        $assertionsDisabled = !MBeanImplBase.class.desiredAssertionStatus();
        LOG_LEVELS = new Level[]{Level.ALL, Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINER, Level.FINEST, Level.OFF};
    }
}

