/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import com.sun.enterprise.management.support.DeferRegistrationException;
import com.sun.enterprise.management.support.Loader;
import com.sun.enterprise.management.support.LoaderOfOld;
import com.sun.enterprise.management.support.OldMonitorTypes;
import com.sun.enterprise.management.support.OldTypeToJ2EETypeMapper;
import com.sun.enterprise.management.support.TypeInfos;
import com.sun.enterprise.management.support.oldconfig.OldProps;
import java.util.Collections;
import java.util.Set;
import javax.management.ObjectName;

final class LoaderOfOldMonitor
extends LoaderOfOld {
    private static final Set IGNORE_TYPES;
    private static final Set NEEDS_SUPPORT;
    static final /* synthetic */ boolean $assertionsDisabled;

    LoaderOfOldMonitor(Loader loader) {
        super(loader);
    }

    public Set findAllOldCandidates() {
        ObjectName pattern = JMXUtil.newObjectName("com.sun.appserv:category=monitor,*");
        Set<ObjectName> all = this.getMBeanServer().queryNames(pattern, null);
        return all;
    }

    private static void mySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final String getWebModuleName(ObjectName oldObjectName) {
        String webModule;
        String temp1 = oldObjectName.getKeyProperty("web-module");
        String temp2 = oldObjectName.getKeyProperty("standalone-web-module");
        String string = webModule = temp1 != null ? temp1 : temp2;
        if (!$assertionsDisabled && webModule == null) {
            throw new AssertionError();
        }
        webModule = StringUtil.stripSuffix(webModule, ".war");
        return webModule;
    }

    private final String formCompositeName(String virtualServerName, String webModuleName) {
        String compositeName = "//" + virtualServerName + "/" + webModuleName;
        return compositeName;
    }

    private final String formApplicationAndServerProps(ObjectName oldObjectName) {
        String serverProp;
        String serverName = oldObjectName.getKeyProperty("server");
        String props = serverProp = Util.makeProp("X-ServerRootMonitor", serverName);
        String applicationName = oldObjectName.getKeyProperty("application");
        if (applicationName == null) {
            applicationName = "null";
        }
        String applicationProp = Util.makeProp("X-ApplicationMonitor", applicationName);
        props = Util.concatenateProps(props, applicationProp);
        return props;
    }

    protected ObjectName oldToNewObjectName(ObjectName oldObjectName) {
        String oldType = oldObjectName.getKeyProperty("type");
        String domainName = this.mLoader.getAMXJMXDomainName();
        ObjectName newObjectName = null;
        if (oldType.equals("webmodule-virtual-server")) {
            String virtualServerName = oldObjectName.getKeyProperty("name");
            String webModuleName = this.getWebModuleName(oldObjectName);
            String compositeName = this.formCompositeName(virtualServerName, webModuleName);
            String requiredProps = Util.makeRequiredProps("X-WebModuleVirtualServerMonitor", compositeName);
            String containmentProps = this.formApplicationAndServerProps(oldObjectName);
            String props = Util.concatenateProps(requiredProps, containmentProps);
            newObjectName = JMXUtil.newObjectName(domainName, props);
        } else if (oldType.equals("servlet")) {
            String virtualServerName = oldObjectName.getKeyProperty("webmodule-virtual-server");
            String webModuleName = this.getWebModuleName(oldObjectName);
            String vsMonitorCompositeName = this.formCompositeName(virtualServerName, webModuleName);
            String requiredProps = Util.makeRequiredProps("X-ServletMonitor", oldObjectName.getKeyProperty("name"));
            String virtualServerProp = Util.makeProp("X-WebModuleVirtualServerMonitor", vsMonitorCompositeName);
            String containmentProps = this.formApplicationAndServerProps(oldObjectName);
            String props = Util.concatenateProps(requiredProps, virtualServerProp, containmentProps);
            newObjectName = JMXUtil.newObjectName(domainName, props);
        } else {
            MyOldTypes mapper = new MyOldTypes();
            OldProps oldProps = new OldProps(oldObjectName, mapper);
            String props = oldProps.getNewProps();
            newObjectName = JMXUtil.newObjectName(domainName, props);
            String j2eeType = newObjectName.getKeyProperty("j2eeType");
            String[] fullType = TypeInfos.getInstance().getJ2EETypeChain(newObjectName);
            for (int i = 0; i < fullType.length - 1; ++i) {
                if (!fullType[i].equals("X-ApplicationMonitor") || newObjectName.getKeyProperty("X-ApplicationMonitor") != null) continue;
                String prop = Util.makeProp("X-ApplicationMonitor", "null");
                newObjectName = JMXUtil.newObjectName(newObjectName, prop);
                break;
            }
        }
        return newObjectName;
    }

    private boolean isOldMonitorObjectName(ObjectName objectName) {
        boolean isOldMonitor = false;
        if (objectName.getDomain().equals("com.sun.appserv") && "monitor".equals(objectName.getKeyProperty("category"))) {
            String type = objectName.getKeyProperty("type");
            isOldMonitor = !this.getIgnoreTypes().contains(type);
        }
        return isOldMonitor;
    }

    protected Set getNeedsSupport() {
        return NEEDS_SUPPORT;
    }

    protected Set getIgnoreTypes() {
        return IGNORE_TYPES;
    }

    public boolean isOldMBean(ObjectName oldObjectName) {
        return this.isOldMonitorObjectName(oldObjectName);
    }

    static {
        $assertionsDisabled = !LoaderOfOldMonitor.class.desiredAssertionStatus();
        IGNORE_TYPES = Collections.unmodifiableSet(SetUtil.newSet(new String[]{"connection-factories", "connector-modules", "connector-service", "connection-factory", "connection-pools", "resources", "thread-pools", "applications", "orb", "connection-managers", "bean-methods", "web-module", "standalone-web-module", "operating-system", "threadinfo", "memory", "thread-system", "garbage-collectors", "garbage-collector", "runtime", "compilation-system", "class-loading-system"}));
        NEEDS_SUPPORT = Collections.unmodifiableSet(SetUtil.newSet(new String[]{"jms-service", "jndi"}));
    }

    private final class MyOldTypes
    implements OldTypeToJ2EETypeMapper {
        private final OldMonitorTypes mOldTypes = OldMonitorTypes.getInstance();
        static final /* synthetic */ boolean $assertionsDisabled;

        public String j2eeTypeToOldType(String j2eeType) {
            String result = null;
            result = j2eeType.endsWith("BeanMonitor") ? "ejb" : this.mOldTypes.j2eeTypeToOldType(j2eeType);
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String oldTypeToJ2EEType(String oldType, ObjectName oldObjectName) {
            String j2eeType = null;
            String EJB2 = "ejb";
            if (!oldType.equals("ejb")) return this.mOldTypes.oldTypeToJ2EEType(oldType, oldObjectName);
            if (oldObjectName.getKeyProperty("type").equals("ejb")) {
                Object[] statisticNames = null;
                try {
                    statisticNames = (String[])LoaderOfOldMonitor.this.getMBeanServer().invoke(oldObjectName, "getStatisticNames", null, null);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't invoke getStatisticNames() on " + oldObjectName, e);
                }
                Set names = SetUtil.newSet(statisticNames);
                if (!$assertionsDisabled && !names.contains("CreateCount")) {
                    throw new AssertionError((Object)("MBean " + oldObjectName + " does not contain 'RemoveCount' as a Statistic name: all = " + ArrayStringifier.stringify(statisticNames, ", ")));
                }
                if (!$assertionsDisabled && !names.contains("RemoveCount")) {
                    throw new AssertionError();
                }
                if (names.contains("MethodReadyCount")) {
                    if (!names.contains("PassiveCount")) return "X-StatelessSessionBeanMonitor";
                    return "X-StatefulSessionBeanMonitor";
                }
                if (names.contains("MessageCount")) {
                    return "X-MessageDrivenBeanMonitor";
                }
                if (!names.contains("ReadyCount")) throw new RuntimeException("Unknown type of ejb monitor: " + oldObjectName);
                if (!names.contains("PooledCount")) throw new RuntimeException("Unknown type of ejb monitor: " + oldObjectName);
                return "X-EntityBeanMonitor";
            }
            String parentName = oldObjectName.getKeyProperty("ejb");
            String parentModuleName = oldObjectName.getKeyProperty("ejb-module");
            String serverName = oldObjectName.getKeyProperty("server");
            String applicationName = oldObjectName.getKeyProperty("application");
            String parentTypeProp = Util.makeProp("type", "ejb");
            String parentNameProp = Util.makeProp("name", parentName);
            String parentModuleNameProp = Util.makeProp("ejb-module", parentModuleName);
            String parentProps = Util.concatenateProps(parentTypeProp, parentNameProp, parentModuleNameProp);
            String serverProp = Util.makeProp("server", serverName);
            String props = Util.concatenateProps(serverProp, parentProps, "category=monitor");
            if (applicationName != null) {
                String applicationProp = Util.makeProp("application", applicationName);
                props = Util.concatenateProps(props, applicationProp);
            }
            ObjectName pattern = JMXUtil.newObjectNamePattern("com.sun.appserv", props);
            Set<ObjectName> candidates = LoaderOfOldMonitor.this.getMBeanServer().queryNames(pattern, null);
            if (candidates.size() == 0) {
                LoaderOfOldMonitor.this.getLogger().fine("Can't find MBean for pattern " + StringUtil.quote(pattern) + " corresponding to " + StringUtil.quote(oldObjectName));
                throw new RuntimeException(new DeferRegistrationException(pattern));
            }
            ObjectName beanObjectName = (ObjectName)SetUtil.getSingleton(candidates);
            return this.oldTypeToJ2EEType("ejb", beanObjectName);
        }

        public String oldObjectNameToJ2EEType(ObjectName oldObjectName) {
            String oldType = oldObjectName.getKeyProperty("type");
            return this.oldTypeToJ2EEType(oldType, oldObjectName);
        }

        static {
            $assertionsDisabled = !(class$com$sun$enterprise$management$support$LoaderOfOldMonitor == null ? (class$com$sun$enterprise$management$support$LoaderOfOldMonitor = LoaderOfOldMonitor.class$("com.sun.enterprise.management.support.LoaderOfOldMonitor")) : class$com$sun$enterprise$management$support$LoaderOfOldMonitor).desiredAssertionStatus();
        }
    }
}

