/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.management.support.AMXImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.OldPropertiesImpl;
import com.sun.enterprise.management.support.OldSystemPropertiesImpl;
import com.sun.enterprise.management.support.oldconfig.OldProperties;
import com.sun.enterprise.management.support.oldconfig.OldSystemProperties;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;

public class AMXConfigImplBase
extends AMXImplBase
implements AMXConfig {
    protected AMXConfigImplBase(Delegate delegate) {
        super(delegate);
    }

    private static void validatePropertyName(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Illegal property name: " + StringUtil.quote(propertyName));
        }
    }

    protected OldSystemProperties getOldSystemProperties() {
        if (!this.haveDelegate()) {
            String msg = "system properties not supported (no delegate) by " + AMXConfigImplBase.quote(this.getObjectName());
            throw new IllegalArgumentException(msg);
        }
        return new OldSystemPropertiesImpl(this.getDelegate());
    }

    public Map getSystemProperties() {
        AttributeList props = this.getOldSystemProperties().getSystemProperties();
        Map result = JMXUtil.attributeListToValueMap(props);
        return result;
    }

    public String[] getSystemPropertyNames() {
        Set names = this.getSystemProperties().keySet();
        return SetUtil.toStringArray(names);
    }

    public String getSystemPropertyValue(String propertyName) {
        return this.getOldSystemProperties().getSystemPropertyValue(propertyName);
    }

    public final void setSystemPropertyValue(String propertyName, String propertyValue) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        if (propertyValue == null) {
            throw new IllegalArgumentException("null");
        }
        Attribute attr = new Attribute(propertyName, propertyValue);
        this.getOldSystemProperties().setSystemProperty(attr);
    }

    public final boolean existsSystemProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        return SetUtil.newSet(this.getSystemPropertyNames()).contains(propertyName);
    }

    public final void removeSystemProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        this.getOldSystemProperties().setSystemProperty(new Attribute(propertyName, null));
    }

    public final void createSystemProperty(String propertyName, String propertyValue) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        this.setSystemPropertyValue(propertyName, propertyValue);
    }

    protected OldProperties getOldProperties() {
        if (!this.haveDelegate()) {
            String msg = "properties not supported (no delegate) by " + AMXConfigImplBase.quote(this.getObjectName());
            throw new IllegalArgumentException(msg);
        }
        return new OldPropertiesImpl(this.getDelegate());
    }

    public Map getProperties() {
        AttributeList props = this.getOldProperties().getProperties();
        return JMXUtil.attributeListToValueMap(props);
    }

    public String[] getPropertyNames() {
        Set names = this.getProperties().keySet();
        return SetUtil.toStringArray(names);
    }

    public String getPropertyValue(String propertyName) {
        return this.getOldProperties().getPropertyValue(propertyName);
    }

    public final void setPropertyValue(String propertyName, String propertyValue) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        if (propertyValue == null) {
            throw new IllegalArgumentException("null");
        }
        Attribute attr = new Attribute(propertyName, propertyValue);
        this.getOldProperties().setProperty(attr);
    }

    public final boolean existsProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        return SetUtil.newSet(this.getPropertyNames()).contains(propertyName);
    }

    public final void removeProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        this.getOldProperties().setProperty(new Attribute(propertyName, null));
    }

    public final void createProperty(String propertyName, String propertyValue) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        this.setPropertyValue(propertyName, propertyValue);
    }

    public final String getGroup() {
        return "configuration";
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo superMBeanInfo = super.getMBeanInfo();
        String description = "";
        String[] notifTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo attributeChange = new MBeanNotificationInfo(notifTypes, AttributeChangeNotification.class.getName(), "");
        MBeanNotificationInfo[] selfInfos = new MBeanNotificationInfo[]{attributeChange};
        MBeanNotificationInfo[] notificationInfos = this.mergeNotificationInfos(super.getNotificationInfo(), selfInfos);
        MBeanInfo mbeanInfo = new MBeanInfo(superMBeanInfo.getClassName(), superMBeanInfo.getDescription(), superMBeanInfo.getAttributes(), superMBeanInfo.getConstructors(), superMBeanInfo.getOperations(), notificationInfos);
        return mbeanInfo;
    }
}

