/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.monitor;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.monitor.AMXCounterMonitorImpl;
import com.sun.enterprise.management.monitor.AMXGaugeMonitorImpl;
import com.sun.enterprise.management.monitor.AMXStringMonitorImpl;
import com.sun.enterprise.management.support.AMXImplBase;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;

public final class JMXMonitorMgrImpl
extends AMXImplBase {
    private static final Set TYPES = SetUtil.newUnmodifiableSet(new String[]{"X-AMXStringMonitor"});

    public String getGroup() {
        return "utility";
    }

    private ObjectName registerMonitor(Object impl, String j2eeType, String name) {
        ObjectName self = this.getObjectName();
        String domain = self.getDomain();
        String requiredProps = Util.makeRequiredProps(j2eeType, name);
        ObjectName objectName = Util.newObjectName(domain, requiredProps);
        try {
            objectName = this.registerMBean(impl, objectName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return objectName;
    }

    public ObjectName createStringMonitor(String name) {
        AMXStringMonitorImpl monitor = new AMXStringMonitorImpl();
        return this.registerMonitor(monitor, "X-AMXStringMonitor", name);
    }

    public ObjectName createCounterMonitor(String name) {
        AMXCounterMonitorImpl monitor = new AMXCounterMonitorImpl();
        return this.registerMonitor(monitor, "X-AMXCounterMonitor", name);
    }

    public ObjectName createGaugeMonitor(String name) {
        AMXGaugeMonitorImpl monitor = new AMXGaugeMonitorImpl();
        return this.registerMonitor(monitor, "X-AMXGaugeMonitor", name);
    }

    private Map getMap(String j2eeType) {
        Map m = this.getDomainRoot().getContaineeMap(j2eeType);
        return Util.toObjectNames(m);
    }

    public Map getStringMonitorObjectNameMap() {
        return this.getMap("X-AMXStringMonitor");
    }

    public Map getCounterMonitorObjectNameMap() {
        return this.getMap("X-AMXCounterMonitor");
    }

    public Map getGaugeMonitorObjectNameMap() {
        return this.getMap("X-AMXGaugeMonitor");
    }

    private ObjectName getMonitor(String name) {
        Set s = this.getDomainRoot().getByNameContaineeSet(TYPES, name);
        AMX mon = (AMX)SetUtil.getSingleton(s);
        return Util.getObjectName(mon);
    }

    public void remove(String name) {
        ObjectName objectName = this.getMonitor(name);
        if (objectName == null) {
            throw new IllegalArgumentException(name);
        }
        try {
            this.getMBeanServer().unregisterMBean(objectName);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }
}

