/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.j2ee;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.util.jmx.AttributeNameMapper;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.support.AMXNonConfigImplBase;
import com.sun.enterprise.management.support.Delegate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;

public abstract class J2EEManagedObjectImplBase
extends AMXNonConfigImplBase {
    protected long mStartTime = 0L;
    private static final Map ToConfigMap = MapUtil.newMap(new String[]{"J2EEDomain", "X-DomainConfig", "X-J2EECluster", "X-ClusterConfig", "J2EEServer", "X-StandaloneServerConfig", "JVM", "X-JavaConfig", "J2EEApplication", "X-J2EEApplicationConfig", "EJBModule", "X-EJBModuleConfig", "WebModule", "X-WebModuleConfig", "AppClientModule", "X-AppClientModuleConfig", "JavaMailResource", "X-MailResourceConfig", "JDBCResource", "X-JDBCResourceConfig", "JMSResource", "X-JMSResourceConfig", "JNDIResource", "X-JNDIResourceConfig"});
    private final Map MON_MAP = Collections.unmodifiableMap(MapUtil.newMap(new String[]{"J2EEServer", "X-ServerRootMonitor", "J2EEApplication", "X-ApplicationMonitor", "WebModule", "X-WebModuleVirtualServerMonitor", "Servlet", "X-ServletMonitor", "EJBModule", "X-EJBModuleMonitor", "StatelessSessionBean", "X-StatelessSessionBeanMonitor", "StatefulSessionBean", "X-StatefulSessionBeanMonitor", "EntityBean", "X-EntityBeanMonitor", "MessageDrivenBean", "X-MessageDrivenBeanMonitor"}));
    private static final Set DEPLOYED_TYPES = Collections.unmodifiableSet(SetUtil.newSet(new String[]{"J2EEApplication", "WebModule", "EJBModule", "AppClientModule", "ResourceAdapterModule"}));

    public J2EEManagedObjectImplBase() {
        this(null);
    }

    public J2EEManagedObjectImplBase(Delegate delegate) {
        super(delegate);
    }

    protected J2EEManagedObjectImplBase(String j2eeType, Delegate delegate) {
        super(j2eeType, delegate);
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (registrationDone.booleanValue()) {
            this.mStartTime = System.currentTimeMillis();
        }
    }

    protected final void setstartTime(long startTime) {
        this.mStartTime = startTime;
    }

    public long getstartTime() {
        return this.mStartTime;
    }

    protected String getServerName() {
        return this.getObjectName().getKeyProperty("J2EEServer");
    }

    protected String getServerXType() {
        String type = null;
        String serverName = this.getServerName();
        if (serverName != null) {
            Map m = this.getDomainRoot().getDomainConfig().getServerConfigMap();
            ServerConfig serverConfig = (ServerConfig)m.get(serverName);
            type = serverConfig.getJ2EEType();
        }
        return type;
    }

    protected MBeanInfo removeUnsupported(MBeanInfo origInfo) {
        MBeanInfo result = super.removeUnsupported(origInfo);
        if (!this.isConfigProvider()) {
            result = JMXUtil.removeAttributes(result, new String[]{"ConfigPeerObjectName"});
        }
        return result;
    }

    protected Set getDontMapAttributeNames() {
        return Collections.EMPTY_SET;
    }

    protected String getConfigPeerJ2EEType() {
        String configPeerJ2EEType = (String)ToConfigMap.get(this.getSelfJ2EEType());
        return configPeerJ2EEType;
    }

    protected String getMonitoringPeerJ2EEType() {
        String monPeerJ2EEType = (String)this.MON_MAP.get(this.getSelfJ2EEType());
        return monPeerJ2EEType;
    }

    protected Map getMonitoringPeerProps(String monitorJ2EEType, String monitorName) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("j2eeType", monitorJ2EEType);
        props.put("name", monitorName);
        Iterator iter = this.MON_MAP.keySet().iterator();
        while (iter.hasNext()) {
            String j2eeType = (String)iter.next();
            String j2eeMonType = (String)this.MON_MAP.get(j2eeType);
            String name = this.getKeyProperty(j2eeType);
            if (name == null) continue;
            props.put(j2eeMonType, name);
        }
        return props;
    }

    protected Map getMonitoringPeerProps() {
        Map props = null;
        String j2eeType = this.getMonitoringPeerJ2EEType();
        if (j2eeType != null) {
            props = this.getMonitoringPeerProps(j2eeType, this.getMonitoringPeerName());
        }
        return props;
    }

    protected ObjectName queryProps(Map propsMap) {
        ObjectName objectName = null;
        String props = MapUtil.toString(propsMap, ",");
        Set candidates = this.getQueryMgr().queryPropsObjectNameSet(props);
        if (candidates.size() == 1) {
            objectName = (ObjectName)SetUtil.getSingleton(candidates);
        } else if (candidates.size() > 1) {
            throw new RuntimeException("Unexpectedly found too many candidates for query pattern " + J2EEManagedObjectImplBase.quote(props) + " found: " + J2EEManagedObjectImplBase.toString(candidates));
        }
        return objectName;
    }

    public ObjectName getMonitoringPeerObjectName() {
        ObjectName objectName = null;
        Map propsMap = this.getMonitoringPeerProps();
        if (propsMap != null && propsMap.keySet().size() != 0 && (objectName = this.queryProps(propsMap)) == null) {
            objectName = this.queryMonitoringPeerFailed(propsMap);
        }
        return objectName;
    }

    protected ObjectName queryMonitoringPeerFailed(Map propsMap) {
        return null;
    }

    protected ObjectName queryConfigPeerFailed(Map propsMap) {
        return null;
    }

    public final String getobjectName() {
        return this.getObjectName().toString();
    }

    public boolean isstatisticProvider() {
        return this.getMonitoringPeerObjectName() != null;
    }

    public boolean isstatisticsProvider() {
        return this.isstatisticProvider();
    }

    protected Stats getStatsGeneric() {
        ObjectName mon;
        Stats stats = null;
        if (this.isstatisticProvider() && (mon = this.getMonitoringPeerObjectName()) != null) {
            AMX monStats = this.getProxyFactory().getProxy(mon);
            try {
                Extra extra = Util.getExtra(monStats);
                stats = (Stats)extra.getAttribute("stats");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return stats;
    }

    public final String getGroup() {
        return "jsr77";
    }

    protected String getConfigPeerName() {
        return this.getSelfName();
    }

    protected String getMonitoringPeerName() {
        return this.getSelfName();
    }

    protected Map getConfigPeerProps() {
        HashMap<String, String> props = null;
        String j2eeType = this.getConfigPeerJ2EEType();
        if (j2eeType != null) {
            props = new HashMap<String, String>();
            props.put("j2eeType", j2eeType);
            props.put("name", this.getConfigPeerName());
        }
        return props;
    }

    public ObjectName getConfigPeerObjectName() {
        Map propsMap;
        ObjectName configPeerObjectName = null;
        if (this.isConfigProvider() && (propsMap = this.getConfigPeerProps()) != null && (configPeerObjectName = this.queryProps(propsMap)) == null) {
            configPeerObjectName = this.queryConfigPeerFailed(propsMap);
        }
        return configPeerObjectName;
    }

    public boolean isConfigProvider() {
        return ToConfigMap.keySet().contains(this.getSelfJ2EEType());
    }

    public boolean iseventProvider() {
        return false;
    }

    public boolean isstateManageable() {
        return false;
    }

    protected final String[] getContaineeObjectNameStrings(String j2eeType) {
        Set objectNames = this.getContaineeObjectNameSet(j2eeType);
        String[] names = SetUtil.toStringArray(objectNames);
        return names;
    }

    public ObjectName getServerObjectName() {
        ObjectName selfObjectName = this.getObjectName();
        ObjectName serverObjectName = null;
        String serverName = selfObjectName.getKeyProperty("J2EEServer");
        if (serverName != null) {
            String props = Util.makeRequiredProps("J2EEServer", serverName);
            Set candidates = this.getQueryMgr().queryPatternSet(selfObjectName.getDomain(), props);
            serverObjectName = Util.getObjectName((J2EEServer)SetUtil.getSingleton(candidates));
        }
        return serverObjectName;
    }

    public Set getDeployedObjectsObjectNameSet() {
        return this.getContaineeObjectNameSet(DEPLOYED_TYPES);
    }

    public String[] getdeployedObjects() {
        String[] names = SetUtil.toStringArray(this.getDeployedObjectsObjectNameSet());
        return names;
    }

    protected void addCustomMappings(AttributeNameMapper mapper) {
        Iterator iter = this.getDontMapAttributeNames().iterator();
        while (iter.hasNext()) {
            mapper.dontMap((String)iter.next());
        }
    }
}

