/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.j2ee;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.management.j2ee.J2EELogicalServerImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.oldconfig.OldClusterMBean;
import com.sun.enterprise.management.support.oldconfig.OldClustersMBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class J2EEClusterImpl
extends J2EELogicalServerImplBase {
    public J2EEClusterImpl(Delegate delegate) {
        super("X-J2EECluster", delegate);
    }

    public String[] getServerNames() {
        return this.getOldClusterMBean().listServerInstancesAsString(false);
    }

    public Map getServerObjectNameMap() {
        Set serverNamesInCluster = SetUtil.newSet(this.getServerNames());
        if (serverNamesInCluster.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        Set allJ2EEServerObjectNames = this.getQueryMgr().queryJ2EETypeObjectNameSet("J2EEServer");
        Map objectNameMap = Util.createObjectNameMap(allJ2EEServerObjectNames);
        HashMap serverObjectNameMap = new HashMap(serverNamesInCluster.size());
        Iterator it = serverNamesInCluster.iterator();
        while (it.hasNext()) {
            String nameKey = (String)it.next();
            serverObjectNameMap.put(nameKey, objectNameMap.get(nameKey));
        }
        return serverObjectNameMap;
    }

    public boolean isstateManageable() {
        return true;
    }

    public void start() {
        this.trace("J2EEClusterImpl.start");
        this.getOldClusterMBean().start();
        this.setstartTime(System.currentTimeMillis());
    }

    public void startRecursive() {
        this.start();
    }

    public void stop() {
        this.trace("J2EEClusterImpl.start");
        this.getOldClusterMBean().stop();
        this.setstartTime(0L);
    }

    public int getstate() {
        RuntimeStatusList rsl = this.getRuntimeStatus();
        int state = rsl.anyRunning() ? 1 : 3;
        return state;
    }

    private OldClusterMBean getOldClusterMBean() {
        return this.getOldConfigProxies().getOldClusterMBean(this.getSelfName());
    }

    private RuntimeStatusList getRuntimeStatus() {
        OldClustersMBean oldMBean = this.getOldConfigProxies().getOldClustersMBean();
        return (RuntimeStatusList)oldMBean.getRuntimeStatus(this.getSelfName());
    }
}

