/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.WebModuleSupport;
import com.sun.enterprise.management.support.oldconfig.OldConfigsMBean;
import com.sun.enterprise.management.support.oldconfig.OldHTTPServiceMBean;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class VirtualServerConfigFactory
extends ConfigFactory {
    private final Set LEGAL_OPTIONAL_KEYS = SetUtil.newUnmodifiableSet(new String[]{"HTTPListeners", "State", "property.docroot", "property.accesslog"});
    public static final String HOSTS_KEY = "Hosts";

    public VirtualServerConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    protected Set getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap("Name", "id");
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs, Properties props) {
        String target = this.getConfigName();
        OldConfigsMBean oldConfigsMBean = this.getOldConfigProxies().getOldConfigsMBean();
        this.trace("VirtualServerConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        ObjectName objectName = oldConfigsMBean.createVirtualServer(translatedAttrs, props, target);
        return objectName;
    }

    public ObjectName create(String name, String hosts, Map optional) {
        Object[] requiredParams = new Object[]{HOSTS_KEY, hosts};
        if (!WebModuleSupport.isLegalVirtualServerName(name)) {
            throw new IllegalArgumentException(name);
        }
        Map params = this.initParams(name, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    public void internalRemove(ObjectName objectName) {
        OldHTTPServiceMBean oldHTTPServer = this.getOldConfigProxies().getOldHTTPServiceMBean(this.getConfigName());
        String name = Util.getName(objectName);
        oldHTTPServer.removeVirtualServerById(name);
    }
}

