/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldThreadPoolsConfigMBean;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class ThreadPoolConfigFactory
extends ConfigFactory {
    private final Set LEGAL_OPTIONAL_KEYS = SetUtil.newUnmodifiableSet(new String[]{"MinThreadPoolSize", "MaxThreadPoolSize", "IdleThreadTimeoutInSeconds", "NumWorkQueues"});

    public ThreadPoolConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    protected Set getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    private OldThreadPoolsConfigMBean getOldThreadPoolsConfigMBean() {
        return this.getOldConfigProxies().getOldThreadPoolsConfigMBean(this.getConfigName());
    }

    public ObjectName create(String id, Map optional) {
        Map params = this.initParams(id, null, optional);
        ObjectName amxName = this.createNamedChild(id, params);
        return amxName;
    }

    public void internalRemove(ObjectName objectName) {
        String name = Util.getName(objectName);
        this.getOldThreadPoolsConfigMBean().removeThreadPoolByThreadPoolId(name);
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap("Name", "thread-pool-id");
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        ObjectName objectName = this.getOldThreadPoolsConfigMBean().createThreadPool(translatedAttrs);
        return objectName;
    }
}

