/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.jmx.AttributeNameMapper;
import com.sun.enterprise.management.support.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.oldconfig.OldDomainMBean;
import java.util.Map;

public class ServerConfigBase
extends AMXConfigImplBase {
    private static final String TEMPLATE_PREFIX = "${";

    public ServerConfigBase(String j2eeType, Delegate delegate) {
        super(delegate);
    }

    protected void addCustomMappings(AttributeNameMapper mapper) {
        mapper.addMapping("config-ref", "ReferencedConfigName");
        mapper.addMapping("node-agent-ref", "ReferencedNodeAgentName");
    }

    public String getReferencedConfigName() {
        return (String)this.delegateGetAttributeNoThrow("ReferencedConfigName");
    }

    public String getReferencedNodeAgentName() {
        return (String)this.delegateGetAttributeNoThrow("ReferencedNodeAgentName");
    }

    public boolean isTemplateString(String s) {
        return s != null && s.startsWith(TEMPLATE_PREFIX) && s.indexOf("}") >= TEMPLATE_PREFIX.length() + 1;
    }

    public String resolveTemplateString(String template) {
        String result = template;
        if (this.isTemplateString(template)) {
            String myName = this.getName();
            OldDomainMBean oldDomain = this.getOldConfigProxies().getOldDomainMBean();
            try {
                result = oldDomain.resolveTokens(template, myName);
            }
            catch (Exception e) {
                this.getMBeanLogger().fine("Can't resolve: " + template);
                e.printStackTrace();
                throw new IllegalArgumentException(template);
            }
        }
        return result;
    }

    public Map getDeployedItemRefConfigObjectNameMap() {
        return this.getContaineeObjectNameMap("X-DeployedItemRefConfig");
    }

    public Map getResourceRefConfigObjectNameMap() {
        return this.getContaineeObjectNameMap("X-ResourceRefConfig");
    }
}

