/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

class SSLConfigFactory
extends ConfigFactory {
    private final CreateRemoveHook mCreateRemove;
    private final Set LEGAL_OPTIONAL_KEYS = SetUtil.newUnmodifiableSet(new String[]{"CertNickname", "ClientAuthEnabled", "SSL2Ciphers", "SSL3TLSCiphers", "SSL3Enabled", "SSL2Enabled", "TLSEnabled", "TLSRollbackEnabled", "ssl3-tls-ciphers"});
    private static final Map OVERRIDES = Collections.unmodifiableMap(MapUtil.newMap(new String[]{"Name", "CertNickname"}));

    public SSLConfigFactory(ConfigFactoryCallback callbacks, CreateRemoveHook createRemoveHook) {
        super(callbacks);
        this.mCreateRemove = createRemoveHook;
    }

    protected Set getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    protected Map getParamNameOverrides() {
        return OVERRIDES;
    }

    public ObjectName create(String certNickname, Map optional) {
        Map params = certNickname == null ? this.initParams(optional) : this.initParams(certNickname, null, optional);
        this.trace("params as processed: " + this.stringify(params));
        ObjectName amxName = this.createChild(params);
        return amxName;
    }

    protected ObjectName createOldChildConfig(AttributeList attrs) {
        return this.mCreateRemove.createOldSSLConfig(attrs);
    }

    public void remove() {
        ObjectName objectName = this.mCreateRemove.removeOldSSLConfig();
        this.getCallbacks().sendConfigRemovedNotification(objectName);
    }

    public static interface CreateRemoveHook {
        public ObjectName createOldSSLConfig(AttributeList var1);

        public ObjectName removeOldSSLConfig();
    }
}

