/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class MailResourceConfigFactory
extends ResourceFactoryImplBase {
    private final Set LEGAL_OPTIONAL_KEYS = SetUtil.newUnmodifiableSet(new String[]{"StoreProtocol", "StoreProtocolClass", "TransportProtocol", "TransportProtocolClass", "Debug", "Enabled"});
    public static final String HOST_KEY = "Host";
    public static final String USER_KEY = "User";
    public static final String FROM_KEY = "From";

    public MailResourceConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    protected Set getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap("Name", "jndi-name");
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        this.trace("MailResourceConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        ObjectName objectName = this.getOldResourcesMBean().createMailResource(translatedAttrs);
        return objectName;
    }

    public ObjectName create(String jndiName, String host, String user, String from, Map optional) {
        Object[] requiredParams = new Object[]{HOST_KEY, host, USER_KEY, user, FROM_KEY, from};
        Map params = this.initParams(jndiName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(jndiName, params);
        return amxName;
    }

    protected final void removeByName(String name) {
        this.getOldResourcesMBean().removeMailResourceByJndiName(name);
    }
}

