/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class JNDIResourceConfigFactory
extends ResourceFactoryImplBase {
    private static final String JNDI_LOOKUP_NAME_KEY = "JNDILookupName";
    private static final String FACTORY_CLASS_KEY = "FactoryClass";
    private static final String RES_TYPE_KEY = "ResType";

    public JNDIResourceConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        this.trace("JNDIResourceConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        ObjectName objectName = this.getOldResourcesMBean().createExternalJndiResource(translatedAttrs);
        return objectName;
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap("Name", "jndi-name");
    }

    public ObjectName create(String jndiName, String jndiLookupName, String resType, String factoryClass, Map optional) {
        Object[] requiredParams = new Object[]{JNDI_LOOKUP_NAME_KEY, jndiLookupName, RES_TYPE_KEY, resType, FACTORY_CLASS_KEY, factoryClass};
        Map params = this.initParams(jndiName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(jndiName, params);
        return amxName;
    }

    protected void removeByName(String name) {
        this.getOldResourcesMBean().removeExternalJndiResourceByJndiName(name);
    }
}

