/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class JDBCResourceConfigFactory
extends ResourceFactoryImplBase {
    public static String POOL_NAME_KEY = "PoolName";

    public JDBCResourceConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        this.trace("JDBCResourceConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        ObjectName objectName = this.getOldResourcesMBean().createJdbcResource(translatedAttrs);
        return objectName;
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap("Name", "jndi-name");
    }

    public ObjectName create(String jndiName, String poolName, Map optional) {
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)this.getCallbacks().getProxyFactory().getDomainRoot().getDomainConfig().getContainee("X-JDBCConnectionPoolConfig", poolName);
        if (pool == null) {
            throw new IllegalArgumentException("JDBCConnectionPoolConfig does not exit: " + poolName);
        }
        Object[] requiredParams = new Object[]{POOL_NAME_KEY, poolName};
        Map params = this.initParams(jndiName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(jndiName, params);
        return amxName;
    }

    protected void removeByName(String name) {
        this.getOldResourcesMBean().removeJdbcResourceByJndiName(name);
    }
}

