/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldHTTPServiceMBean;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class HTTPListenerConfigFactory
extends ConfigFactory {
    private final OldHTTPServiceMBean mOldHTTPServiceMBean;
    private final Set LEGAL_OPTIONAL_KEYS = SetUtil.newUnmodifiableSet(new String[]{"Address", "Port", "Enabled", "SecurityEnabled", "DefaultVirtualServer", "AcceptorThreads", "XpoweredBy", "XpoweredBy", "IgnoreMissingReferences"});

    public HTTPListenerConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        this.mOldHTTPServiceMBean = this.getOldConfigProxies().getOldHTTPServiceMBean(this.getConfigName());
    }

    protected Set getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap("Name", "id");
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.mOldHTTPServiceMBean.createHttpListener(translatedAttrs);
    }

    private void checkVirtualServerExists(String virtualServerName) {
        HTTPServiceConfig httpService = (HTTPServiceConfig)this.getFactoryContainer();
        Map virtualServers = httpService.getVirtualServerConfigMap();
        if (!virtualServers.containsKey(virtualServerName)) {
            throw new IllegalArgumentException("No virtual server exists with the name: " + virtualServerName);
        }
    }

    public ObjectName create(String name, String address, int port, String defaultVirtualServer, String serverName, Map options) {
        Object[] requiredParams = new Object[]{"Address", address, "Port", new Integer(port), "DefaultVirtualServer", defaultVirtualServer, "ServerName", serverName};
        if (this.requireValidReferences(options)) {
            this.checkVirtualServerExists(defaultVirtualServer);
        }
        Map params = this.initParams(name, requiredParams, options);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    protected final void removeByName(String name) {
        this.mOldHTTPServiceMBean.removeHttpListenerById(name);
    }
}

