/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class ConnectorConnectionPoolConfigFactory
extends ResourceFactoryImplBase {
    public static final String CONNECTION_DEFINITION_NAME_KEY = "ConnectionDefinitionName";
    public static final String RESOURCE_ADAPTER_NAME_KEY = "ResourceAdapterName";
    private final Set LEGAL_OPTIONAL_KEYS = SetUtil.newUnmodifiableSet(new String[]{"SteadyPoolSize", "MaxPoolSize", "MaxWaitTimeMillis", "PoolResizeQuantity", "IdleTimeoutInSeconds", "FailAllConnections", "TransactionSupport", "TransactionSupport", "IgnoreMissingReferences"});

    public ConnectorConnectionPoolConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.getOldResourcesMBean().createConnectorConnectionPool(translatedAttrs);
    }

    protected Set getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    private void checkResourceAdapterExists(String resourceAdapterName) {
        Map resourceAdapters = this.getDomainRoot().getDomainConfig().getResourceAdapterConfigMap();
        if (!resourceAdapters.containsKey(resourceAdapterName)) {
            throw new IllegalArgumentException("No resource adapter exists with the name: " + resourceAdapterName);
        }
    }

    public ObjectName create(String name, String resourceAdapterName, String connectionDefinitionName, Map options) {
        Object[] requiredParams = new Object[]{RESOURCE_ADAPTER_NAME_KEY, resourceAdapterName, CONNECTION_DEFINITION_NAME_KEY, connectionDefinitionName};
        if (this.requireValidReferences(options)) {
            this.checkResourceAdapterExists(resourceAdapterName);
        }
        Map params = this.initParams(name, requiredParams, options);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    protected void removeByName(String name) {
        this.getOldResourcesMBean().removeConnectorConnectionPoolByName(name);
    }
}

