/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldClustersMBean;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

final class ClusterConfigFactory
extends ConfigFactory {
    private final OldClustersMBean mOldClustersMBean = this.getOldConfigProxies().getOldClustersMBean();
    private static final String REFERENCED_CONFIG_NAME = "ReferencedConfigName";

    public ClusterConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs, Properties props) {
        Map m = JMXUtil.attributeListToValueMap(translatedAttrs);
        String config = (String)m.get("config-ref");
        String name = (String)m.get("name");
        return this.mOldClustersMBean.createCluster(name, config, props);
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap(REFERENCED_CONFIG_NAME, "config-ref");
    }

    private void checkConfigExists(String configName) {
        Map configs = this.getDomainConfig().getConfigConfigMap();
        if (!configs.keySet().contains(configName)) {
            throw new IllegalArgumentException("No ConfigConfig exists with the name: " + configName);
        }
    }

    private boolean clusterExists(String name) {
        return this.getDomainConfig().getClusterConfigMap().keySet().contains(name);
    }

    public ObjectName create(String name, String configName, Map optional) {
        if (configName != null) {
            this.checkNonEmptyString(configName, "configName");
            this.checkConfigExists(configName);
            if (configName.equals("server-config") || configName.equals("default-config")) {
                throw new IllegalArgumentException(configName);
            }
        }
        if (this.clusterExists(name)) {
            throw new IllegalArgumentException("Cluster already exists: " + ClusterConfigFactory.quote(name));
        }
        Object[] requiredParams = new Object[]{REFERENCED_CONFIG_NAME, configName};
        Map params = this.initParams(name, requiredParams, optional);
        return this.createNamedChild(name, params);
    }

    public ObjectName create(String name, Map optional) {
        return this.create(name, null, optional);
    }

    protected void internalRemove(ObjectName objectName) {
        String name = Util.getName(objectName);
        if (!this.clusterExists(name)) {
            throw new IllegalArgumentException("No such cluster: " + ClusterConfigFactory.quote(name));
        }
        this.mOldClustersMBean.deleteCluster(name);
    }
}

