/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;

public class VirtualServerTest
extends GenericValidator {
    public VirtualServerTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        try {
            if (cce.getChoice().equals("ADD") || cce.getChoice().equals("OFFLINE")) {
                ConfigContext context = cce.getConfigContext();
                VirtualServer virtual = (VirtualServer)cce.getValidationTarget();
                boolean isNumber = false;
                for (int i = 0; i < 10; ++i) {
                    if (!virtual.getId().startsWith(String.valueOf(i))) continue;
                    isNumber = true;
                }
                if (isNumber) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".errorIdStartNumber", "Attribute (virtual-server-id = {0}) : ID cannot start with a number", new Object[]{virtual.getId()}));
                }
                Config config = (Config)((HttpService)cce.getClassObject()).parent();
                this.validateAttribute(ServerTags.HTTP_LISTENERS, virtual.getHttpListeners(), config, result);
                this.validateAttribute(ServerTags.HOSTS, virtual.getHosts(), config, result);
            } else if (cce.getChoice().equals("UPDATE")) {
                VirtualServer vs = (VirtualServer)cce.getClassObject();
                Config config = (Config)vs.parent().parent();
                String name = cce.getName();
                String value = (String)cce.getObject();
                this.validateAttribute(name, value, config, result);
                if (name.equals(ServerTags.STATE) && !value.equals("on")) {
                    this.checkAllRelatedHttpListenersAreDisabled(vs, result);
                }
            } else if (cce.getChoice().equals("DELETE") && this.isReferenced(cce)) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotDeleteWhenReferenced", "VirtualServer {0} cannot be deleted because it is referenced by {1} peer http listeners", new Object[]{this.getVirtualServer(cce).getId(), new Integer(this.getReferers((VirtualServer)cce.getObject()).size())}));
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "domainxmlverifier.exception", ce);
        }
        return result;
    }

    private boolean isReferenced(ConfigContextEvent cce) throws ConfigException {
        VirtualServer vs = this.getVirtualServer(cce);
        Set listeners = this.getPeerListeners(vs);
        if (listeners.isEmpty()) {
            return false;
        }
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            HttpListener l = (HttpListener)it.next();
            if (!l.getDefaultVirtualServer().equals(vs.getId())) continue;
            return true;
        }
        return false;
    }

    private Set getReferers(VirtualServer vs) throws ConfigException {
        Set listeners = this.getPeerListeners(vs);
        if (listeners.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<HttpListener> result = new HashSet<HttpListener>();
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            HttpListener l = (HttpListener)it.next();
            if (!l.getDefaultVirtualServer().equals(vs.getId())) continue;
            result.add(l);
        }
        return result;
    }

    private Set getPeerListeners(VirtualServer vs) throws ConfigException {
        HttpService hs = (HttpService)vs.parent();
        if (null == hs) {
            return Collections.EMPTY_SET;
        }
        HashSet<HttpListener> result = new HashSet<HttpListener>();
        result.addAll(Arrays.asList(hs.getHttpListener()));
        return result;
    }

    public void validateAttribute(String name, String value, Config config, Result result) {
        int i;
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals(ServerTags.HTTP_LISTENERS)) {
            Vector https = this.tokens(value);
            for (i = 0; i < https.size(); ++i) {
                if (this.isHttpListenerAvailable((String)https.get(i), config)) continue;
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".httplistNotAvl", "Attribute (http-listener={0}) : Http Listener not available", new Object[]{(String)https.get(i)}));
            }
        }
        if (name.equals(ServerTags.HOSTS)) {
            Vector address = this.tokens(value);
            for (i = 0; i < address.size(); ++i) {
                try {
                    StaticTest.checkIPAddressSyntax((String)address.get(i));
                    continue;
                }
                catch (UnknownHostException u) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHostsAddress", "Attribute(hosts={0}) :  Invalid address syntax - {1} ", new Object[]{value, (String)address.get(i)}));
                }
            }
        }
    }

    public boolean isHttpListenerAvailable(String value, Config config) {
        try {
            if (config != null) {
                HttpListener[] http = config.getHttpService().getHttpListener();
                for (int i = 0; i < http.length; ++i) {
                    if (!value.equals(http[i].getId())) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "domainxmlverifier.exception", ex);
        }
        return false;
    }

    public Vector tokens(String value) {
        StringTokenizer token = new StringTokenizer(value, ",");
        Vector<String> test = new Vector<String>();
        while (token.hasMoreTokens()) {
            test.add(token.nextToken());
        }
        return test;
    }

    private final void checkAllRelatedHttpListenersAreDisabled(VirtualServer vs, Result result) throws ConfigException {
        Iterator it = this.getReferers(vs).iterator();
        while (it.hasNext()) {
            HttpListener l = (HttpListener)it.next();
            if (!l.isEnabled()) continue;
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".listenerEnabled", "Cannot disable the virtual server \"{0}\" because this is the default virtual server for the http listener \"{1}\".", new Object[]{vs.getId(), l.getId()}));
        }
    }

    private final VirtualServer getVirtualServer(ConfigContextEvent cce) throws ConfigException {
        return (VirtualServer)cce.getValidationTarget();
    }
}

