/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Orb;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ThreadPool;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;

public class ThreadPoolTest
extends GenericValidator {
    static boolean checked = false;
    int minThreadPoolSize = 0;

    public ThreadPoolTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        ThreadPool pool;
        Result result = super.validate(cce);
        String choice = cce.getChoice();
        if (choice.equals("ADD") || cce.getChoice().equals("OFFLINE")) {
            pool = (ThreadPool)cce.getObject();
            try {
                this.minThreadPoolSize = Integer.parseInt(pool.getMinThreadPoolSize());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.validateAttribute(ServerTags.MAX_THREAD_POOL_SIZE, pool.getMaxThreadPoolSize(), result);
        }
        if (choice.equals("UPDATE")) {
            this.validateAttribute(cce.getName(), (String)cce.getObject(), result);
        }
        if (choice.equals("DELETE")) {
            pool = (ThreadPool)cce.getObject();
            if (this.isThreadPoolReferencedFromOrb(pool, cce.getConfigContext())) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".orbRefsPool", "Thread pool (thread-pool-id={0}) can not be removed. It is referenced from orb element. ", new Object[]{pool.getThreadPoolId()}));
            }
            if (this.isThreadPoolReferencedFromResAdapter(pool, cce.getConfigContext())) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".resource-adapter-config", "Thread pool (thread-pool-id={0}) can not be removed. It is referenced from resource-adapter-config element. ", new Object[]{pool.getThreadPoolId()}));
            }
        }
        return result;
    }

    public void validateAttribute(String name, String value, Result result) {
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals(ServerTags.MIN_THREAD_POOL_SIZE)) {
            try {
                this.minThreadPoolSize = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (name.equals(ServerTags.MAX_THREAD_POOL_SIZE)) {
            try {
                int maxThreadPoolSize = Integer.parseInt(value);
                if (this.minThreadPoolSize > 0 && maxThreadPoolSize < this.minThreadPoolSize) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidMaxThreadPoolSize", "Attribute(max-thread-pool-size={0}) : Invalid, it is lesser than Min Thead Pool Size {1}", new Object[]{value, String.valueOf(this.minThreadPoolSize)}));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public boolean isThreadPoolReferencedFromOrb(ThreadPool pool, ConfigContext context) {
        try {
            String poolId = pool.getThreadPoolId();
            Config config = (Config)pool.parent().parent();
            Orb orb = config.getIiopService().getOrb();
            if (StaticTest.isIdInList(orb.getUseThreadPoolIds(), poolId)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isThreadPoolReferencedFromResAdapter(ThreadPool pool, ConfigContext context) {
        try {
            String poolId = pool.getThreadPoolId();
            Domain domain = (Domain)context.getRootConfigBean();
            Resources resources = domain.getResources();
            ResourceAdapterConfig[] configs = resources.getResourceAdapterConfig();
            if (configs != null) {
                for (int j = 0; j < configs.length; ++j) {
                    if (!StaticTest.isIdInList(configs[j].getThreadPoolIds(), poolId)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

