/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

public class StaticTest {
    public static final String ADD = "ADD";
    public static final String DELETE = "DELETE";
    public static final String UPDATE = "UPDATE";
    public static final String SET = "SET";
    public static final String OFFLINE = "OFFLINE";
    public static boolean fileCheck = false;
    public static boolean classPathCheck = false;
    public static boolean javaHomeCheck = false;
    private static Pattern token_pattern = Pattern.compile("\\$\\{[^}]*}");
    public static final String DAS_CONFIG_NAME = "server-config";
    public static final String CONFIG_TEMPLATE_NAME = "default-config";

    public static void checkIPAddressSyntax(String addr) throws UnknownHostException {
        if (StaticTest.valueContainsTokenExpression(addr) || StaticTest.validSymbolicAddress(addr)) {
            return;
        }
        InetAddress.getByName(addr);
    }

    private static boolean validSymbolicAddress(String address) {
        return address.equalsIgnoreCase("ANY") || address.equalsIgnoreCase("INADDR_ANY") || address.equalsIgnoreCase("localhost");
    }

    public static Config getConfig(ConfigContext context) {
        Config mConfig = null;
        try {
            mConfig = ServerBeansFactory.getConfigBean((ConfigContext)context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mConfig;
    }

    public static boolean isOptionsValid(String options) {
        boolean flag = true;
        StringTokenizer token = new StringTokenizer(options, " ");
        while (token.hasMoreTokens()) {
            if (token.nextToken().startsWith("-")) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static boolean isClassPathValid(String path) {
        boolean flag = true;
        StringTokenizer token = new StringTokenizer(path, File.pathSeparator);
        while (token.hasMoreTokens()) {
            File f = new File(token.nextToken());
            if (!classPathCheck || f.exists()) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static boolean isJavaHomeValid(String path) {
        boolean flag = true;
        if (javaHomeCheck) {
            String jdkPath = path + File.separator + "bin" + File.separatorChar;
            jdkPath = System.getProperty("os.name").startsWith("Win") ? jdkPath + "java.exe" : jdkPath + "java";
            StringTokenizer token = new StringTokenizer(path, File.pathSeparator);
            while (token.hasMoreTokens()) {
                File f = new File(token.nextToken());
                if (f.exists()) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    public static Vector tokens(String value) {
        StringTokenizer token = new StringTokenizer(value, ",");
        Vector<String> test = new Vector<String>();
        while (token.hasMoreTokens()) {
            test.add(token.nextToken().trim());
        }
        return test;
    }

    public static boolean isIdInList(String list, String poolId) {
        return null != poolId && StaticTest.tokens(list + "").contains(poolId);
    }

    static void setJavaHomeCheck(boolean check) {
        javaHomeCheck = true;
    }

    public static boolean valueContainsTokenExpression(Object value) {
        return null != value && value instanceof String && token_pattern.matcher((String)value).lookingAt();
    }
}

