/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.logging.Level;

public class SslTest
extends GenericValidator {
    public SslTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        _logger.log(Level.CONFIG, "SslTest validation");
        Result result = super.validate(cce);
        String choice = cce.getChoice();
        if (choice.equals("UPDATE")) {
            return this.performUpdateChecks(result, cce);
        }
        if (choice.equals("SET")) {
            return this.performSetChecks(result, cce);
        }
        return result;
    }

    private Result performUpdateChecks(Result result, ConfigContextEvent cce) {
        _logger.log(Level.CONFIG, "SslTest performing update check");
        ConfigBean co = (ConfigBean)cce.getClassObject();
        String parentsDtdName = ((ConfigBean)co.parent()).dtdName();
        _logger.log(Level.FINER, "SslTest update - parent's DTD name is \"" + parentsDtdName + "\"");
        _logger.log(Level.FINER, "SslTest update - attribute name is \"" + cce.getName() + "\"");
        _logger.log(Level.FINER, "SslTest update - attribute value is \"" + cce.getObject() + "\"");
        if (parentsDtdName.equals(ServerTags.IIOP_LISTENER) && cce.getName().equals(ServerTags.SSL2_ENABLED) && ((String)cce.getObject()).equalsIgnoreCase("true")) {
            _logger.log(Level.FINER, "SslTest update check - parent is an iiop-listener, and ssl2enabled attribute is being set to true");
            this.ssl2NotAllowed(result);
        }
        return result;
    }

    private Result performSetChecks(Result result, ConfigContextEvent cce) {
        _logger.log(Level.CONFIG, "SsltTest performing set check");
        _logger.log(Level.FINER, "SsltTest set - parent's class is \"" + cce.getClassObject().getClass().getName() + "\"");
        _logger.log(Level.FINER, "SsltTest set - ssl objects ssl2enabled attribute is set: \"" + ((Ssl)cce.getObject()).isSsl2Enabled() + "\"");
        if (cce.getClassObject() instanceof IiopListener && ((Ssl)cce.getObject()).isSsl2Enabled()) {
            _logger.log(Level.FINER, "SsltTest set check - parent is an iiop-listener, and ssl2enabled attribute is being set to true");
            this.ssl2NotAllowed(result);
        }
        return result;
    }

    private void ssl2NotAllowed(Result result) {
        _logger.log(Level.CONFIG, "SslTest - an invalid attempt to enable ssl2 has been found. Returning an error");
        result.failed(this.smh.getLocalString(this.getClass().getName() + ".ssl2NotAllowed", "ssl2 cannot be enabled for an iiop-listener"));
    }
}

