/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;

public class ServerTest
extends GenericValidator {
    public ServerTest(ValidationDescriptor desc) {
        super(desc);
    }

    void validateAdd(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkNameNotAgent(cce, result);
        this.checkConfigRefValidity(cce, result);
    }

    void validateUpdate(ConfigContextEvent cce, Result result) throws ConfigException {
        this.validateAttributeChange(cce, result);
    }

    void validateDelete(ConfigContextEvent cce, Result result) throws ConfigException {
        if (this.isReferenced(cce)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotDeleteWhenReferenced", "Resource {0} cannot be deleted because it is referenced by {1} ResourceRefs", new Object[]{this.getName(cce), new Integer(this.getReferers(cce).size())}));
        }
    }

    protected final String getName(ConfigContextEvent cce) throws ConfigException {
        return this.getServer(cce).getName();
    }

    protected final boolean isReferenced(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.isReferenced((Server)this.getServer(cce), (ConfigContext)cce.getConfigContext());
    }

    protected final Set getReferers(ConfigContextEvent cce) throws ConfigException {
        return ServerBeansFactory.getReferers((Server)this.getServer(cce), (ConfigContext)cce.getConfigContext());
    }

    private void checkNameNotAgent(ConfigContextEvent cce, Result result) throws ConfigException {
        Server s = this.getServer(cce);
        if ("agent".equals(s.getName())) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".illegalServerName", "Illegal Server Name {0}", new Object[]{s.getName()}));
        }
    }

    private Server getServer(ConfigContextEvent cce) throws ConfigException {
        return (Server)cce.getValidationTarget();
    }

    private void preventChangeToNodeAgentRef(ConfigContextEvent cce, Result result) {
        if (cce.getName().equals(ServerTags.NODE_AGENT_REF)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".noChangeToNodeAgentRef", "Cannot change a node agent ref"));
        }
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        boolean flag = false;
        String choice = cce.getChoice();
        try {
            if (choice.equals("SET")) {
                this.validateSet(cce, result);
            } else if (choice.equals("UPDATE")) {
                this.validateUpdate(cce, result);
            } else if (choice.equals("ADD")) {
                this.validateAdd(cce, result);
            } else if (choice.equals("DELETE")) {
                this.validateDelete(cce, result);
            } else if (choice.equals("OFFLINE")) {
                int i;
                int i2;
                Domain domain = (Domain)cce.getConfigContext().getRootConfigBean();
                Servers servers = domain.getServers();
                Server[] server = servers.getServer();
                String svrName = server[0].getName();
                if (!server[0].getName().equals("server")) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidserverName", "Invalid Server Name {0}: Required 'server'", new Object[]{svrName}));
                }
                Applications applications = domain.getApplications();
                J2eeApplication[] j2eeapplication = applications.getJ2eeApplication();
                WebModule[] webmodule = applications.getWebModule();
                AppclientModule[] appclientmodule = applications.getAppclientModule();
                EjbModule[] ejbmodule = applications.getEjbModule();
                LifecycleModule[] lifecyclemodule = applications.getLifecycleModule();
                ConnectorModule[] connectormodule = applications.getConnectorModule();
                Vector<String> vApp = new Vector<String>();
                for (i2 = 0; i2 < j2eeapplication.length; ++i2) {
                    vApp.add(j2eeapplication[i2].getName());
                }
                for (i2 = 0; i2 < webmodule.length; ++i2) {
                    vApp.add(webmodule[i2].getName());
                }
                for (i2 = 0; i2 < appclientmodule.length; ++i2) {
                    vApp.add(appclientmodule[i2].getName());
                }
                for (i2 = 0; i2 < ejbmodule.length; ++i2) {
                    vApp.add(ejbmodule[i2].getName());
                }
                for (i2 = 0; i2 < lifecyclemodule.length; ++i2) {
                    vApp.add(lifecyclemodule[i2].getName());
                }
                for (i2 = 0; i2 < connectormodule.length; ++i2) {
                    vApp.add(connectormodule[i2].getName());
                }
                Resources resources = domain.getResources();
                AdminObjectResource[] adminobject = resources.getAdminObjectResource();
                ConnectorConnectionPool[] connpool = resources.getConnectorConnectionPool();
                ConnectorResource[] connresource = resources.getConnectorResource();
                CustomResource[] customresource = resources.getCustomResource();
                ExternalJndiResource[] externalresource = resources.getExternalJndiResource();
                JdbcConnectionPool[] jdbcconnpool = resources.getJdbcConnectionPool();
                JdbcResource[] jdbcresource = resources.getJdbcResource();
                MailResource[] mailresource = resources.getMailResource();
                PersistenceManagerFactoryResource[] persistence = resources.getPersistenceManagerFactoryResource();
                ResourceAdapterConfig[] resourceconfig = resources.getResourceAdapterConfig();
                Vector<String> vRes = new Vector<String>();
                for (i = 0; i < adminobject.length; ++i) {
                    vRes.add(adminobject[i].getJndiName());
                }
                for (i = 0; i < connpool.length; ++i) {
                    vRes.add(connpool[i].getName());
                }
                for (i = 0; i < connresource.length; ++i) {
                    vRes.add(connresource[i].getJndiName());
                }
                for (i = 0; i < customresource.length; ++i) {
                    vRes.add(customresource[i].getJndiName());
                }
                for (i = 0; i < externalresource.length; ++i) {
                    vRes.add(externalresource[i].getJndiName());
                }
                for (i = 0; i < jdbcconnpool.length; ++i) {
                    vRes.add(jdbcconnpool[i].getName());
                }
                for (i = 0; i < jdbcresource.length; ++i) {
                    vRes.add(jdbcresource[i].getJndiName());
                }
                for (i = 0; i < mailresource.length; ++i) {
                    vRes.add(mailresource[i].getJndiName());
                }
                for (i = 0; i < persistence.length; ++i) {
                    vRes.add(persistence[i].getJndiName());
                }
                for (i = 0; i < resourceconfig.length; ++i) {
                    vRes.add(resourceconfig[i].getName());
                }
                for (int num = 0; num < server.length; ++num) {
                    String name = server[num].getConfigRef();
                    Configs configs = domain.getConfigs();
                    Config[] config = configs.getConfig();
                    for (int i3 = 0; i3 < config.length; ++i3) {
                        if (!name.equals(config[i3].getName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".configRefNotAvl", "config-ref {0} not available in config", new Object[]{name}));
                    }
                    ApplicationRef[] appref = server[num].getApplicationRef();
                    for (int i4 = 0; i4 < appref.length; ++i4) {
                        flag = false;
                        for (int j = 0; j < vApp.size(); ++j) {
                            if (!appref[i4].getRef().equals(vApp.get(j))) continue;
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidAppRef", "application-ref {0} is not available in applications", new Object[]{appref[i4].getRef()}));
                    }
                    ResourceRef[] resref = server[num].getResourceRef();
                    for (int i5 = 0; i5 < resref.length; ++i5) {
                        flag = false;
                        for (int j = 0; j < vRes.size(); ++j) {
                            if (!resref[i5].getRef().equals(vRes.get(j))) continue;
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidResRef", "resource-ref {0} is not available in resources", new Object[]{resref[i5].getRef()}));
                    }
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "domainxmlverifier.exception", e);
        }
        return result;
    }

    private void validateSet(ConfigContextEvent cce, Result result) throws ConfigException {
        this.validateAttributeChange(cce, result);
    }

    private void validateAttributeChange(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkNameNotAgent(cce, result);
        this.preventChangeToNodeAgentRef(cce, result);
        if (this.isReferenced(cce)) {
            this.preventChangeToConfigRef(cce, result);
        } else {
            this.preventInvalidConfigRef(cce, result);
        }
    }

    private final void preventInvalidConfigRef(ConfigContextEvent cce, Result result) throws ConfigException {
        if (cce.getName().equals(ServerTags.CONFIG_REF)) {
            this.checkConfigRefValidity((String)cce.getObject(), result);
        }
    }

    private final void checkConfigRefValidity(ConfigContextEvent cce, Result result) throws ConfigException {
        this.checkConfigRefValidity(this.getServer(cce).getConfigRef(), result);
    }

    private void checkConfigRefValidity(String config_ref, Result result) {
        if (config_ref.equals("server-config")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotHaveDASasConfig", "The configuration of the Domain Administration Server (named {0}) cannot be referenced by a server", new Object[]{"server-config"}));
        } else if (config_ref.equals("default-config")) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotHaveTemplateConfig", "The default configuration template (named {0}) cannot be referenced by a server", new Object[]{"default-config"}));
        }
    }

    private void preventChangeToConfigRef(ConfigContextEvent cce, Result result) {
        if (cce.getName().equals(ServerTags.CONFIG_REF)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".noChangeToConfigRefInCluster", "Cannot change a config-ref when the instance is part of a cluster"));
        }
    }
}

